/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectoryScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryScanner.class);
    private final List<String> m_ignoreDirectories;
    private final boolean m_scanArchives;
    private TFile m_rootPathBeingScanned;

    public DirectoryScanner(List<String> ignoreDirectories, boolean scanArchives) {
        assert (ignoreDirectories != null) : "'ignoreDirectories' must not be null";
        this.m_ignoreDirectories = ignoreDirectories;
        this.m_scanArchives = scanArchives;
    }

    private boolean includeDirectory(IFileConsumer consumer, TFile nextPath) {
        if (this.m_ignoreDirectories != null) {
            for (String next : this.m_ignoreDirectories) {
                if (!next.equals(nextPath.getName())) continue;
                return false;
            }
        }
        return consumer.includeDirectory(nextPath);
    }

    private void scanPath(TFile path, IFileConsumer consumer, boolean inArchive) {
        assert (path != null) : "'path' must not be null";
        assert (consumer != null) : "'consumer' must not be null";
        if (consumer.continueScanning(this.m_rootPathBeingScanned, path)) {
            TFile[] fileList = path.listFiles();
            if (fileList != null) {
                TFile[] tFileArray = fileList;
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileType fileType;
                    boolean newInArchive;
                    TFile nextPath = tFileArray[n2];
                    boolean isArchive = inArchive ? nextPath.isArchive() : FileUtility.isArchive(nextPath);
                    boolean bl = newInArchive = inArchive || isArchive;
                    if (isArchive) {
                        if (this.m_scanArchives) {
                            this.scanPath(nextPath, consumer, newInArchive);
                        }
                    } else if (nextPath.isDirectory()) {
                        if (this.includeDirectory(consumer, nextPath)) {
                            this.scanPath(nextPath, consumer, newInArchive);
                        }
                    } else if (nextPath.isFile() && (fileType = consumer.accepts(nextPath)) != null) {
                        consumer.consume(this.m_rootPathBeingScanned, nextPath, fileType);
                    }
                    ++n2;
                }
            } else {
                LOGGER.warn("Path does not exist or an I/O exception occured: " + path.getAbsolutePath());
            }
        }
    }

    public void scan(TFile path, IFileConsumer consumer) {
        assert (path != null) : "'path' must not be null";
        assert (path.isDirectory() || !this.m_scanArchives || path.isArchive()) : "'path' may not have children: " + String.valueOf(path);
        assert (consumer != null) : "'consumer' must not be null";
        try {
            this.m_rootPathBeingScanned = path;
            this.scanPath(path, consumer, FileUtility.isArchive(path));
        }
        finally {
            this.m_rootPathBeingScanned = null;
        }
    }

    public static interface IFileConsumer {
        public IFileType accepts(TFile var1);

        public void consume(TFile var1, TFile var2, IFileType var3);

        default public boolean continueScanning(TFile rootPathBeingScanned, TFile path) {
            return true;
        }

        default public boolean includeDirectory(TFile dir) {
            return true;
        }
    }
}

