/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlSlurper {
    private final DocumentBuilder m_builder;
    private final XPath m_xpath;
    private Document m_document;

    public XmlSlurper() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        this.m_builder = factory.newDocumentBuilder();
        XPathFactory xpathfactory = XPathFactory.newInstance();
        this.m_xpath = xpathfactory.newXPath();
    }

    public void parse(InputStream is) throws SAXException, IOException {
        assert (is != null) : "Parameter 'is' of method 'parse' must not be null";
        this.m_document = this.m_builder.parse(is);
    }

    public void parse(String string) throws SAXException, IOException {
        assert (string != null && string.length() > 0) : "Parameter 'string' of method 'parse' must not be empty";
        this.m_document = this.m_builder.parse(new InputSource(new StringReader(string)));
    }

    public void printDocument(OutputStream out) throws IOException, TransformerException {
        assert (out != null) : "Parameter 'out' of method 'printDocument' must not be null";
        assert (this.m_document != null) : "Call method parse first";
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(this.m_document), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    public String getRootName() {
        assert (this.m_document != null) : "Call method parse first";
        Node rootNode = this.getRootNode();
        String nodeName = rootNode.getNodeName();
        return this.stripNamespace(nodeName);
    }

    public Node getRootNode() {
        assert (this.m_document != null) : "Call method parse first";
        try {
            return this.getNode("/*");
        }
        catch (XPathExpressionException xpee) {
            assert (false) : "Illegal XPath expression" + xpee.getMessage();
            return null;
        }
    }

    public String getString(Node parent, String xpath) throws XPathExpressionException {
        assert (parent != null) : "Parameter 'parent' of method 'getString' must not be null";
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getString' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        return (String)this.compileXpath(xpath).evaluate(parent, XPathConstants.STRING);
    }

    public String getString(String xpath) throws XPathExpressionException {
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getString' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        return this.getString(this.m_document, xpath);
    }

    public int getInteger(String xpath) throws XPathExpressionException {
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getInteger' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        return ((Double)this.compileXpath(xpath).evaluate(this.m_document, XPathConstants.NUMBER)).intValue();
    }

    public boolean getBoolean(String xpath) throws XPathExpressionException {
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getBoolean' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        return (Boolean)this.compileXpath(xpath).evaluate(this.m_document, XPathConstants.BOOLEAN);
    }

    private Node getNode(String xpath) throws XPathExpressionException {
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getNode' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        return (Node)this.compileXpath(xpath).evaluate(this.m_document, XPathConstants.NODE);
    }

    public Element getElement(String xpath) throws XPathExpressionException {
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getElement' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        return (Element)this.compileXpath(xpath).evaluate(this.m_document, XPathConstants.NODE);
    }

    private NodeList getNodeList(Node parent, String xpath) throws XPathExpressionException {
        assert (parent != null) : "Parameter 'parent' of method 'getNodeList' must not be null";
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getNodeList' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        return (NodeList)this.compileXpath(xpath).evaluate(parent, XPathConstants.NODESET);
    }

    private NodeList getNodeList(String xpath) throws XPathExpressionException {
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getNodeList' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        return (NodeList)this.compileXpath(xpath).evaluate(this.m_document, XPathConstants.NODESET);
    }

    public List<Element> getElementList(Node parent, String xpath) throws XPathExpressionException {
        assert (parent != null) : "Parameter 'parent' of method 'getElementList' must not be null";
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getElementList' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = this.getNodeList(parent, xpath);
        int i = 0;
        while (i < nodeList.getLength()) {
            result.add((Element)nodeList.item(i).cloneNode(true));
            ++i;
        }
        return result;
    }

    public List<Element> getElementList(String xpath) throws XPathExpressionException {
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'getElementList' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = this.getNodeList(xpath);
        int i = 0;
        while (i < nodeList.getLength()) {
            result.add((Element)nodeList.item(i).cloneNode(true));
            ++i;
        }
        return result;
    }

    public List<Element> getAllIdNodes() {
        ArrayList<Element> result;
        block4: {
            assert (this.m_document != null) : "Call method parse first";
            result = new ArrayList<Element>();
            try {
                NodeList nodes = this.getNodeList("*[@id]");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element node = (Element)nodes.item(i).cloneNode(true);
                    result.add(node);
                    ++i;
                }
            }
            catch (XPathExpressionException xpee) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)("Illegal XPath expression" + xpee.getMessage()));
            }
        }
        return result;
    }

    public List<String> getAllIds() {
        assert (this.m_document != null) : "Call method parse first";
        ArrayList<String> result = new ArrayList<String>();
        for (Element node : this.getAllIdNodes()) {
            result.add(node.getAttribute("id"));
        }
        return result;
    }

    private XPathExpression compileXpath(String xpath) throws XPathExpressionException {
        assert (xpath != null && xpath.length() > 0) : "Parameter 'xpath' of method 'compileXpath' must not be empty";
        return this.m_xpath.compile(xpath);
    }

    private String stripNamespace(String nodeName) {
        assert (nodeName != null && nodeName.length() > 0) : "Parameter 'nodeName' of method 'stripNamespace' must not be empty";
        assert (this.m_document != null) : "Call method parse first";
        int nsDelimiter = nodeName.indexOf(58);
        if (nsDelimiter == -1) {
            return nodeName;
        }
        return nodeName.substring(nsDelimiter + 1);
    }
}

