/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxySettings {
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final int DEFAULT_HTTP_PROXY_PORT = 80;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySettings.class);
    private String m_host = "";
    private int m_port = 80;
    private String m_userName = "";
    private String m_password = "";

    public ProxySettings copy() {
        ProxySettings copy = new ProxySettings();
        copy.setHost(this.m_host);
        copy.setPort(this.m_port);
        copy.setUserName(this.m_userName);
        copy.setPassword(this.m_password);
        return copy;
    }

    public void reset() {
        this.m_host = "";
        this.m_port = 80;
        this.m_userName = "";
        this.m_password = "";
    }

    public boolean inResetState() {
        return this.m_host.equals("") && this.m_port == 80 && this.m_userName.equals("") && this.m_password.equals("");
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setHost(String host) {
        assert (host != null) : "Parameter 'host' of method 'setHost' must not be null";
        this.m_host = host;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setUserName(String user) {
        assert (user != null) : "Parameter 'userName' of method 'setUserName' must not be null";
        this.m_userName = user;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public void setPassword(String password) {
        assert (password != null) : "Parameter 'password' of method 'setPassword' must not be null";
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public boolean hasHost() {
        return !this.m_host.isEmpty();
    }

    public boolean hasCredentials() {
        return !this.m_userName.isEmpty();
    }

    public boolean isValid() {
        return this.m_host != null && !this.m_host.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_host.hashCode();
        result = 31 * result + this.m_password.hashCode();
        result = 31 * result + this.m_port;
        result = 31 * result + this.m_userName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProxySettings other = (ProxySettings)obj;
        return this.m_host.equals(other.m_host) && this.m_port == other.m_port && this.m_userName.equals(other.m_userName) && this.m_password.equals(other.m_password);
    }

    public String toString() {
        return "'" + this.m_host + "' [" + this.m_port + "]" + (String)(this.hasCredentials() ? " ('" + this.m_userName + (!this.m_password.isEmpty() ? "','****'" : "'") + ")" : "");
    }

    public static ProxySettings create(String host, String port, String user, String password) {
        ProxySettings proxySettings = new ProxySettings();
        if (host != null && host.trim().length() > 0) {
            proxySettings.setHost(host.trim());
        }
        if (user != null && user.trim().length() > 0) {
            proxySettings.setUserName(user.trim());
        }
        if (password != null && password.trim().length() > 0) {
            proxySettings.setPassword(password.trim());
        }
        try {
            if (port != null && port.trim().length() > 0) {
                int portAsInt = Integer.parseInt(port.trim());
                proxySettings.setPort(portAsInt);
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Ignoring invalid port: " + port);
        }
        return proxySettings;
    }
}

