/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Platform {
    private static final String UNKNOWN = "unknown";
    private static final String VENDOR_IBM = "ibm corporation";
    private static final String VENDOR_ORACLE = "oracle";
    private static final Logger LOGGER = LoggerFactory.getLogger(Platform.class);
    private static final String PROPERTY_OS_NAME = System.getProperty("os.name", "unknown").trim();
    private static final String PROPERTY_OS_ARCH = System.getProperty("os.arch", "unknown").trim();
    private static final String PROPERTY_OS_VERSION = System.getProperty("os.version", "unknown").trim();
    private static final String PROPERTY_JAVA_VENDOR = System.getProperty("java.vendor", "unknown").trim();
    private static final String PROPERTY_JAVA_VERSION;
    private static final String PROPERTY_JRE_VERSION;
    private static final OperatingSystem OS;
    private static final int JAVA_VERSION;
    private static final String PATH;

    static {
        PROPERTY_JRE_VERSION = System.getProperty("java.version", UNKNOWN).trim();
        PROPERTY_JAVA_VERSION = System.getProperty("java.specification.version", UNKNOWN).trim();
        OperatingSystem os = null;
        String osName = PROPERTY_OS_NAME.toLowerCase();
        String osArch = PROPERTY_OS_ARCH.toLowerCase();
        if (osName.indexOf("windows") != -1) {
            os = osArch.indexOf("aarch64") != -1 || osArch.indexOf("arm") != -1 ? OperatingSystem.WINDOWS_ARM_64 : (osArch.indexOf("64") != -1 ? OperatingSystem.WINDOWS_64 : OperatingSystem.WINDOWS_32);
        } else if (osName.indexOf("linux") != -1) {
            os = osArch.indexOf("aarch64") != -1 || osArch.indexOf("arm") != -1 ? OperatingSystem.LINUX_ARM_64 : (osArch.indexOf("64") != -1 ? OperatingSystem.LINUX_64 : OperatingSystem.LINUX_32);
        } else if (osName.indexOf("mac") > -1 && osName.indexOf("x") > -1) {
            if (osArch.indexOf("aarch64") != -1 || osArch.indexOf("arm") != -1) {
                os = OperatingSystem.MAC_ARM_64;
            } else {
                OperatingSystem operatingSystem = os = osArch.indexOf("64") != -1 ? OperatingSystem.MAC_64 : OperatingSystem.MAC_32;
            }
        }
        if (os == null) {
            os = OperatingSystem.UNKNOWN_OS;
            LOGGER.warn("Unknown operating system: " + PROPERTY_OS_NAME + " [" + System.getProperty("sun.arch.data.model", UNKNOWN) + "]");
        }
        OS = os;
        switch (PROPERTY_JAVA_VERSION) {
            case "1.5": {
                JAVA_VERSION = 5;
                break;
            }
            case "1.6": {
                JAVA_VERSION = 6;
                break;
            }
            case "1.7": {
                JAVA_VERSION = 7;
                break;
            }
            case "1.8": {
                JAVA_VERSION = 8;
                break;
            }
            default: {
                int asInt = -1;
                try {
                    asInt = Integer.parseInt(PROPERTY_JAVA_VERSION);
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("Unable to parse Java version: " + PROPERTY_JAVA_VERSION);
                }
                JAVA_VERSION = asInt;
            }
        }
        String path = System.getenv("PATH");
        if (path == null) {
            path = System.getenv("Path");
        }
        PATH = path != null ? path : "";
    }

    private Platform() {
    }

    public static String getJavaVendor() {
        return PROPERTY_JAVA_VENDOR;
    }

    public static String getOperatingSystemName() {
        return PROPERTY_OS_NAME;
    }

    public static OperatingSystem getOperatingSystem() {
        return OS;
    }

    public static int getJavaVersion() {
        return JAVA_VERSION;
    }

    public static String getJavaVersionAsString() {
        return JAVA_VERSION != -1 ? Integer.toString(JAVA_VERSION) : UNKNOWN;
    }

    public static String getPath() {
        return PATH;
    }

    public static String getUserName() {
        String result = null;
        try {
            String vendorLowerCase = PROPERTY_JAVA_VENDOR.toLowerCase();
            if (vendorLowerCase.startsWith(VENDOR_ORACLE)) {
                switch (Platform.getOperatingSystem()) {
                    case WINDOWS_32: 
                    case WINDOWS_64: 
                    case WINDOWS_ARM_64: {
                        Class<?> windowsSystemClass = Class.forName("com.sun.security.auth.module.NTSystem");
                        result = (String)windowsSystemClass.getMethod("getName", new Class[0]).invoke(windowsSystemClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
                        break;
                    }
                    case LINUX_32: 
                    case LINUX_64: 
                    case LINUX_ARM_64: 
                    case MAC_32: 
                    case MAC_64: 
                    case MAC_ARM_64: {
                        Class<?> unixSystemClass = Class.forName("com.sun.security.auth.module.UnixSystem");
                        result = (String)unixSystemClass.getMethod("getUsername", new Class[0]).invoke(unixSystemClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
                        break;
                    }
                }
            } else if (vendorLowerCase.startsWith(VENDOR_IBM)) {
                switch (Platform.getOperatingSystem()) {
                    case WINDOWS_32: 
                    case WINDOWS_64: 
                    case WINDOWS_ARM_64: {
                        Class<?> windowsSystemClass = Class.forName("com.ibm.security.auth.module.NTSystem");
                        result = (String)windowsSystemClass.getMethod("getName", new Class[0]).invoke(windowsSystemClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
                        break;
                    }
                    case LINUX_32: 
                    case LINUX_64: 
                    case LINUX_ARM_64: {
                        Class<?> linuxSystemClass = Class.forName("com.ibm.security.auth.module.LinuxSystem");
                        result = (String)linuxSystemClass.getMethod("getUsername", new Class[0]).invoke(linuxSystemClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (InvocationTargetException ite) {
            LOGGER.warn(ite.getCause().getMessage());
        }
        catch (Throwable t) {
            LOGGER.warn("Cannot get user name from operating system: ", t);
        }
        if (result == null) {
            result = System.getProperty("user.name");
        }
        return result != null ? result : "Unknown";
    }

    public static boolean isOperatingSystem64Bit() {
        switch (Platform.getOperatingSystem()) {
            case WINDOWS_32: 
            case LINUX_32: 
            case MAC_32: 
            case UNKNOWN_OS: {
                return false;
            }
            case WINDOWS_64: 
            case WINDOWS_ARM_64: 
            case LINUX_64: 
            case LINUX_ARM_64: 
            case MAC_64: 
            case MAC_ARM_64: {
                return true;
            }
        }
        assert (false) : "Unhandled OS: " + String.valueOf(Platform.getOperatingSystem());
        return false;
    }

    public static boolean isOperatingSystemCaseSensitive() {
        switch (Platform.getOperatingSystem()) {
            case LINUX_32: 
            case LINUX_64: 
            case LINUX_ARM_64: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOperatingSystemUnixBased() {
        switch (Platform.getOperatingSystem()) {
            case LINUX_32: 
            case LINUX_64: 
            case LINUX_ARM_64: 
            case MAC_32: 
            case MAC_64: 
            case MAC_ARM_64: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMac() {
        switch (Platform.getOperatingSystem()) {
            case MAC_32: 
            case MAC_64: 
            case MAC_ARM_64: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLinux() {
        switch (Platform.getOperatingSystem()) {
            case LINUX_32: 
            case LINUX_64: 
            case LINUX_ARM_64: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWindows() {
        switch (Platform.getOperatingSystem()) {
            case WINDOWS_32: 
            case WINDOWS_64: 
            case WINDOWS_ARM_64: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCaseSensitive() {
        return Platform.isLinux();
    }

    public static List<String> getEnvironmentInfo() {
        ArrayList<String> envInfo = new ArrayList<String>();
        envInfo.add("OS: " + OS.getPresentationName() + " " + PROPERTY_OS_VERSION + " [" + PROPERTY_OS_NAME + ", " + PROPERTY_OS_ARCH + "]");
        envInfo.add("Java: " + PROPERTY_JAVA_VENDOR + " " + PROPERTY_JRE_VERSION + " [" + PROPERTY_JAVA_VERSION + "]");
        envInfo.add("Path: " + PATH);
        if (Platform.isLinux()) {
            envInfo.add("GTK: " + System.getProperty("org.eclipse.swt.internal.gtk.theme") + " [" + System.getProperty("org.eclipse.swt.internal.gtk.version") + "]");
        }
        return envInfo;
    }

    public static final class OperatingSystem
    extends Enum<OperatingSystem>
    implements IStandardEnumeration {
        public static final /* enum */ OperatingSystem WINDOWS_32 = new OperatingSystem("Windows X86");
        public static final /* enum */ OperatingSystem WINDOWS_64 = new OperatingSystem("Windows X86-64");
        public static final /* enum */ OperatingSystem WINDOWS_ARM_64 = new OperatingSystem("Windows ARM64");
        public static final /* enum */ OperatingSystem LINUX_32 = new OperatingSystem("Linux X86");
        public static final /* enum */ OperatingSystem LINUX_64 = new OperatingSystem("Linux X86-64");
        public static final /* enum */ OperatingSystem LINUX_ARM_64 = new OperatingSystem("Linux ARM64");
        public static final /* enum */ OperatingSystem MAC_32 = new OperatingSystem("Mac X86");
        public static final /* enum */ OperatingSystem MAC_64 = new OperatingSystem("Mac X86-64");
        public static final /* enum */ OperatingSystem MAC_ARM_64 = new OperatingSystem("Mac ARM64");
        public static final /* enum */ OperatingSystem UNKNOWN_OS = new OperatingSystem("unknown");
        private final String m_presentationName;
        private static final /* synthetic */ OperatingSystem[] ENUM$VALUES;

        static {
            ENUM$VALUES = new OperatingSystem[]{WINDOWS_32, WINDOWS_64, WINDOWS_ARM_64, LINUX_32, LINUX_64, LINUX_ARM_64, MAC_32, MAC_64, MAC_ARM_64, UNKNOWN_OS};
        }

        private OperatingSystem(String presentationName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'OperatingSystem' must not be empty";
            this.m_presentationName = presentationName;
        }

        public static OperatingSystem fromStandardName(String standardName) throws IllegalArgumentException {
            assert (standardName != null) : "'standardName' must not be null";
            assert (standardName.length() > 0) : "'standardName' must not be empty";
            String name = StringUtility.convertStandardNameToConstantName(standardName);
            return OperatingSystem.valueOf(name);
        }

        @Override
        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName(this.name());
        }

        @Override
        public String getPresentationName() {
            return this.m_presentationName;
        }

        public static OperatingSystem[] values() {
            OperatingSystem[] operatingSystemArray = ENUM$VALUES;
            int n = operatingSystemArray.length;
            OperatingSystem[] operatingSystemArray2 = new OperatingSystem[n];
            System.arraycopy(ENUM$VALUES, 0, operatingSystemArray2, 0, n);
            return operatingSystemArray2;
        }

        public static OperatingSystem valueOf(String string) {
            return Enum.valueOf(OperatingSystem.class, string);
        }
    }
}

