/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.text;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;

public final class IntBasedHash {
    private final int[] m_hash;

    public IntBasedHash(int[] hash) {
        assert (hash != null) : "hash may not be null";
        this.m_hash = hash;
    }

    public int[] getArray() {
        return this.m_hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntBasedHash)) {
            return false;
        }
        return Arrays.equals(this.m_hash, ((IntBasedHash)o).m_hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_hash);
    }

    public int length() {
        return this.m_hash.length;
    }

    public static String encode(IntBasedHash hash) {
        assert (hash != null) : "Parameter 'hash' of method 'encode' must not be null";
        int[] codes = hash.getArray();
        ByteBuffer buffer = ByteBuffer.allocate(4 * codes.length);
        int i = 0;
        while (i < codes.length) {
            buffer.putInt(codes[i]);
            ++i;
        }
        buffer.flip();
        return Base64.getEncoder().encodeToString(buffer.array());
    }

    public static IntBasedHash decode(String base64Encoded) {
        assert (base64Encoded != null && base64Encoded.length() > 0) : "Parameter 'base64Encoded' of method 'decode' must not be empty";
        try {
            byte[] decodeBuffer = Base64.getDecoder().decode(base64Encoded);
            int[] result = new int[decodeBuffer.length / 4];
            ByteBuffer buffer = ByteBuffer.allocate(4);
            int i = 0;
            int k = 0;
            while (i < decodeBuffer.length) {
                buffer.put(decodeBuffer, i, 4);
                buffer.flip();
                result[k] = buffer.getInt();
                buffer.flip();
                i += 4;
                ++k;
            }
            return new IntBasedHash(result);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

