/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.propertyreader;

import gnu.trove.map.hash.THashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionBasedPropertyReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionBasedPropertyReader.class);
    private final Map<String, Method> m_getterMap = new THashMap();

    public ReflectionBasedPropertyReader(Class<?> cls) {
        assert (cls != null) : "Parameter 'cls' of method 'AnnotatedPropertyMap' must not be null";
        Method[] methodArray = cls.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                int prefixLength;
                String name;
                Method nextMethod;
                block8: {
                    block7: {
                        nextMethod = methodArray[n2];
                        Class<?>[] paramTypes = nextMethod.getParameterTypes();
                        if (paramTypes.length >= 1) break block6;
                        name = nextMethod.getName();
                        if (!name.startsWith("get")) break block7;
                        prefixLength = 3;
                        break block8;
                    }
                    if (!name.startsWith("is")) break block6;
                    prefixLength = 2;
                }
                String propertyName = Character.toLowerCase(name.charAt(prefixLength)) + name.substring(prefixLength + 1);
                this.m_getterMap.put(propertyName, nextMethod);
                if (prefixLength == 2) {
                    this.m_getterMap.put(name, nextMethod);
                }
            }
            ++n2;
        }
    }

    public Object readProperty(Object obj, String propertyName) {
        assert (obj != null) : "Parameter 'obj' of method 'readProperty' must not be null";
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'readProperty' must not be empty";
        Method getter = this.m_getterMap.get(propertyName);
        if (getter == null) {
            return null;
        }
        Object result = null;
        getter.setAccessible(true);
        try {
            result = getter.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOGGER.error("Cannot access property '" + propertyName + "' of class " + obj.getClass().getName(), (Throwable)e);
        }
        return result;
    }

    public boolean hasProperty(String propertyName) {
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'hasProperty' must not be empty";
        return this.m_getterMap.containsKey(propertyName);
    }
}

