/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.propertyreader;

import com.hello2morrow.sonargraph.foundation.propertyreader.AnnotatedPropertyMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AnnotatedPropertyReader {
    private final Map<Class<?>, AnnotatedPropertyMap> m_readerMap = new HashMap();

    private AnnotatedPropertyMap getMapFor(Class<?> cls) {
        assert (cls != null) : "Parameter 'cls' of method 'getMapFor' must not be null";
        AnnotatedPropertyMap map = this.m_readerMap.get(cls);
        if (map == null) {
            map = new AnnotatedPropertyMap(cls);
            this.m_readerMap.put(cls, map);
        }
        return map;
    }

    public <T> T getProperty(Object obj, String propertyName, Class<T> expectedType) {
        assert (obj != null) : "'obj' must not be null";
        assert (propertyName != null) : "Parameter 'propertyName' of method 'getProperty' must not be null";
        assert (expectedType != null) : "Parameter 'expectedType' of method 'getProperty' must not be null";
        return (T)this.getMapFor(obj.getClass()).getPropertyValue(obj, propertyName);
    }

    public Object getPropertyType(Class<?> cls, String propertyName) {
        assert (cls != null) : "Parameter 'cls' of method 'getPropertyType' must not be null";
        assert (propertyName != null) : "Parameter 'propertyName' of method 'getPropertyType' must not be null";
        return this.getMapFor(cls).getPropertyType(propertyName);
    }

    public boolean hasProperty(Object obj, String propertyName) {
        assert (obj != null) : "Parameter 'obj' of method 'hasProperty' must not be null";
        assert (propertyName != null) : "Parameter 'propertyName' of method 'hasProperty' must not be null";
        return this.getProperty(obj, propertyName, Object.class) != null;
    }

    public Map<String, Object> getProperties(Object obj) {
        assert (obj != null) : "'obj' must not be null";
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        AnnotatedPropertyMap map = this.getMapFor(obj.getClass());
        for (String key : map.propertySet()) {
            Object val = map.getPropertyValue(obj, key);
            if (val == null) continue;
            result.put(key, val);
        }
        return result;
    }
}

