/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SearchPath {
    private final List<TFile> m_searchPath = new ArrayList<TFile>();
    private final ArchiveDetection m_archiveDetection;

    public SearchPath() {
        this.m_archiveDetection = ArchiveDetection.YES;
    }

    public SearchPath(TFile ... directories) {
        TFile[] tFileArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            TFile dir = tFileArray[n2];
            this.add(dir);
            ++n2;
        }
        this.m_archiveDetection = ArchiveDetection.YES;
    }

    public SearchPath(String ... directories) {
        assert (directories != null) : "directories must not be null";
        String[] stringArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            String dirName = stringArray[n2];
            TFile dir = new TFile(dirName);
            this.add(dir);
            ++n2;
        }
        this.m_archiveDetection = ArchiveDetection.YES;
    }

    public SearchPath(List<TFile> directories) {
        for (TFile dir : directories) {
            this.add(dir);
        }
        this.m_archiveDetection = ArchiveDetection.YES;
    }

    public SearchPath(List<TFile> directories, ArchiveDetection archiveDetection) {
        for (TFile dir : directories) {
            this.add(dir);
        }
        this.m_archiveDetection = archiveDetection;
    }

    public List<TFile> getDirectories() {
        return Collections.unmodifiableList(this.m_searchPath);
    }

    public void add(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'add' must not be null";
        if (!this.m_searchPath.contains(dir)) {
            this.m_searchPath.add(dir);
        }
    }

    public void add(String dirName) {
        TFile dir = new TFile(dirName);
        this.add(dir);
    }

    public TFile locateFile(String fileName) {
        for (TFile dir : this.m_searchPath) {
            TFile f = new TFile((File)dir, fileName);
            if (!f.canRead()) continue;
            return f;
        }
        return null;
    }

    public TFile locateFileOrDirectory(String name) {
        for (TFile dir : this.m_searchPath) {
            TFile f = new TFile((File)dir, name);
            if (!f.isDirectory() && !f.isFile()) continue;
            return f;
        }
        return null;
    }

    public List<TFile> locateFiles(String regex) {
        assert (regex != null && regex.length() > 0) : "Parameter 'regex' of method 'locateFiles' must not be empty";
        LinkedHashMap<String, TFile> foundFiles = new LinkedHashMap<String, TFile>();
        for (TFile dir : this.m_searchPath) {
            TFile[] files;
            TFile[] tFileArray = files = FileUtility.listFilesInDir(dir, regex);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                TFile file = tFileArray[n2];
                if (!foundFiles.containsKey(file.getName())) {
                    foundFiles.put(file.getName(), file);
                }
                ++n2;
            }
        }
        return new ArrayList<TFile>(foundFiles.values());
    }

    public Map<TFile, List<TFile>> locateAllFiles(String regex) {
        LinkedHashMap<TFile, List<TFile>> foundFiles = new LinkedHashMap<TFile, List<TFile>>();
        for (TFile dir : this.m_searchPath) {
            TFile[] filesInDir = this.m_archiveDetection == ArchiveDetection.YES ? FileUtility.listFilesInDir(dir, regex) : FileUtility.listFilesInDir(dir, regex, TArchiveDetector.NULL);
            foundFiles.put(dir, Arrays.asList(filesInDir));
        }
        return foundFiles;
    }

    public TFile locateFile(String fileName, boolean caseInsensitively) {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        if (!caseInsensitively) {
            return this.locateFile(fileName);
        }
        for (TFile dir : this.m_searchPath) {
            if (!dir.exists()) continue;
            TFile[] tFileArray = dir.listFiles(TArchiveDetector.NULL);
            int n = tFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                TFile file = tFileArray[n2];
                if (file.getName().equalsIgnoreCase(fileName) && file.canRead()) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String sep = "";
        for (TFile dir : this.m_searchPath) {
            result.append(sep);
            sep = ";";
            result.append(dir.getPath());
        }
        return result.toString();
    }

    public boolean remove(TFile dir) {
        return this.m_searchPath.remove(dir);
    }

    public SearchPath copy() {
        return new SearchPath(this.m_searchPath.toArray(new TFile[0]));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_searchPath == null ? 0 : this.m_searchPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchPath other = (SearchPath)obj;
        if (this.m_searchPath == null) {
            return other.m_searchPath == null;
        }
        return this.m_searchPath.equals(other.m_searchPath);
    }

    public static enum ArchiveDetection {
        YES,
        NO;

    }
}

