/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.collections;

import gnu.trove.impl.PrimeFinder;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public final class HashBag<T>
implements Collection<T> {
    private Entry<T>[] m_entries;
    private int m_size;
    private int m_version;

    public HashBag() {
        this(10);
    }

    public HashBag(int desiredCapacity) {
        int nextPrime = PrimeFinder.nextPrime((int)desiredCapacity);
        this.m_entries = new Entry[nextPrime];
        this.m_version = 0;
    }

    @Override
    public int size() {
        return this.m_size;
    }

    @Override
    public boolean isEmpty() {
        return this.m_size == 0;
    }

    @Override
    public boolean contains(Object o) {
        assert (o != null) : "Parameter 'o' of method 'contains' must not be null";
        int hash = o.hashCode() & Integer.MAX_VALUE;
        int len = this.m_entries.length;
        Entry<T> e = this.m_entries[hash % len];
        while (e != null) {
            if (e.m_value == o || o.equals(e.m_value)) {
                return true;
            }
            e = e.m_next;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.m_size];
        Iterator<T> iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            T next = iter.next();
            result[i++] = next;
        }
        return result;
    }

    @Override
    public <A> A[] toArray(A[] a) {
        if (a.length < this.m_size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.m_size);
        }
        Iterator<T> iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            T next = iter.next();
            a[i++] = next;
        }
        while (i < a.length) {
            a[i] = null;
            ++i;
        }
        return a;
    }

    @Override
    public boolean add(T e) {
        assert (e != null) : "Parameter 'e' of method 'add' must not be null";
        if (this.m_size >= this.m_entries.length) {
            this.rehash(this.m_size * 2);
        }
        int hash = e.hashCode() & Integer.MAX_VALUE;
        int len = this.m_entries.length;
        int index = hash % len;
        Entry<T> entry = this.m_entries[index];
        this.m_entries[index] = new Entry<T>(e, entry);
        ++this.m_size;
        ++this.m_version;
        return true;
    }

    private void rehash(int desiredCapacity) {
        int newSize = PrimeFinder.nextPrime((int)Math.max(desiredCapacity, 10));
        Entry[] newEntries = new Entry[newSize];
        for (T next : this) {
            int hash = next.hashCode() & Integer.MAX_VALUE;
            int index = hash % newSize;
            newEntries[index] = new Entry<T>(next, newEntries[index]);
        }
        this.m_entries = newEntries;
        ++this.m_version;
    }

    @Override
    public boolean remove(Object o) {
        assert (o != null) : "Parameter 'o' of method 'contains' must not be null";
        int hash = o.hashCode() & Integer.MAX_VALUE;
        int len = this.m_entries.length;
        int index = hash % len;
        Entry<T> prev = null;
        Entry<T> e = this.m_entries[index];
        while (e != null) {
            if (e.m_value == o || o.equals(e.m_value)) {
                if (prev == null) {
                    this.m_entries[index] = e.m_next;
                } else {
                    prev.m_next = e.m_next;
                }
                e.m_next = null;
                --this.m_size;
                ++this.m_version;
                return true;
            }
            prev = e;
            e = e.m_next;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return !c.stream().anyMatch(e -> !this.contains(e));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        assert (c != null) : "Parameter 'c' of method 'addAll' must not be null";
        if (this.m_size + c.size() > this.m_entries.length) {
            int newSize = this.m_size + c.size();
            this.rehash(newSize * 3 / 2);
        }
        c.forEach(e -> {
            boolean bl = this.add((T)e);
        });
        return c.size() > 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        c.forEach(e -> {
            boolean bl = this.remove(e);
        });
        return c.size() > 0;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<T> iter = this.iterator();
        int deleteCount = 0;
        while (iter.hasNext()) {
            T next = iter.next();
            if (c.contains(next)) continue;
            iter.remove();
            ++deleteCount;
        }
        return deleteCount > 0;
    }

    @Override
    public void clear() {
        this.m_size = 0;
        ++this.m_version;
        int i = 0;
        while (i < this.m_entries.length) {
            this.m_entries[i] = null;
            ++i;
        }
    }

    public void trimToSize() {
        if ((double)this.m_entries.length > 1.1 * (double)this.m_size) {
            this.rehash(this.m_size);
        }
    }

    private static final class Entry<T> {
        Entry<T> m_next;
        T m_value;

        Entry(T value, Entry<T> next) {
            this.m_next = next;
            this.m_value = value;
        }
    }

    private class Iter
    implements Iterator<T> {
        int m_bucketIndex;
        Entry<T> m_current = null;
        int m_previousBucketIndex;
        Entry<T> m_previous = null;
        int m_version;

        private Iter() {
            this.m_version = HashBag.this.m_version;
            int i = 0;
            while (i < HashBag.this.m_entries.length) {
                Entry entry = HashBag.this.m_entries[i];
                if (entry != null) {
                    this.m_bucketIndex = i;
                    this.m_current = entry;
                    break;
                }
                ++i;
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_current != null;
        }

        @Override
        public T next() {
            assert (this.m_current != null);
            if (HashBag.this.m_version != this.m_version) {
                throw new ConcurrentModificationException();
            }
            Object result = this.m_current.m_value;
            this.m_previousBucketIndex = this.m_bucketIndex;
            this.m_previous = this.m_current;
            this.m_current = this.m_current.m_next;
            if (this.m_current == null) {
                int i = this.m_bucketIndex + 1;
                while (i < HashBag.this.m_entries.length) {
                    Entry entry = HashBag.this.m_entries[i];
                    if (entry != null) {
                        this.m_bucketIndex = i;
                        this.m_current = entry;
                        break;
                    }
                    ++i;
                }
            }
            return result;
        }

        @Override
        public void remove() {
            assert (this.m_previous != null);
            if (HashBag.this.m_version != this.m_version) {
                throw new ConcurrentModificationException();
            }
            if (HashBag.this.m_entries[this.m_previousBucketIndex] == this.m_previous) {
                HashBag.this.m_entries[this.m_previousBucketIndex] = this.m_previous.m_next;
            } else {
                Entry entry = HashBag.this.m_entries[this.m_previousBucketIndex];
                while (entry.m_next != this.m_previous) {
                    entry = entry.m_next;
                }
                entry.m_next = this.m_previous.m_next;
            }
            this.m_previous = null;
            --HashBag.this.m_size;
            ++this.m_version;
            HashBag.this.m_version = this.m_version;
        }
    }
}

