/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.calculations;

import java.util.List;
import java.util.OptionalDouble;

public final class SimpleStatistics {
    private SimpleStatistics() {
    }

    public static OptionalDouble average(List<Number> numbers) {
        assert (numbers != null && !numbers.isEmpty()) : "Parameter 'numbers' of method 'getAverage' must not be empty";
        return numbers.stream().mapToDouble(n -> n.doubleValue()).sorted().average();
    }

    public static OptionalDouble standardDeviation(List<Number> numbers) {
        assert (numbers != null && !numbers.isEmpty()) : "Parameter 'numbers' of method 'standardDeviation' must not be empty";
        if (numbers.size() == 1) {
            return OptionalDouble.of(0.0);
        }
        OptionalDouble average = SimpleStatistics.average(numbers);
        if (!average.isPresent()) {
            return average;
        }
        double mean = average.getAsDouble();
        double sumOfSquareOfDiffs = numbers.stream().mapToDouble(n -> Math.pow(n.doubleValue() - mean, 2.0)).sum() / (double)numbers.size();
        return OptionalDouble.of(Math.sqrt(sumOfSquareOfDiffs));
    }

    public static double median(List<Number> numbers) {
        assert (numbers != null && !numbers.isEmpty()) : "Parameter 'numbers' of method 'median' must not be empty";
        double[] sorted = numbers.stream().mapToDouble(n -> n.doubleValue()).sorted().toArray();
        double median = sorted.length % 2 == 0 ? (sorted[sorted.length / 2] + sorted[sorted.length / 2 - 1]) / 2.0 : sorted[sorted.length / 2];
        return median;
    }
}

