/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.javapg.runtime.lalr;

import com.hello2morrow.javapg.runtime.lexer.base.ILexer;
import com.hello2morrow.javapg.runtime.messaging.MessageReporter;
import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.parser.AbstractParser;
import com.hello2morrow.javapg.runtime.tree.InnerNode;
import com.hello2morrow.javapg.runtime.tree.Node;
import java.io.IOException;
import java.util.LinkedList;

public class AbstractLALRParser
extends AbstractParser {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final int STACK_SIZE = 16384;
    public static final int SHIFT = 16384;
    public static final int REDUCE = 32768;
    public static final int ACCEPT = 49152;
    public static final short ERROR = 0;
    public static final int DELETABLE = 32768;
    private final Node[] nodes;
    private final short[][] actionTables;
    private final short[][] gotoTables;
    private final short[] reductionTable;

    public AbstractLALRParser(Class<? extends ILexer> lexerClass, MessageReporter rep, Node[] nodes, short[][] actions, short[][] gotoTable, short[] reductionTable) {
        super(lexerClass, rep);
        this.nodes = nodes;
        this.actionTables = actions;
        this.gotoTables = gotoTable;
        this.reductionTable = reductionTable;
    }

    protected boolean shiftToken(int tok) {
        return false;
    }

    @Override
    protected InnerNode doParse() throws IOException {
        boolean result = false;
        boolean done = false;
        short state = 0;
        int sp = 0;
        short[] stateStack = new short[16384];
        Object[] nodeStack = new Object[16384];
        int lookAhead = this.m_Lexer.nextToken();
        boolean isWeak = this.m_Lexer.isWeakToken();
        int actionTableStartIndex = 0;
        int actionTableLookAhead = -1;
        LinkedList<FullParserState> parserStateStack = new LinkedList<FullParserState>();
        stateStack[sp++] = state;
        block6: do {
            short[] actionTable = this.actionTables[state];
            int action = 0;
            assert (actionTableStartIndex == 0 || actionTable[actionTableStartIndex] == lookAhead);
            int actionTableIndex = actionTableStartIndex;
            while (actionTableIndex < actionTable.length) {
                actionTableLookAhead = actionTable[actionTableIndex];
                if (actionTableLookAhead == lookAhead || actionTableLookAhead == -1) {
                    action = actionTable[actionTableIndex + 1];
                    break;
                }
                actionTableIndex += 2;
            }
            actionTableStartIndex = 0;
            block0 : switch (action & 0xC000) {
                case 16384: {
                    String lexeme;
                    if (this.shiftToken(lookAhead)) {
                        while (!parserStateStack.isEmpty()) {
                            FullParserState st = (FullParserState)parserStateStack.removeFirst();
                            st.release();
                        }
                    }
                    stateStack[sp] = state = (short)(action & 0x3FFF);
                    Position pos = this.m_Lexer.getPosition();
                    if (this.m_Lexer.isWeakToken() || this.m_Lexer.isVariable(lookAhead)) {
                        lexeme = this.m_Lexer.getLexeme();
                    } else if (lookAhead == 0) {
                        lexeme = null;
                        done = true;
                    } else {
                        lexeme = null;
                    }
                    if (this.m_Lexer.isPrecious(lookAhead)) {
                        Node node = this.nodes[lookAhead - 2].clone(null);
                        nodeStack[sp - 1] = node;
                        node.setPosition(pos);
                        node.setType(lookAhead);
                        if (lexeme != null) {
                            node.setLexeme(lexeme);
                        }
                    } else {
                        nodeStack[sp - 1] = null;
                    }
                    ++sp;
                    lookAhead = this.m_Lexer.nextToken();
                    isWeak = this.m_Lexer.isWeakToken();
                    if (!isWeak) break;
                    FullParserState parserState = new FullParserState(state, sp, stateStack, nodeStack, 0, this.m_Lexer.getAlternateToken());
                    parserStateStack.addLast(parserState);
                    break;
                }
                case 32768: {
                    if (actionTableLookAhead != -1 && actionTable[actionTableIndex + 2] == actionTableLookAhead) {
                        FullParserState parserState = new FullParserState(state, sp, stateStack, nodeStack, actionTableIndex + 2, lookAhead);
                        parserStateStack.addLast(parserState);
                    }
                    int param = 3 * (action & 0x3FFF);
                    int length = this.reductionTable[param + 2];
                    short nodeId = this.reductionTable[param];
                    if ((sp -= length) < 1) {
                        done = true;
                        break;
                    }
                    if (length >= 1 && nodeStack[sp + length - 2] == EMPTY_ARRAY) {
                        --length;
                    }
                    if (nodeId == -1) {
                        if (length == 0) {
                            nodeStack[sp - 1] = EMPTY_ARRAY;
                        } else {
                            LinkedList<Object> list;
                            int limit = sp - 1 + length;
                            Object lastElement = nodeStack[limit - 1];
                            assert (lastElement != EMPTY_ARRAY);
                            if (lastElement instanceof LinkedList) {
                                list = (LinkedList<Object>)lastElement;
                                i = limit - 2;
                                while (i >= sp - 1) {
                                    toAdd = nodeStack[i];
                                    if (toAdd != null) {
                                        list.offerFirst(toAdd);
                                    }
                                    --i;
                                }
                            } else {
                                list = new LinkedList<Object>();
                                i = sp - 1;
                                while (i < limit) {
                                    toAdd = nodeStack[i];
                                    if (toAdd != null) {
                                        list.add(toAdd);
                                    }
                                    ++i;
                                }
                            }
                            nodeStack[sp - 1] = list;
                        }
                    } else if ((nodeId & 0x8000) == 0 || length != 1) {
                        InnerNode node = (InnerNode)this.nodes[nodeId & Short.MAX_VALUE].clone(null);
                        int limit = sp - 1 + length;
                        int i = sp - 1;
                        while (i < limit) {
                            Object child = nodeStack[i];
                            if (child instanceof Node) {
                                node.addChild((Node)child);
                            } else if (child instanceof LinkedList) {
                                LinkedList list = (LinkedList)child;
                                node.addChildren(list);
                            }
                            ++i;
                        }
                        node.fitToSize();
                        nodeStack[sp - 1] = node;
                    } else if (nodeStack[sp - 1] instanceof LinkedList) {
                        InnerNode node = (InnerNode)this.nodes[nodeId & Short.MAX_VALUE].clone(null);
                        LinkedList list = (LinkedList)nodeStack[sp - 1];
                        node.addChildren(list);
                        Node child = node.size() == 1 ? node.getChildAt(0) : null;
                        nodeStack[sp - 1] = node.size() != 1 || !(child instanceof InnerNode) ? node : child;
                    }
                    state = stateStack[sp - 1];
                    short[] gotoTable = this.gotoTables[this.reductionTable[param + 1]];
                    int j = 0;
                    while (j < gotoTable.length) {
                        short st = gotoTable[j];
                        if (st == state || st == -1) {
                            state = gotoTable[j + 1];
                            stateStack[sp++] = state;
                            break block0;
                        }
                        j += 2;
                    }
                    continue block6;
                }
                case 49152: {
                    done = true;
                    result = true;
                    assert (sp == 2);
                    continue block6;
                }
                case 0: {
                    if (isWeak) {
                        lookAhead = this.m_Lexer.getAlternateToken();
                        isWeak = false;
                        break;
                    }
                    if (!parserStateStack.isEmpty()) {
                        FullParserState parserState = (FullParserState)parserStateStack.removeLast();
                        this.m_Lexer.gotoPosition(parserState.lexerPosition);
                        isWeak = false;
                        lookAhead = parserState.lookAhead;
                        actionTableStartIndex = parserState.actionTableIndex;
                        sp = parserState.sp;
                        state = parserState.state;
                        System.arraycopy(parserState.stateStack, 0, stateStack, 0, sp - 1);
                        System.arraycopy(parserState.nodeStack, 0, nodeStack, 0, sp - 1);
                        break;
                    }
                    done = true;
                }
            }
        } while (!done);
        while (!parserStateStack.isEmpty()) {
            FullParserState st = (FullParserState)parserStateStack.removeFirst();
            st.release();
        }
        if (!result) {
            if (lookAhead != 1) {
                this.m_Msg.reportMessage(2, this.m_Lexer.getPosition(), "SyntaxError");
            } else if (!this.m_Lexer.hasFatalError()) {
                this.m_Msg.reportMessage(2, this.m_Lexer.getPosition(), "InvalidToken");
            }
            return null;
        }
        return (InnerNode)nodeStack[sp - 2];
    }

    class FullParserState
    extends ParserState {
        Object lexerPosition;
        int actionTableIndex;
        int lookAhead;

        FullParserState(short state, int sp, short[] stateStack, Object[] nodeStack, int actionTableIndex, int lookAhead) throws IOException {
            super(state, sp, stateStack, nodeStack);
            this.lexerPosition = AbstractLALRParser.this.m_Lexer.markPosition();
            this.lookAhead = lookAhead;
            this.actionTableIndex = actionTableIndex;
        }

        void release() {
            AbstractLALRParser.this.m_Lexer.releasePosition(this.lexerPosition);
            this.lexerPosition = null;
        }
    }

    static class ParserState {
        short[] stateStack;
        Object[] nodeStack;
        short state;
        int sp;

        ParserState(short state, int sp, short[] stateStack, Object[] nodeStack) {
            this.state = state;
            this.sp = sp;
            this.stateStack = new short[sp - 1];
            this.nodeStack = new Object[sp - 1];
            System.arraycopy(stateStack, 0, this.stateStack, 0, sp - 1);
            System.arraycopy(nodeStack, 0, this.nodeStack, 0, sp - 1);
        }
    }
}

