/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.util.ArrayList;

public final class IntBitFieldUtil {
    public static final int NO_FLAG_SET = -1;

    private IntBitFieldUtil() {
    }

    public static int getFirstEnabledFlag(int flags) {
        int i = 0;
        while (i < 32) {
            int nextCheck = 1 << i;
            if ((flags & nextCheck) != 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int[] getAllEnabledFlags(int flags) {
        ArrayList<Integer> enabled = new ArrayList<Integer>(32);
        int i = 0;
        while (i < 32) {
            int nextCheck = 1 << i;
            if ((flags & nextCheck) != 0) {
                enabled.add(i);
            }
            ++i;
        }
        int[] enabledAsInt = new int[enabled.size()];
        int i2 = 0;
        while (i2 < enabled.size()) {
            enabledAsInt[i2] = (Integer)enabled.get(i2);
            ++i2;
        }
        return enabledAsInt;
    }

    public static boolean isFlagEnabled(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static int enableFlag(int flags, int flag) {
        int modifiedFlags = flags;
        return modifiedFlags |= flag;
    }

    public static int disableFlag(int flags, int flag) {
        int modifiedFlags = flags;
        return modifiedFlags &= ~flag;
    }
}

