/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrueZipFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrueZipFacade.class);

    static {
        java.util.logging.Logger trueZipLogger = java.util.logging.Logger.getLogger("de.schlichtherle.truezip");
        trueZipLogger.setLevel(Level.SEVERE);
        TConfig.get().setArchiveDetector(new TArchiveDetector("zip|jar|war|ear|snapshot|sgqm", (FsDriver)new JarDriver((IOPoolProvider)IOPoolLocator.SINGLETON)));
    }

    private TrueZipFacade() {
    }

    public static void initialize() {
    }

    public static void sync(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'clear' must not be null";
        try {
            TVFS.sync((TFile)file, (FsSyncOption[])new FsSyncOption[0]);
        }
        catch (FsSyncException ex) {
            LOGGER.error("Failed to unmount file '{}' from truezip virtual file system", (Object)file.getAbsolutePath());
        }
    }

    public static void clear(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'clear' must not be null";
        try {
            TVFS.umount((TFile)file);
        }
        catch (FsSyncException ex) {
            LOGGER.error("Failed to unmount file '{}' from truezip virtual file system", (Object)file.getAbsolutePath());
        }
    }

    public static void clear() {
        try {
            TVFS.umount();
        }
        catch (FsSyncException ex) {
            LOGGER.error("Failed to unmount truezip virtual file system: " + ExceptionUtility.collectAll(ex));
        }
    }
}

