/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistentRecentlyUsedList {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentRecentlyUsedList.class);
    private final String m_path;
    private final int m_maxNumberOfEntries;
    private final Set<CollationKey> m_keys;

    /*
     * Loose catch block
     */
    private static List<String> read(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'read' must not be empty";
        TFile file = new TFile(path);
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    List list;
                    XMLDecoder decoder;
                    BufferedInputStream in;
                    block20: {
                        in = new BufferedInputStream((InputStream)new TFileInputStream((File)file));
                        decoder = new XMLDecoder(in);
                        list = (List)decoder.readObject();
                        if (decoder != null) {
                            decoder.close();
                        }
                        if (in == null) break block20;
                        in.close();
                    }
                    return list;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (decoder != null) {
                                    decoder.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (in != null) {
                                    in.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                LOGGER.warn("Unable to decode: " + file.getNormalizedPath() + " - " + ExceptionUtility.collectAll(throwable));
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void save(String path, List<String> toBeSaved) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'save' must not be empty";
        assert (toBeSaved != null) : "Parameter 'toBeSaved' of method 'save' must not be null";
        TFile file = new TFile(path);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedOutputStream out = new BufferedOutputStream((OutputStream)new TFileOutputStream((File)file));
                try {
                    try (XMLEncoder encoder = new XMLEncoder(out);){
                        encoder.writeObject(toBeSaved);
                    }
                    if (out == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to save file '" + file.getNormalizedPath() + "' - " + ExceptionUtility.collectAll(e));
        }
    }

    public PersistentRecentlyUsedList(String path, int maxNumberOfEntries) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'PersistentRecentlyUsedList' must not be empty";
        assert (maxNumberOfEntries > 0) : "'maxNumberOfEntries' must be greater than zero";
        this.m_path = path;
        this.m_maxNumberOfEntries = maxNumberOfEntries;
        this.m_keys = new LinkedHashSet<CollationKey>(this.m_maxNumberOfEntries);
        List<String> existingEntries = PersistentRecentlyUsedList.read(this.m_path);
        if (existingEntries != null) {
            int i = existingEntries.size() - 1;
            while (i >= 0) {
                CollationKey nextKey = Collator.getInstance().getCollationKey(existingEntries.get(i));
                if (!this.m_keys.add(nextKey)) {
                    LOGGER.warn("Ignored duplicate entry: " + nextKey.getSourceString());
                    PersistentRecentlyUsedList.save(this.m_path, this.getAll());
                }
                --i;
            }
        }
    }

    public String getAbsolutePath() {
        return this.m_path;
    }

    public int getNumberOfEntries() {
        return this.m_keys.size();
    }

    public void remove(String entry) {
        assert (entry != null) : "entry must not be null";
        CollationKey key = Collator.getInstance().getCollationKey(entry);
        assert (this.m_keys.contains(key)) : "entry does not exist: " + entry;
        this.m_keys.remove(key);
        PersistentRecentlyUsedList.save(this.m_path, this.getAll());
    }

    public void removeAll() {
        this.m_keys.clear();
        PersistentRecentlyUsedList.save(this.m_path, this.getAll());
    }

    public void lastRecentlyUsed(String entry) {
        Iterator<CollationKey> iterator;
        assert (entry != null) : "Path must not be null";
        CollationKey key = Collator.getInstance().getCollationKey(entry);
        this.m_keys.remove(key);
        this.m_keys.add(key);
        if (this.m_keys.size() > this.m_maxNumberOfEntries && (iterator = this.m_keys.iterator()).hasNext()) {
            iterator.next();
            iterator.remove();
        }
        PersistentRecentlyUsedList.save(this.m_path, this.getAll());
    }

    public boolean contains(String entry) {
        assert (entry != null) : "'entry' must not be null";
        CollationKey key = Collator.getInstance().getCollationKey(entry);
        for (CollationKey nextEntry : this.m_keys) {
            if (!nextEntry.equals(key)) continue;
            return true;
        }
        return false;
    }

    public List<String> getAll() {
        ArrayList<String> paths = new ArrayList<String>(this.m_keys.size());
        CollationKey[] collationKeys = this.m_keys.toArray(new CollationKey[this.m_keys.size()]);
        int i = collationKeys.length - 1;
        while (i >= 0) {
            paths.add(collationKeys[i].getSourceString());
            --i;
        }
        return paths;
    }
}

