/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.event;

import com.hello2morrow.sonargraph.foundation.event.AddHandlerRequest;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventAdapter;
import com.hello2morrow.sonargraph.foundation.event.EventDispatchRequest;
import com.hello2morrow.sonargraph.foundation.event.IDispatcher;
import com.hello2morrow.sonargraph.foundation.event.IEventForwarder;
import com.hello2morrow.sonargraph.foundation.event.IEventHandler;
import com.hello2morrow.sonargraph.foundation.event.IRegistrantRequestPerformed;
import com.hello2morrow.sonargraph.foundation.event.PutToSleepRequest;
import com.hello2morrow.sonargraph.foundation.event.QueuedRequest;
import com.hello2morrow.sonargraph.foundation.event.RemoveHandlerRequest;
import com.hello2morrow.sonargraph.foundation.event.WakeUpRequest;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Dispatcher
implements IDispatcher,
IEventForwarder,
EventAdapter.IRegistrantStateProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dispatcher.class);
    private final Map<Class<?>, EventAdapter<? extends Event>> m_eventAdapter = new THashMap();
    private final Map<EventAdapter<? extends Event>, List<IEventHandler<?>>> m_adapterToHandler = new THashMap();
    private final Map<Object, Set<IEventHandler<?>>> m_registrantToHandler = new THashMap();
    private final Set<Object> m_sleepingRegistrants = new THashSet();
    private final Deque<QueuedRequest> m_requests = new LinkedList<QueuedRequest>();
    private IEventForwarder m_forwarder = this;
    private EventAdapter<? extends Event> m_currentlyDispatchingForAdapter;

    Dispatcher() {
    }

    void setEventForwarder(IEventForwarder forwarder) {
        this.m_forwarder = forwarder != null ? forwarder : this;
    }

    synchronized <T extends Event> EventAdapter<? extends Event> getEventAdapter(Class<T> eventClass) {
        assert (eventClass != null) : "'eventClass' must not be null";
        EventAdapter<Event> eventAdapter = this.m_eventAdapter.get(eventClass);
        if (eventAdapter == null) {
            eventAdapter = new EventAdapter<T>(eventClass);
            this.m_eventAdapter.put(eventClass, eventAdapter);
            assert (!this.m_adapterToHandler.containsKey(eventAdapter)) : "Already registered: " + String.valueOf(eventAdapter);
            this.m_adapterToHandler.put(eventAdapter, new ArrayList());
        }
        return eventAdapter;
    }

    synchronized void addEventHandler(EventAdapter<? extends Event> adapter, IEventHandler<?> handler) {
        assert (adapter != null) : "'adapter' must not be null";
        assert (handler != null) : "'handler' must not be null";
        AddHandlerRequest addHandlerRequest = new AddHandlerRequest(this, adapter, handler);
        if (this.m_currentlyDispatchingForAdapter != null) {
            this.m_requests.add(addHandlerRequest);
        } else {
            addHandlerRequest.perform();
        }
    }

    synchronized void removeEventHandler(EventAdapter<? extends Event> adapter, IEventHandler<?> handler) {
        assert (adapter != null) : "'adapter' must not be null";
        assert (handler != null) : "'handler' must not be null";
        RemoveHandlerRequest removeHandlerRequest = new RemoveHandlerRequest(this, adapter, handler);
        if (this.m_currentlyDispatchingForAdapter != null) {
            this.m_requests.add(removeHandlerRequest);
        } else {
            removeHandlerRequest.perform();
        }
    }

    synchronized <T extends Event> void removeEventHandler(Class<T> eventClass, Object registrant) {
        assert (eventClass != null) : "'eventClass' must not be null";
        assert (registrant != null) : "'registrant' must not be null";
        EventAdapter<? extends Event> adapter = this.m_eventAdapter.get(eventClass);
        assert (adapter != null) : "'adapter' not found for: " + String.valueOf(eventClass);
        List<IEventHandler<?>> handlerForAdapter = this.getHandlerForAdapter(adapter);
        ArrayList handlerForRegistrantCopy = new ArrayList(this.getHandlerForRegistrant(registrant));
        handlerForRegistrantCopy.retainAll(handlerForAdapter);
        assert (handlerForRegistrantCopy.size() == 1) : "Handler not found (Event class/registrant): " + String.valueOf(eventClass) + "/" + String.valueOf(registrant);
        RemoveHandlerRequest removeHandlerRequest = new RemoveHandlerRequest(this, adapter, (IEventHandler)handlerForRegistrantCopy.get(0));
        if (this.m_currentlyDispatchingForAdapter != null) {
            this.m_requests.add(removeHandlerRequest);
        } else {
            removeHandlerRequest.perform();
        }
    }

    synchronized void putToSleep(Object registrant, IRegistrantRequestPerformed performed) {
        assert (registrant != null) : "Parameter 'registrant' of method 'putToSleep' must not be null";
        assert (performed != null) : "Parameter 'performed' of method 'putToSleep' must not be null";
        PutToSleepRequest request = new PutToSleepRequest(this, registrant, performed);
        if (this.m_currentlyDispatchingForAdapter != null) {
            this.m_requests.add(request);
        } else {
            request.perform();
        }
    }

    synchronized void wakeUp(Object registrant, IRegistrantRequestPerformed performed) {
        assert (registrant != null) : "Parameter 'registrant' of method 'wakeUp' must not be null";
        assert (performed != null) : "Parameter 'performed' of method 'wakeUp' must not be null";
        WakeUpRequest request = new WakeUpRequest(this, registrant, performed);
        if (this.m_currentlyDispatchingForAdapter != null) {
            this.m_requests.add(request);
        } else {
            request.perform();
        }
    }

    synchronized <T extends Event> boolean isAttached(Class<T> eventClass, Object registrant) {
        assert (eventClass != null) : "'eventClass' must not be null";
        assert (registrant != null) : "'registrant' must not be null";
        EventAdapter<? extends Event> adapter = this.m_eventAdapter.get(eventClass);
        if (adapter == null) {
            return false;
        }
        Set<IEventHandler<?>> handler = this.m_registrantToHandler.get(registrant);
        if (handler == null) {
            return false;
        }
        ArrayList handlerForRegistrantCopy = new ArrayList(handler);
        List<IEventHandler<?>> handlerForAdapter = this.getHandlerForAdapter(adapter);
        handlerForRegistrantCopy.retainAll(handlerForAdapter);
        if (!handlerForRegistrantCopy.isEmpty()) {
            assert (handlerForRegistrantCopy.size() == 1) : "Handler not found (Event class/registrant): " + String.valueOf(eventClass) + "/" + String.valueOf(registrant);
            return true;
        }
        return false;
    }

    synchronized boolean hasHandlers(EventAdapter<? extends Event> adapter) {
        List<IEventHandler<?>> handlerList = this.m_adapterToHandler.get(adapter);
        assert (handlerList != null) : "Adapter not registered: " + String.valueOf(adapter);
        return handlerList.size() > 0;
    }

    private List<IEventHandler<?>> getHandlerForAdapter(EventAdapter<? extends Event> adapter) {
        assert (adapter != null) : "'adapter' must not be null";
        List<IEventHandler<?>> handlerList = this.m_adapterToHandler.get(adapter);
        assert (handlerList != null) : "Adapter not registered: " + String.valueOf(adapter);
        return handlerList;
    }

    private Set<IEventHandler<?>> getHandlerForRegistrant(Object registrant) {
        assert (registrant != null) : "'registrant' must not be null";
        Set<IEventHandler<?>> handler = this.m_registrantToHandler.get(registrant);
        assert (handler != null) : "Registrant not found: " + String.valueOf(registrant);
        return handler;
    }

    @Override
    public void addHandler(EventAdapter<? extends Event> adapter, IEventHandler<?> handler) {
        assert (adapter != null) : "'adapter' must not be null";
        assert (handler != null) : "'handler' must not be null";
        List<IEventHandler<?>> handlerList = this.m_adapterToHandler.get(adapter);
        assert (handlerList != null) : "Adapter not registered: " + String.valueOf(adapter);
        assert (!handlerList.contains(handler)) : "'handler' already added: " + String.valueOf(handler);
        handlerList.add(handler);
        THashSet handlerForRegistrant = this.m_registrantToHandler.get(handler.getRegistrant());
        if (handlerForRegistrant == null) {
            handlerForRegistrant = new THashSet(5);
            this.m_registrantToHandler.put(handler.getRegistrant(), (Set<IEventHandler<?>>)handlerForRegistrant);
        } else assert (!handlerForRegistrant.contains(handler)) : "'handler' already added for 'registrant' ('registrant'/'handler'): " + String.valueOf(handler.getRegistrant()) + "/" + String.valueOf(handler);
        handlerForRegistrant.add(handler);
    }

    @Override
    public void removeHandler(EventAdapter<? extends Event> adapter, IEventHandler<?> handler) {
        assert (adapter != null) : "'adapter' must not be null";
        assert (handler != null) : "'handler' must not be null";
        List<IEventHandler<?>> handlerList = this.m_adapterToHandler.get(adapter);
        assert (handlerList != null) : "Adapter not registered: " + String.valueOf(adapter);
        assert (handlerList.contains(handler)) : "'handler' not found: " + String.valueOf(handler);
        handlerList.remove(handler);
        Set<IEventHandler<?>> handlerForRegistrant = this.getHandlerForRegistrant(handler.getRegistrant());
        boolean removed = handlerForRegistrant.remove(handler);
        assert (removed) : "'handler' not found for 'registrant' ('registrant'/'handler'): " + String.valueOf(handler.getRegistrant()) + "/" + String.valueOf(handler);
        if (handlerForRegistrant.isEmpty()) {
            this.m_registrantToHandler.remove(handler.getRegistrant());
        }
    }

    @Override
    public void forwardEvent(EventAdapter<? extends Event> adapter, Object emitter, Event event) {
        assert (adapter != null) : "Parameter 'adapter' of method 'forwardEvent' must not be null";
        assert (emitter != null) : "Parameter 'emitter' of method 'forwardEvent' must not be null";
        assert (event != null) : "Parameter 'event' of method 'forwardEvent' must not be null";
        ArrayList handlerListForAdapter = new ArrayList(this.getHandlerForAdapter(adapter));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Forward event for: " + String.valueOf(adapter) + " to " + handlerListForAdapter.size() + " event handler(s)");
        }
        if (!handlerListForAdapter.isEmpty()) {
            adapter.forwardToSpecificHandler(event, emitter, handlerListForAdapter, this, this.m_forwarder);
        }
    }

    private synchronized QueuedRequest getNextQueuedRequest() {
        if (this.m_requests.isEmpty()) {
            assert (this.m_currentlyDispatchingForAdapter != null) : "Dispatcher must be locked here";
            this.m_currentlyDispatchingForAdapter = null;
            return null;
        }
        return this.m_requests.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatch(EventAdapter<? extends Event> adapter, Object emitter, Event event) {
        assert (adapter != null) : "'adapter' must not be null";
        assert (emitter != null) : "'emitter' must not be null";
        assert (event != null) : "'event' must not be null";
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Dispatch request for: " + String.valueOf(adapter));
        }
        if (event.forceDispatch()) {
            this.forwardEvent(adapter, emitter, event);
            return;
        }
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (this.m_currentlyDispatchingForAdapter != null) {
                this.m_requests.addLast(new EventDispatchRequest(this, adapter, emitter, event));
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Dispatch request queued - already dispatching: " + String.valueOf(this.m_currentlyDispatchingForAdapter));
                }
                return;
            }
            this.m_currentlyDispatchingForAdapter = adapter;
        }
        this.forwardEvent(adapter, emitter, event);
        QueuedRequest nextQueuedRequest = this.getNextQueuedRequest();
        while (nextQueuedRequest != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Processing queued request ...");
            }
            nextQueuedRequest.perform();
            nextQueuedRequest = this.getNextQueuedRequest();
        }
    }

    @Override
    public void runEventDispatch(Class<? extends Event> eventClass, Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'forward' must not be null";
        runnable.run();
    }

    @Override
    public void runRegistrantRequestPerformed(Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'runRegistrantRequestPerformed' must not be null";
        runnable.run();
    }

    @Override
    public void putToSleep(Object registrant, final IRegistrantRequestPerformed performed, final IRegistrantRequestPerformed.RegistrantState state) {
        assert (registrant != null) : "Parameter 'registrant' of method 'putToSleep' must not be null";
        assert (performed != null) : "Parameter 'performed' of method 'putToSleep' must not be null";
        assert (state != null) : "Parameter 'state' of method 'putToSleep' must not be null";
        boolean success = this.m_sleepingRegistrants.add(registrant);
        assert (success) : "'success' of method 'putToSleep' must be true";
        this.m_forwarder.runRegistrantRequestPerformed(new Runnable(){

            @Override
            public void run() {
                performed.performed(state);
            }
        });
    }

    @Override
    public void wakeUp(Object registrant, final IRegistrantRequestPerformed performed, final IRegistrantRequestPerformed.RegistrantState state) {
        assert (registrant != null) : "Parameter 'registrant' of method 'wakeUp' must not be null";
        assert (performed != null) : "Parameter 'performed' of method 'wakeUp' must not be null";
        assert (state != null) : "Parameter 'state' of method 'wakeUp' must not be null";
        boolean success = this.m_sleepingRegistrants.remove(registrant);
        assert (success) : "'success' of method 'wakeUp' must be true";
        this.m_forwarder.runRegistrantRequestPerformed(new Runnable(){

            @Override
            public void run() {
                performed.performed(state);
            }
        });
    }

    @Override
    public boolean isSleeping(Object registrant) {
        assert (registrant != null) : "Parameter 'registrant' of method 'isSleeping' must not be null";
        return this.m_sleepingRegistrants.contains(registrant);
    }
}

