/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.activity;

public final class Task {
    private final Task m_parent;
    private final String m_name;
    private final float m_percent;
    private boolean m_stepsInitialized;
    private Task[] m_subTasks;
    private float[] m_weights;
    private int m_currentStep = 0;
    private int m_workItems = -1;
    private int m_workedItems = 0;
    private float m_workItemIncrement = 0.0f;

    Task(Task parent, String name, float percent) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'Task' must not be empty";
        this.m_parent = parent;
        this.m_name = name;
        this.m_percent = percent;
        assert (this.m_percent >= 0.0f && this.m_percent <= 100.0f) : "'m_percent' of method 'Task' out of range";
        this.m_subTasks = new Task[1];
        this.m_weights = new float[]{this.m_percent};
    }

    String getName() {
        return this.m_name;
    }

    void setNumberOfSteps(int steps) {
        assert (steps > 0) : "Parameter 'steps' of method 'setNumberOfSteps' must be greater than 0";
        assert (!this.m_stepsInitialized) : "Number of steps already defined";
        this.m_subTasks = new Task[steps];
        float weightPerStep = this.m_percent / (float)steps;
        this.m_weights = new float[steps];
        int i = 0;
        while (i < this.m_weights.length) {
            this.m_weights[i] = weightPerStep;
            ++i;
        }
        this.m_stepsInitialized = true;
    }

    void setNumberOfSteps(int steps, int[] weights) {
        int i;
        assert (steps > 0) : "Parameter 'steps' of method 'setNumberOfSteps' must be greater than 0";
        assert (!this.m_stepsInitialized) : "Number of steps already defined";
        int[] weightsToUse = null;
        if (steps > weights.length && steps % weights.length == 0) {
            int patternToUse = steps / weights.length;
            weightsToUse = new int[steps];
            i = 0;
            while (i < weightsToUse.length) {
                int j = 0;
                while (j < weights.length) {
                    int nextWeight = weights[j] / patternToUse;
                    weightsToUse[i] = nextWeight > 0 ? nextWeight : 1;
                    ++i;
                    ++j;
                }
            }
        } else {
            weightsToUse = weights;
        }
        assert (steps == weightsToUse.length) : "Parameter 'weightsToUse' of method 'setNumberOfSteps' out of range";
        this.m_subTasks = new Task[steps];
        this.m_weights = new float[steps];
        int total = 0;
        i = 0;
        while (i < weightsToUse.length) {
            total += weightsToUse[i];
            ++i;
        }
        float percentPerInt = this.m_percent / (float)total;
        int i2 = 0;
        while (i2 < this.m_weights.length) {
            this.m_weights[i2] = percentPerInt * (float)weightsToUse[i2];
            ++i2;
        }
        this.m_stepsInitialized = true;
    }

    float getPercentOfCurrentStep() {
        assert (!this.isFinished()) : "Already finished";
        assert (this.m_weights != null) : "'m_weights' of method 'getPercentOfCurrentStep' must not be null - no steps defined";
        return this.m_weights[this.m_currentStep];
    }

    float getWorkIncrement() {
        return this.m_workItemIncrement;
    }

    Task getParentTask() {
        return this.m_parent;
    }

    boolean isFinished() {
        return this.m_currentStep >= this.m_subTasks.length;
    }

    void beginBlockOfWork(int workItems) {
        assert (!this.isFinished()) : "Already finished";
        assert (this.m_workItems == -1) : "'m_currentWorkItems' already set for step";
        this.m_workItems = workItems;
        this.m_workedItems = 0;
        this.m_workItemIncrement = this.m_weights[this.m_currentStep] / (float)this.m_workItems;
    }

    void workItemCompleted() {
        assert (!this.isFinished()) : "Already finished";
        assert (this.m_workItems - this.m_workedItems > 0) : "No work items left";
        ++this.m_workedItems;
    }

    Float end() {
        if (!this.isFinished()) {
            Float increment = Float.valueOf(0.0f);
            while (this.m_currentStep < this.m_subTasks.length) {
                Float remaining = this.endStep();
                if (remaining == null) continue;
                increment = Float.valueOf(increment.floatValue() + remaining.floatValue());
            }
            this.m_currentStep = this.m_subTasks.length;
            return increment;
        }
        return null;
    }

    Float endStep() {
        assert (!this.isFinished()) : "Already finished all steps";
        boolean usedWorkIncrement = this.m_workItems != -1;
        Float increment = null;
        if (usedWorkIncrement) {
            increment = Float.valueOf((float)(this.m_workItems - this.m_workedItems) * this.m_workItemIncrement);
        }
        this.m_workItems = -1;
        this.m_workedItems = 0;
        this.m_workItemIncrement = 0.0f;
        ++this.m_currentStep;
        return usedWorkIncrement ? increment : Float.valueOf(this.m_weights[this.m_currentStep - 1]);
    }

    void add(Task scope) {
        assert (!this.isFinished()) : "Already finished all steps";
        assert (scope != null) : "Parameter 'scope' of method 'add' must not be null";
        assert (this.m_subTasks[this.m_currentStep] == null) : "Has already a sub task: " + String.valueOf(this);
        this.m_subTasks[this.m_currentStep] = scope;
    }

    Task getCurrentTask() {
        assert (!this.isFinished()) : "Already finished: " + String.valueOf(this);
        if (this.m_subTasks[this.m_currentStep] != null) {
            return this.m_subTasks[this.m_currentStep].getCurrentTask();
        }
        return this;
    }

    void remove(Task task) {
        assert (!this.isFinished()) : "Already finished all steps";
        assert (task != null) : "Parameter 'task' of method 'remove' must not be null";
        assert (this.m_subTasks[this.m_currentStep] == task) : "Scope not found";
        this.m_subTasks[this.m_currentStep] = null;
        ++this.m_currentStep;
    }

    private int getCurrentStep() {
        return this.isFinished() ? -1 : this.m_currentStep + 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.m_stepsInitialized) {
            builder.append(this.m_currentStep).append(". Step, ");
        }
        builder.append("Task '").append(this.m_name).append("'");
        if (this.m_workItems > 0) {
            builder.append(" [").append(this.m_workedItems).append(" of ").append(this.m_workItems);
            builder.append(" (").append(this.m_workedItems * 100 / this.m_workItems).append("% (own) => ");
            builder.append((int)((float)this.m_workedItems * this.m_workItemIncrement)).append("% (total)");
            builder.append(" worked), ");
        } else {
            builder.append(" [");
        }
        if (this.m_stepsInitialized && !this.isFinished()) {
            builder.append("weight of step=").append(this.m_weights[this.m_currentStep]);
        } else {
            builder.append("own weight=").append(this.m_percent).append("%");
        }
        builder.append("]");
        if (this.isFinished()) {
            builder.append(" finished");
        } else {
            Task currentParentTask = this.getCurrentTask().getParentTask();
            if (currentParentTask != null) {
                builder.append(" (");
                while (currentParentTask != null) {
                    builder.append("<-");
                    builder.append(currentParentTask.getName());
                    builder.append(" |Step:");
                    builder.append(currentParentTask.getCurrentStep());
                    builder.append("|");
                    currentParentTask = currentParentTask.getParentTask();
                }
                builder.append(")");
            }
        }
        return builder.toString();
    }
}

