/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CustomPattern {
    public static final char[] WILDCARD_WITHOUT_CAPTURE_GROUPS_SPECIAL_CHARS = new char[]{'?', '*'};
    public static final String[] NO_MATCH = new String[0];
    private final Pattern m_compiledPattern;
    private final Matcher m_matcher;
    private String[] m_lastCaptureGroups = NO_MATCH;

    private static String translate(String pattern, String breakCharacters, boolean allowCaptureGroups) {
        assert (pattern != null) : "'pattern' must not be null";
        StringBuilder resultingRegex = new StringBuilder(80);
        StringBuilder toBeQuoted = new StringBuilder();
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == '*') {
                resultingRegex.append(Pattern.quote(toBeQuoted.toString()));
                toBeQuoted.setLength(0);
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '*') {
                    resultingRegex.append(".*");
                    ++i;
                } else {
                    resultingRegex.append(String.format("[^%s]*", breakCharacters));
                }
            } else if (c == '?') {
                resultingRegex.append(Pattern.quote(toBeQuoted.toString()));
                toBeQuoted.setLength(0);
                resultingRegex.append('.');
            } else if (allowCaptureGroups && (c == '(' || c == ')')) {
                resultingRegex.append(Pattern.quote(toBeQuoted.toString()));
                toBeQuoted.setLength(0);
                resultingRegex.append(c);
            } else {
                toBeQuoted.append(c);
            }
            ++i;
        }
        if (toBeQuoted.length() > 0) {
            resultingRegex.append(Pattern.quote(toBeQuoted.toString()));
        }
        return resultingRegex.toString();
    }

    private CustomPattern(String regex) {
        assert (regex != null) : "'regex' must not be null";
        this.m_compiledPattern = Pattern.compile(regex);
        this.m_matcher = this.m_compiledPattern.matcher("");
    }

    private CustomPattern(String regex, int flags) {
        assert (regex != null) : "'regex' must not be null";
        this.m_compiledPattern = Pattern.compile(regex, flags);
        this.m_matcher = this.m_compiledPattern.matcher("");
    }

    public static boolean containsWildcardPatternCharacter(String pattern) {
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'containsWildcardPatternCharacter' must not be empty";
        int i = 0;
        int n = pattern.length();
        while (i < n) {
            char nextChar = pattern.charAt(i);
            char[] cArray = WILDCARD_WITHOUT_CAPTURE_GROUPS_SPECIAL_CHARS;
            int n2 = WILDCARD_WITHOUT_CAPTURE_GROUPS_SPECIAL_CHARS.length;
            int n3 = 0;
            while (n3 < n2) {
                char nextWildcardPattern = cArray[n3];
                if (nextChar == nextWildcardPattern) {
                    return true;
                }
                ++n3;
            }
            ++i;
        }
        return false;
    }

    public static CustomPattern compileRegexPattern(String pattern, boolean ignoreCase) {
        assert (pattern != null) : "'pattern' must not be null";
        if (!ignoreCase) {
            return new CustomPattern(pattern);
        }
        int flags = 2;
        return new CustomPattern(pattern, 2);
    }

    public static CustomPattern compileWildcardPattern(String pattern, String breakCharacters, boolean ignoreCase, boolean allowCaptureGroups) {
        assert (pattern != null) : "'pattern' must not be null";
        return CustomPattern.compileRegexPattern(CustomPattern.translate(pattern, breakCharacters, allowCaptureGroups), ignoreCase);
    }

    public static CustomPattern compileWildcardPattern(String pattern, boolean ignoreCase) {
        assert (pattern != null) : "'pattern' must not be null";
        return CustomPattern.compileRegexPattern(CustomPattern.translate(pattern, "./\\\\", false), ignoreCase);
    }

    public boolean matches(CharSequence seq) {
        assert (seq != null) : "'seq' must not be null";
        this.m_matcher.reset(seq);
        if (!this.m_matcher.matches()) {
            this.m_lastCaptureGroups = NO_MATCH;
            return false;
        }
        if (this.m_matcher.groupCount() > 0) {
            this.m_lastCaptureGroups = new String[this.m_matcher.groupCount()];
            int i = 1;
            while (i <= this.m_matcher.groupCount()) {
                this.m_lastCaptureGroups[i - 1] = this.m_matcher.group(i);
                ++i;
            }
        } else {
            this.m_lastCaptureGroups = NO_MATCH;
        }
        return true;
    }

    public String[] getLastCaptureGroups() {
        return this.m_lastCaptureGroups;
    }

    public String toString() {
        return this.m_compiledPattern.toString();
    }
}

