/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

public class Counter {
    private final int m_max;
    private final Count m_count;
    private final String m_digitsFormat;
    private int m_current;

    public Counter(int max, Count count, int minDigits) {
        assert (max > 0) : "Parameter 'max' of method 'Counter' must be greater zero";
        assert (count != null) : "Parameter 'count' of method 'Counter' must not be null";
        assert (minDigits > 0) : "Parameter 'minDigits' of method 'Counter' must be greater zero";
        this.m_max = max;
        this.m_count = count;
        this.m_digitsFormat = "%0" + minDigits + "d";
        switch (this.m_count) {
            case DOWN: {
                this.m_current = max;
                break;
            }
            default: {
                this.m_current = 0;
            }
        }
    }

    public String get() {
        String result = String.format(this.m_digitsFormat, this.m_current);
        return result;
    }

    public void step() {
        switch (this.m_count) {
            case DOWN: {
                --this.m_current;
                if (this.m_current >= 0) break;
                this.m_current = this.m_max;
                break;
            }
            default: {
                ++this.m_current;
                if (this.m_current <= this.m_max) break;
                this.m_current = 0;
            }
        }
    }

    public static enum Count {
        UP,
        DOWN;

    }
}

