/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.propertyreader;

import com.hello2morrow.sonargraph.foundation.propertyreader.IPropertyReader;
import com.hello2morrow.sonargraph.foundation.propertyreader.ReflectionBasedPropertyReader;

public class BeanPropertyReader<T>
implements IPropertyReader<T> {
    private final ReflectionBasedPropertyReader m_beanMap;
    private final BeanAdapter<T> m_beanAdapter;

    public BeanPropertyReader(BeanAdapter<T> adapter) {
        assert (adapter != null) : "'adapter' must not be null";
        this.m_beanMap = new ReflectionBasedPropertyReader(adapter.getClass());
        this.m_beanAdapter = adapter;
    }

    @Override
    public Object readProperty(T obj, String propertyName) {
        this.m_beanAdapter.setAdaptedObject(obj);
        Object object = this.m_beanMap.readProperty(this.m_beanAdapter, propertyName);
        this.m_beanAdapter.setAdaptedObject(null);
        return object;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.m_beanMap.hasProperty(name);
    }

    public static abstract class BeanAdapter<T> {
        protected abstract void setAdaptedObject(T var1);
    }
}

