/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.propertyreader;

import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotatedPropertyMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedPropertyMap.class);
    private final Map<String, StrictPair<Method, Boolean>> m_getterMap = new LinkedHashMap<String, StrictPair<Method, Boolean>>();
    private final Map<String, Integer> m_undefinedIntValueMap = new HashMap<String, Integer>();

    private Annotation findPropertyAnnotation(Method method, String propertyName) {
        block10: {
            Class<?> superClass;
            block9: {
                assert (method != null) : "Parameter 'method' of method 'findPropertyAnnotation' must not be null";
                assert (propertyName != null) : "Parameter 'propertyName' of method 'findPropertyAnnotation' must not be null";
                Property prop = method.getAnnotation(Property.class);
                if (prop != null) {
                    return prop;
                }
                IntProperty intProp = method.getAnnotation(IntProperty.class);
                if (intProp != null) {
                    this.m_undefinedIntValueMap.put(propertyName, intProp.undefinedValue());
                    return intProp;
                }
                superClass = method.getDeclaringClass().getSuperclass();
                if (superClass != null) break block9;
                return null;
            }
            try {
                method = superClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
            catch (SecurityException ex) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)ex.toString());
            }
        }
        assert (method != null) : "'method' of method 'findPropertyAnnotation' must not be null";
        return this.findPropertyAnnotation(method, propertyName);
    }

    public AnnotatedPropertyMap(Class<?> cls) {
        assert (cls != null) : "Parameter 'cls' of method 'AnnotatedPropertyMap' must not be null";
        Method[] methodArray = cls.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            int prefixLength;
            String propertyName;
            Annotation annotation;
            Method nextMethod = methodArray[n2];
            Class<?>[] paramTypes = nextMethod.getParameterTypes();
            if (paramTypes.length < 1 && (annotation = this.findPropertyAnnotation(nextMethod, propertyName = (prefixLength = (name = nextMethod.getName()).startsWith("get") ? 3 : (name.startsWith("is") ? 0 : -1)) == -1 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : Character.toLowerCase(name.charAt(prefixLength)) + name.substring(prefixLength + 1))) != null) {
                Boolean isAlwaysShown;
                if (annotation instanceof Property) {
                    Property property = (Property)annotation;
                    isAlwaysShown = property.isAlwaysShown();
                } else {
                    isAlwaysShown = Boolean.FALSE;
                }
                this.m_getterMap.put(propertyName, new StrictPair<Method, Boolean>(nextMethod, isAlwaysShown));
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getPropertyValue(Object element, String propertyName) {
        Object result;
        block11: {
            block10: {
                boolean alwaysShown;
                Method method;
                block9: {
                    assert (element != null) : "Parameter 'element' of method 'getPropertyValue' must not be null";
                    assert (propertyName != null) : "Parameter 'propertyName' of method 'getPropertyValue' must not be null";
                    StrictPair<Method, Boolean> methodAndDisplayFlag = this.m_getterMap.get(propertyName);
                    if (methodAndDisplayFlag == null) {
                        return null;
                    }
                    method = methodAndDisplayFlag.getFirst();
                    alwaysShown = methodAndDisplayFlag.getSecond();
                    try {
                        method.setAccessible(true);
                        if (method.getParameterCount() <= 0) break block9;
                        return null;
                    }
                    catch (Throwable ex) {
                        LOGGER.error(ExceptionUtility.collectAll(ex));
                        return null;
                    }
                }
                result = method.invoke(element, new Object[0]);
                if ("".equals(result) || Boolean.FALSE.equals(result)) {
                    if (!alwaysShown) return null;
                    Object object = result;
                    return object;
                }
                Integer undefinedValue = this.m_undefinedIntValueMap.get(propertyName);
                if (undefinedValue == null || !undefinedValue.equals(result)) break block10;
                return null;
            }
            if (!(result instanceof IStandardEnumeration)) return result;
            if (!((IStandardEnumeration)result).isUnspecifiedValue()) break block11;
            return null;
        }
        return ((IStandardEnumeration)result).getPresentationName();
    }

    public Class<?> getPropertyType(String name) {
        assert (name != null) : "Parameter 'name' of method 'getPropertyType' must not be null";
        StrictPair<Method, Boolean> methodAndDisplayFlag = this.m_getterMap.get(name);
        if (methodAndDisplayFlag == null) {
            return null;
        }
        Method method = methodAndDisplayFlag.getFirst();
        assert (method != null) : "Method must not be null for property '" + name + "'";
        return method.getReturnType();
    }

    public Set<String> propertySet() {
        return Collections.unmodifiableSet(this.m_getterMap.keySet());
    }
}

