/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.activity;

import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Activity {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activity.class);
    private static final int TOTAL_IN_PERCENT = 100;
    private ActivityMode m_mode;
    private boolean m_providesProgress;
    private Task m_task;
    private Task m_currentSubTask;
    private int m_workedInPercent = 0;
    private float m_worked = 0.0f;
    private boolean m_canceled;
    private String m_currentMessage;
    private boolean m_currentIsMainStep;
    private boolean m_justStarted;
    private boolean m_isRunning;

    Activity() {
    }

    boolean isAlive() {
        return this.m_isRunning && !this.m_canceled && this.m_task != null && !this.m_task.isFinished();
    }

    void start(String message, ActivityMode mode, boolean providesProgress) {
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'start' must not be empty";
        assert (!this.isRunning()) : "Already running";
        assert (mode != null) : "Parameter 'mode' of method 'start' must not be null";
        this.m_mode = mode;
        this.m_providesProgress = providesProgress;
        this.m_task = new Task(null, message, 100.0f);
        this.m_justStarted = true;
        this.m_isRunning = true;
        this.m_currentIsMainStep = true;
        this.m_currentMessage = message;
    }

    public int getTotal() {
        return 100;
    }

    public ActivityMode getMode() {
        return this.m_mode;
    }

    public boolean providesProgress() {
        return this.m_providesProgress;
    }

    void started() {
        this.m_justStarted = false;
    }

    public boolean hasJustBeenStarted() {
        return this.m_justStarted;
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public int getWorkedInPercent() {
        return this.m_workedInPercent;
    }

    public boolean isMainStep() {
        assert (this.isRunning()) : "Is not running";
        return this.m_currentIsMainStep;
    }

    public String getCurrentMessage() {
        assert (this.isRunning()) : "Is not running";
        return this.m_currentMessage;
    }

    void cancel() {
        this.m_canceled = true;
        this.stop();
    }

    void stop() {
        this.m_task = null;
        this.m_isRunning = false;
        this.m_currentMessage = null;
    }

    public boolean hasBeenCanceled() {
        return this.m_canceled;
    }

    void setNumberOfSteps(int steps) {
        if (this.isAlive()) {
            Task currentTask = this.m_task.getCurrentTask();
            assert (currentTask != null) : "'currentTask' of method 'setNumberOfSteps' must not be null";
            currentTask.setNumberOfSteps(steps);
        }
    }

    public void setNumberOfSteps(int steps, int[] weights) {
        if (this.isAlive()) {
            Task currentTask = this.m_task.getCurrentTask();
            assert (currentTask != null) : "'currentTask' of method 'setNumberOfSteps' must not be null";
            currentTask.setNumberOfSteps(steps, weights);
        }
    }

    private void handleTaskFinished(Task task) {
        assert (task != null) : "Parameter 'task' of method 'handleTaskFinished' must not be null";
        Task parentTask = task.getParentTask();
        if (parentTask != null) {
            while (parentTask != null && task.isFinished()) {
                parentTask.remove(task);
                task = parentTask;
                parentTask = task.getParentTask();
            }
        } else {
            assert (task == this.m_task) : "Not the start scope: " + String.valueOf(task);
            this.m_task = null;
            this.m_worked = 100.0f;
            this.m_workedInPercent = 100;
            this.m_currentSubTask = null;
        }
    }

    void beginSubTask(String name) {
        if (this.isAlive()) {
            Task currentTask = this.m_task.getCurrentTask();
            assert (currentTask != null) : "'currentTask' of method 'beginSubTask' must not be null";
            this.m_currentSubTask = new Task(currentTask, name, currentTask.getPercentOfCurrentStep());
            currentTask.add(this.m_currentSubTask);
            this.m_currentMessage = name;
            this.m_currentIsMainStep = true;
        }
    }

    boolean endSubTask() {
        if (this.isAlive()) {
            Task currentTask = this.m_task.getCurrentTask();
            assert (currentTask != null) : "'currentTask' of method 'endSubTask' must not be null";
            boolean notify = false;
            if (this.m_currentSubTask == currentTask) {
                Float increment = currentTask.end();
                assert (currentTask.isFinished()) : "Not finished: " + String.valueOf(currentTask);
                if (increment != null) {
                    this.m_worked += increment.floatValue();
                    this.m_workedInPercent = Math.round(this.m_worked);
                    notify = true;
                }
                Task parent = currentTask.getParentTask();
                this.handleTaskFinished(currentTask);
                this.m_currentSubTask = parent;
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("currentTask is not the current sub task: {} != {}", (Object)currentTask, (Object)this.m_currentSubTask);
            }
            return notify;
        }
        return true;
    }

    void beginBlockOfWork(int workItems) {
        if (this.isAlive()) {
            Task currentTask = this.m_task.getCurrentTask();
            assert (currentTask != null) : "'currentTask' of method 'beginBlockOfWork' must not be null";
            currentTask.beginBlockOfWork(workItems);
        }
    }

    boolean workItemCompleted() {
        if (this.isAlive()) {
            Task currentTask = this.m_task.getCurrentTask();
            assert (currentTask != null) : "Parameter 'currentTask' of method 'beginBlockOfWork' must not be null";
            currentTask.workItemCompleted();
            this.m_worked += currentTask.getWorkIncrement();
            int rounded = Math.round(this.m_worked);
            if (this.m_workedInPercent != rounded) {
                this.m_workedInPercent = rounded;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean endStep() {
        if (this.isAlive()) {
            Task currentTask = this.m_task.getCurrentTask();
            assert (currentTask != null) : "Parameter 'currentTask' of method 'endStep' must not be null";
            assert (!currentTask.isFinished()) : "Already finished: " + String.valueOf(currentTask);
            Float increment = currentTask.endStep();
            boolean notify = false;
            if (increment != null) {
                this.m_worked += increment.floatValue();
                int rounded = Math.round(this.m_worked);
                if (this.m_workedInPercent != rounded) {
                    this.m_workedInPercent = rounded;
                    notify = true;
                }
            }
            if (currentTask.isFinished()) {
                this.handleTaskFinished(currentTask);
                return true;
            }
            return notify;
        }
        return true;
    }

    void activity(String message, boolean isMainStep) {
        if (this.isAlive()) {
            assert (this.m_isRunning) : "Is not running";
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'activity' must not be empty";
            this.m_currentMessage = message;
            this.m_currentIsMainStep = isMainStep;
        }
    }

    public String toString() {
        if (this.m_justStarted) {
            return "Started: " + this.m_currentMessage;
        }
        if (!this.m_isRunning) {
            return "Finished";
        }
        StringBuilder builder = new StringBuilder("Progress ");
        builder.append(this.m_workedInPercent);
        builder.append("%");
        builder.append(" - ");
        builder.append("\"").append(this.m_currentMessage).append("\"");
        if (this.m_task != null && !this.m_task.isFinished() && this.m_task != this.m_task.getCurrentTask()) {
            builder.append(" of ");
            builder.append(this.m_task.getCurrentTask());
        }
        return builder.toString();
    }
}

