/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.javapg.runtime.messaging;

import java.text.MessageFormat;

public class Position {
    private static String format = "{0}({1},{2})";
    private final String fileName;
    private final int line;
    private final int column;
    private final int offset;
    private final int length;

    public int getColumn() {
        return this.column;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLine() {
        return this.line;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public Position(String f, int l, int c, int o, int len) {
        this.fileName = f;
        this.line = l;
        this.column = c;
        this.offset = o;
        this.length = len;
    }

    public Position offsetBy(int offset) {
        return new Position(this.fileName, this.line, this.column + offset, this.offset + offset, this.length - offset);
    }

    public static void setFormat(String positionFormat) {
        assert (positionFormat != null);
        format = positionFormat;
    }

    public String toString() {
        Object[] args = new Object[]{this.getFileName(), Integer.toString(this.getLine()), Integer.toString(this.getColumn()), Integer.toString(this.getOffset())};
        return MessageFormat.format(format, args);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + this.line;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        return this.offset == other.offset;
    }
}

