/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.javapg.runtime.lexer;

import com.hello2morrow.javapg.runtime.lexer.Keyword;
import com.hello2morrow.javapg.runtime.lexer.Token;
import com.hello2morrow.javapg.runtime.lexer.base.AbstractLexer;

public final class KeywordToken
extends Token {
    Keyword[] keywords;
    boolean insensitive;

    public KeywordToken(int code, Keyword[] keywords, boolean insensitive) {
        super(code);
        this.keywords = keywords;
        this.insensitive = insensitive;
    }

    public boolean isKeyword(String id) {
        return this.getCode(id, this.code) != this.code;
    }

    private int getCode(String lexeme, int code) {
        if (this.insensitive) {
            lexeme = lexeme.toLowerCase();
        }
        int low = 0;
        int high = this.keywords.length;
        while (low < high) {
            int mid = high + low >> 1;
            Keyword kw = this.keywords[mid];
            int rel = lexeme.compareTo(kw.getKeyword());
            if (rel < 0) {
                high = mid;
                continue;
            }
            if (rel > 0) {
                low = mid + 1;
                continue;
            }
            return kw.getCode();
        }
        return code;
    }

    @Override
    public int getCode(AbstractLexer lexer) {
        if (lexer != null) {
            return this.getCode(lexer.getLexeme(), this.code);
        }
        return this.code;
    }
}

