/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.refactoringsview;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import java.util.EnumSet;

public enum StatusGroup implements IStandardEnumeration
{
    APPLICABLE(true),
    NOT_APPLICABLE(false);

    private boolean m_applicable;

    private StatusGroup(boolean applicable) {
        this.m_applicable = applicable;
    }

    public EnumSet<StatusInfo.Status> getGroup() {
        EnumSet<StatusInfo.Status> result = EnumSet.noneOf(StatusInfo.Status.class);
        StatusInfo.Status[] statusArray = StatusInfo.Status.values();
        int n2 = statusArray.length;
        int n3 = 0;
        while (n3 < n2) {
            StatusInfo.Status status = statusArray[n3];
            if (this.contains(status)) {
                result.add(status);
            }
            ++n3;
        }
        return result;
    }

    public boolean contains(StatusInfo.Status status) {
        return status.isApplicable() == this.m_applicable;
    }

    public String getGroupPresentationString() {
        StringBuffer result = new StringBuffer("Status contained in '");
        result.append(this.getPresentationName()).append("':");
        for (StatusInfo.Status status : this.getGroup()) {
            result.append(StringUtility.LINE_SEPARATOR).append(status.getPresentationName());
        }
        return result.toString();
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return StringUtility.convertConstantNameToPresentationName((String)this.name());
    }
}

