/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graph;

import com.hello2morrow.draw2d.bR;
import com.hello2morrow.draw2d.ba;
import com.hello2morrow.foundation.utilities.CollectionUtility;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.command.common.c;
import com.hello2morrow.sonargraph.core.command.system.G;
import com.hello2morrow.sonargraph.core.command.system.ac;
import com.hello2morrow.sonargraph.core.command.system.ad;
import com.hello2morrow.sonargraph.core.command.system.ae;
import com.hello2morrow.sonargraph.core.command.system.aw;
import com.hello2morrow.sonargraph.core.command.system.ax;
import com.hello2morrow.sonargraph.core.command.system.u;
import com.hello2morrow.sonargraph.core.command.system.v;
import com.hello2morrow.sonargraph.core.command.system.w;
import com.hello2morrow.sonargraph.core.command.system.y;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graph.GraphContext;
import com.hello2morrow.sonargraph.core.model.graph.GraphMode;
import com.hello2morrow.sonargraph.core.model.graph.GraphRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.representation.CreateRepresentationMode;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.AutozoomMode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidget;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.f;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.t;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.z;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.graph.d;
import com.hello2morrow.sonargraph.ui.swt.graph.e;
import com.hello2morrow.sonargraph.ui.swt.graph.g;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GraphView
extends DrawableSlaveView {
    private static final String HIGHLIGHT_ORIGINAL_INPUT_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.highlightInputGraphView";
    private static final String SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES_MENU_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.showOnlyDependenciesOfSelectedNodesGraphView";
    private static final String SHOW_ONLY_VIOLATIONS = "com.hello2morrow.sonargraph.standalone.handledmenuitem.showOnlyViolationsGraphView";
    private static final String HIDE_SELF_ARCS = "com.hello2morrow.sonargraph.standalone.handledmenuitem.hideSelfArcsGraphView";
    private static final String SHOW_ONLY_VISIBLE_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledtoolitem.onlyVisible";
    private final List<RepresentationNode> m_currentlySelectedNodes = new ArrayList<RepresentationNode>();
    private e m_graphWidget;

    @Override
    public IViewId getViewId() {
        return ViewId.GRAPH_VIEW;
    }

    @Override
    public final List<Control> getControlsForInteraction() {
        return Collections.singletonList(this.m_graphWidget);
    }

    @Override
    public final IContext getContext() {
        GraphRepresentation graphRepresentation = this.getCurrentGraphRepresentation();
        if (graphRepresentation != null && this.m_graphWidget != null && this.m_graphWidget.h()) {
            return new GraphContext(super.getContext(), true, graphRepresentation);
        }
        return super.getContext();
    }

    protected e createGraphWidget(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createGraphWidget' must not be null";
        return new e(viewContentArea, this.getSelectionProviderAdapter(), new g(), AutozoomMode.NONE);
    }

    @Override
    protected final void createDrawableWidget(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createDrawableWidget' must not be null";
        this.m_graphWidget = this.createGraphWidget(composite);
        this.m_graphWidget.a(this);
    }

    protected final GraphRepresentation getCurrentGraphRepresentation() {
        if (this.m_graphWidget != null) {
            return (GraphRepresentation)this.m_graphWidget.M();
        }
        return null;
    }

    protected final void clear() {
        this.m_currentlySelectedNodes.clear();
        if (this.m_graphWidget != null) {
            this.m_graphWidget.m();
        }
    }

    @Override
    protected void destroyViewContent() {
        super.destroyViewContent();
        if (this.m_graphWidget != null) {
            this.m_graphWidget.J();
            this.m_graphWidget.dispose();
            this.m_graphWidget = null;
        }
        this.clear();
    }

    protected boolean hideOnSoftwareSystemClosed() {
        return true;
    }

    @Override
    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.clear();
        if (this.hideOnSoftwareSystemClosed()) {
            this.hideView();
        }
    }

    protected void consumeRepresentationCommand(G<GraphRepresentation> command, t view) {
        if (this.getGraphWidget() != null && !this.getGraphWidget().isDisposed()) {
            this.getGraphWidget().J();
            this.getGraphWidget().setRedraw(false);
            GraphRepresentation representation = (GraphRepresentation)command.o();
            EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.of(DrawableWidget.ShowOption.SCROLL_TO_TOP);
            if (this.fitToView()) {
                showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
            }
            this.getGraphWidget().a((GraphRepresentation)command.o(), showOptions);
            this.getSelectionProviderAdapter().d();
            this.finishGraphCreation();
            if (this.getHighlightOriginalSelectionHandledItemId() != null) {
                this.updateHandledMenuItemState(this.getHighlightOriginalSelectionHandledItemId(), this.isOriginalSelectionHighlighted());
            }
            this.refreshUIElements();
            this.updateStatusWidget(representation.getParserDependencyTypesForEdges(), representation.getFocusMode(), representation.getRepresentationProperties());
            this.getGraphWidget().setRedraw(true);
            this.enableView();
            this.setViewReady(true);
            WorkbenchRegistry.c().b(view);
        } else {
            this.removeRepresentationFromModel(command.o(), false, false);
            this.hideView();
        }
    }

    @Override
    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, final boolean secondaryIdReused) {
        assert (elements != null) : "Parameter 'elements' of method 'showInView' must not be null";
        assert (options != null) : "Parameter 'option' of method 'showInView' must not be null";
        ViewNavigationManager.a().d(this.getViewId(), this.getSecondaryId());
        this.m_currentlySelectedNodes.clear();
        FocusMode focusMode = null;
        PresentationMode presentationMode = null;
        GraphMode graphMode = null;
        HashSet<CoreParserDependencyType> dependencyTypes = new HashSet<CoreParserDependencyType>();
        EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties = EnumSet.noneOf(NodeAndEdgeRepresentation.RepresentationProperty.class);
        for (IStandardEnumeration option : options) {
            if (option instanceof FocusMode) {
                focusMode = (FocusMode)option;
                continue;
            }
            if (option instanceof PresentationMode) {
                presentationMode = (PresentationMode)option;
                continue;
            }
            if (option instanceof GraphMode) {
                graphMode = (GraphMode)option;
                continue;
            }
            if (option instanceof NodeAndEdgeRepresentation.RepresentationProperty) {
                properties.add((NodeAndEdgeRepresentation.RepresentationProperty)option);
                continue;
            }
            if (option instanceof CoreParserDependencyType) {
                dependencyTypes.add((CoreParserDependencyType)option);
                continue;
            }
            assert (false) : "Unexpected class '" + option.getClass() + "' in 'showInView'";
        }
        if (dependencyTypes.isEmpty()) {
            dependencyTypes.addAll(CollectionUtility.asSet((Object[])CoreParserDependencyType.values()));
        }
        HashSet<NamedElement> namedElements = new HashSet<NamedElement>();
        for (Element nextElement : elements) {
            assert (nextElement instanceof NamedElement) : "Not a named element: " + nextElement;
            namedElements.add((NamedElement)nextElement);
        }
        int nameSuffix = -1;
        if (secondaryIdReused) {
            assert (this.m_graphWidget != null) : "'m_graphWidget' of method 'showInView' must not be null";
            NodeAndEdgeRepresentation currentRepresentation = this.m_graphWidget.M();
            assert (currentRepresentation != null) : "'currentRepresentation' of method 'showInView' must not be null";
            nameSuffix = currentRepresentation.getId();
        }
        final y command = new y(this.getSoftwareSystemProvider(), namedElements, focusMode, presentationMode, properties, dependencyTypes, this.getEndpointType(), graphMode, nameSuffix, this.applyCycleAnalysis());
        this.setViewReady(false);
        if (command.g().isSuccess()) {
            UserInterfaceAdapter.b().a((c)command, new com.hello2morrow.sonargraph.core.command.common.f(){

                public void a(com.hello2morrow.sonargraph.core.command.common.d exception) {
                    super.a(exception);
                    if (exception == null && GraphView.this.m_graphWidget != null && !GraphView.this.m_graphWidget.isDisposed()) {
                        GraphView.this.m_graphWidget.J();
                        GraphView.this.m_graphWidget.setRedraw(false);
                        GraphRepresentation representation = (GraphRepresentation)command.o();
                        EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.of(DrawableWidget.ShowOption.REVEAL_INPUT, DrawableWidget.ShowOption.SCROLL_TO_TOP);
                        if (GraphView.this.fitToView()) {
                            showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
                        }
                        GraphView.this.m_graphWidget.a(representation, showOptions);
                        GraphView.this.getSelectionProviderAdapter().d();
                        GraphView.this.finishGraphCreation();
                        GraphView.this.updateHandledMenuItemState(GraphView.this.getHighlightOriginalSelectionHandledItemId(), GraphView.this.isOriginalSelectionHighlighted());
                        GraphView.this.updateStatusWidget(representation.getParserDependencyTypesForEdges(), representation.getFocusMode(), representation.getRepresentationProperties());
                        GraphView.this.setSelection(representation.getOriginalNodes());
                        GraphView.this.refreshUIElements();
                        GraphView.this.m_graphWidget.setRedraw(true);
                        GraphView.this.performFinishShowInView(secondaryIdReused);
                    } else {
                        GraphView.this.removeRepresentationFromModel(command.o(), false, false);
                        GraphView.this.hideView();
                    }
                }
            });
        }
    }

    @Override
    public void requestHome() {
        final NavigationState initialViewState = ViewNavigationManager.a().a(this.getViewId(), this.getSecondaryId());
        assert (initialViewState != null) : "Parameter 'initialViewState' of method 'requestHome' must not be null";
        ViewNavigationManager.a().d(this.getViewId(), this.getSecondaryId());
        z internalNavigationState = new z(initialViewState, this.getElementResolver());
        GraphMode graphMode = null;
        Set dependencyTypes = internalNavigationState.getDependencyTypesForEdges();
        EnumSet properties = internalNavigationState.getProperties();
        if (properties.contains(NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH)) {
            graphMode = properties.contains(NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY) ? GraphMode.TYPE_BASED_EXCLUDING_NESTED_TYPES : GraphMode.TYPE_BASED_INCLUDING_NESTED_TYPES;
        }
        final v cmd = new v(this.getSoftwareSystemProvider(), (GraphRepresentation)this.m_graphWidget.M(), new HashSet(internalNavigationState.getMainNodes()), internalNavigationState.getFocusMode(), internalNavigationState.getPresentationMode(), properties, dependencyTypes, this.getEndpointType(), graphMode, this.applyCycleAnalysis());
        this.setViewReady(false);
        if (cmd.g().isSuccess()) {
            UserInterfaceAdapter.b().a((c)cmd, new com.hello2morrow.sonargraph.core.command.common.f(){

                public void a(com.hello2morrow.sonargraph.core.command.common.d exception) {
                    super.a(exception);
                    if (exception == null && GraphView.this.m_graphWidget != null && !GraphView.this.m_graphWidget.isDisposed()) {
                        GraphView.this.m_graphWidget.J();
                        GraphView.this.m_graphWidget.setRedraw(false);
                        GraphRepresentation representation = (GraphRepresentation)cmd.o();
                        GraphView.this.m_graphWidget.a(representation, EnumSet.allOf(DrawableWidget.ShowOption.class));
                        GraphView.this.getSelectionProviderAdapter().d();
                        GraphView.this.getDrawableWidget().E();
                        GraphView.this.updateHandledMenuItemState(GraphView.this.getHighlightOriginalSelectionHandledItemId(), GraphView.this.isOriginalSelectionHighlighted());
                        GraphView.this.updateStatusWidget(representation.getParserDependencyTypesForEdges(), representation.getFocusMode(), representation.getRepresentationProperties());
                        GraphView.this.m_graphWidget.z();
                        GraphView.this.setSelection(representation.getOriginalNodes());
                        GraphView.this.refreshUIElements();
                        GraphView.this.m_graphWidget.setRedraw(true);
                        GraphView.this.enableView();
                        GraphView.this.setViewReady(true);
                        ViewNavigationManager.a().b(initialViewState);
                    } else {
                        GraphView.this.removeRepresentationFromModel(cmd.o(), false, false);
                        GraphView.this.hideView();
                    }
                }
            });
        }
    }

    @Override
    protected final void focusRepresentationInView(Collection<RepresentationNode> elementsToFocus, Set<CoreParserDependencyType> dependencyTypes, FocusMode focusMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties) {
        ae cmd;
        assert (elementsToFocus != null) : "Parameter 'elementsToFocus' of method 'focusRepresentationInView' must not be null";
        assert (dependencyTypes != null) : "Parameter 'dependencyTypes' of method 'focusRepresentationInView' must not be null";
        assert (focusMode != null) : "Parameter 'focusMode' of method 'focusRepresentationInView' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'focusRepresentationInView' must not be null";
        assert (this.m_graphWidget != null) : " 'm_graphWidget' of method 'focusRepresentationInView' must not be null";
        NodeAndEdgeRepresentation underlyingRepresentation = this.m_graphWidget.M();
        assert (underlyingRepresentation != null) : "'underlyingRepresentation' of method 'focusRepresentationInView' must not be null";
        EnumSet representationProperties = underlyingRepresentation.getRepresentationProperties();
        if (representationProperties.contains(NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH)) {
            properties.add(NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH);
            if (underlyingRepresentation.getRepresentationProperties().contains(NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY)) {
                properties.add(NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY);
            }
        }
        if ((cmd = new ae(this.getSoftwareSystemProvider(), this.getCurrentGraphRepresentation(), elementsToFocus, dependencyTypes, focusMode, properties)).g().isSuccess()) {
            UserInterfaceAdapter.b().a((c)cmd, new com.hello2morrow.sonargraph.core.command.common.f(){

                public void a(com.hello2morrow.sonargraph.core.command.common.d exception) {
                    super.a(exception);
                    if (exception == null && GraphView.this.m_graphWidget != null && !GraphView.this.m_graphWidget.isDisposed()) {
                        GraphView.this.m_graphWidget.J();
                        GraphView.this.m_graphWidget.setRedraw(false);
                        EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.of(DrawableWidget.ShowOption.REVEAL_INPUT);
                        if (GraphView.this.fitToView()) {
                            showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
                        }
                        GraphRepresentation representation = (GraphRepresentation)cmd.o();
                        GraphView.this.m_graphWidget.a(representation, showOptions);
                        GraphView.this.getDrawableWidget().E();
                        GraphView.this.setSelection(representation.getOriginalNodes());
                        GraphView.this.saveViewState(GraphView.this.m_graphWidget, NavigationState.Type.CONTENT_FOCUSED);
                        GraphView.this.updateHandledMenuItemState(GraphView.this.getHighlightOriginalSelectionHandledItemId(), GraphView.this.isOriginalSelectionHighlighted());
                        GraphView.this.updateStatusWidget(representation.getParserDependencyTypesForEdges(), representation.getFocusMode(), representation.getRepresentationProperties());
                        GraphView.this.refreshSelection();
                        GraphView.this.m_graphWidget.setRedraw(true);
                        GraphView.this.m_graphWidget.a(GraphView.this);
                        GraphView.this.refreshUIElements();
                    } else {
                        GraphView.this.removeRepresentationFromModel(cmd.o(), false, false);
                        GraphView.this.hideView();
                    }
                }
            });
        }
    }

    @Override
    public List<Element> getSelectedElements() {
        if (!this.isReady() || this.m_graphWidget == null) {
            return Collections.emptyList();
        }
        return this.m_graphWidget.A();
    }

    protected boolean applyCycleAnalysis() {
        return true;
    }

    @Override
    protected boolean needsRepresentationCreation(z internalState) {
        boolean shouldChangePresentationMode;
        PresentationMode presentationMode;
        Set<Object> currentAdditionals;
        Set<Object> currentMainPathElements;
        assert (internalState != null) : "Parameter 'internalState' of method 'needsRepresentationCreation' must not be null";
        if (this.m_graphWidget.M() != null) {
            currentMainPathElements = this.removeOnDemandCyclesFromCollection(this.m_graphWidget.M().getMainNodes());
            currentAdditionals = this.removeOnDemandCyclesFromCollection(this.m_graphWidget.M().getAdditionalNodes());
        } else {
            currentMainPathElements = Collections.emptySet();
            currentAdditionals = Collections.emptySet();
        }
        boolean elementsChanged = !CollectionUtility.collectionsContainSameElements((Collection)internalState.getMainNodes(), currentMainPathElements) || !CollectionUtility.collectionsContainSameElements((Collection)internalState.getAdditionalElements(), currentAdditionals);
        PresentationMode presentationMode2 = presentationMode = this.getDrawableWidget() != null ? this.getDrawableWidget().T() : null;
        boolean bl2 = presentationMode == null ? true : (shouldChangePresentationMode = presentationMode != internalState.getPresentationMode());
        return elementsChanged || shouldChangePresentationMode;
    }

    @Override
    protected final void finishCreateRepresentationForNavigation(final z state) {
        assert (state != null) : "Parameter 'state' of method 'finishCreateRepresentation' must not be null";
        assert (!state.a().g()) : "Undo/Redo related states not supported in navigation, state id: " + state.a().getId();
        NodeAndEdgeRepresentation currentRepresentation = this.getDrawableWidget().M();
        assert (currentRepresentation != null && currentRepresentation instanceof GraphRepresentation) : "Unexpected class in method 'finishCreateRepresentation': " + currentRepresentation;
        final w cmd = new w(this.getSoftwareSystemProvider(), (GraphRepresentation)currentRepresentation, state.getOriginalInput(), new HashSet(state.getMainNodes()), state.getAdditionalElements(), state.getDependencyTypesForEdges(), state.getFocusMode(), state.getPresentationMode(), state.getProperties(), state.a().getId());
        if (cmd.g().isSuccess()) {
            this.disableView();
            UserInterfaceAdapter.b().a((c)cmd, new com.hello2morrow.sonargraph.core.command.common.f(){

                public void a(com.hello2morrow.sonargraph.core.command.common.d exception) {
                    super.a(exception);
                    if (exception == null && GraphView.this.m_graphWidget != null && !GraphView.this.m_graphWidget.isDisposed()) {
                        EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.noneOf(DrawableWidget.ShowOption.class);
                        if (GraphView.this.autozoomEnabled() && GraphView.this.fitToView()) {
                            showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
                        }
                        if (!((GraphRepresentation)cmd.o()).getOriginalNodes().isEmpty()) {
                            showOptions.add(DrawableWidget.ShowOption.REVEAL_INPUT);
                        }
                        GraphView.this.m_graphWidget.a((GraphRepresentation)cmd.o(), showOptions);
                        GraphView.this.applyNavigationState(state, !showOptions.contains((Object)DrawableWidget.ShowOption.FIT_TO_VIEW), CreateRepresentationMode.NAVIGATION);
                        GraphView.this.finishNonUndoRedoRepresentationCreation(cmd.o(), state);
                        GraphView.this.enableView();
                    } else {
                        GraphView.this.removeRepresentationFromModel(cmd.o(), false, false);
                        GraphView.this.hideView();
                    }
                }
            });
        }
    }

    public Set<NamedElement> removeOnDemandCyclesFromCollection(Collection<NamedElement> input) {
        assert (input != null) : "Parameter 'input' of method 'removeOnDemandCyclesFromCollection' must not be null";
        HashSet<NamedElement> withoutCycles = new HashSet<NamedElement>();
        for (NamedElement namedElement : input) {
            if (namedElement instanceof OnDemandCycleGroup) {
                withoutCycles.addAll(((OnDemandCycleGroup)namedElement).getCyclicNamedElements());
                continue;
            }
            withoutCycles.add(namedElement);
        }
        return withoutCycles;
    }

    @Override
    protected void applyNavigationState(z state, boolean applyZoomFromState, CreateRepresentationMode createRepresentationMode) {
        assert (state != null) : "Parameter 'state' of method 'applyNavigationState' must not be null";
        Collection selected = state.getSelection();
        Collection selectedConnections = state.getEndPointSelection();
        ArrayList<com.hello2morrow.sonargraph.ui.swt.base.draw2d.e> items = new ArrayList<com.hello2morrow.sonargraph.ui.swt.base.draw2d.e>(selected.size() + selectedConnections.size());
        for (NamedElement element : selected) {
            f node = this.m_graphWidget.a(element);
            if (node == null) continue;
            items.add(node);
        }
        for (Pair dependency : selectedConnections) {
            f.a<? extends f> connection = this.m_graphWidget.a((Pair<NamedElement, NamedElement>)dependency);
            if (connection == null) continue;
            items.add(connection);
        }
        this.m_graphWidget.a(items, true);
        if (this.isHighlightInputMenuItemSelected()) {
            this.m_graphWidget.E();
        }
        if (applyZoomFromState) {
            this.m_graphWidget.a(state.getZoomLevel());
        }
        StructuredSelection selection = new StructuredSelection(this.m_graphWidget.B().toArray());
        this.getSelectionProviderAdapter().b((IStructuredSelection)selection);
        if (createRepresentationMode == CreateRepresentationMode.NAVIGATION) {
            NodeAndEdgeRepresentation representation = this.getDrawableWidget().M();
            assert (representation != null) : "'representation' of method 'applyNavigationState' must not be null";
            representation.applyProgrammingElementCollectionsState(state.a().getId());
        }
        this.refreshUIElements();
        this.refreshSelection();
        this.updateHandledMenuItemState(this.getHighlightOriginalSelectionHandledItemId(), this.isOriginalSelectionHighlighted());
    }

    @Override
    public final DrawableWidget getDrawableWidget() {
        return this.m_graphWidget;
    }

    @Override
    public boolean startElementsMoveInteraction(Gesture gesture, List<Element> selectedElements) {
        assert (gesture != null) : "Parameter 'gesture' of method 'startElementsMoveInteraction' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'startElementsMoveInteraction' must not be null";
        if (selectedElements.size() == 1 && selectedElements.get(0) instanceof RepresentationNode) {
            switch (gesture) {
                case MOVE_ELEMENT_COMPOSITE: {
                    return false;
                }
                case MOVE_ELEMENT_SIMPLE: {
                    return true;
                }
            }
            assert (false) : "Unhandled gesture: " + (Object)((Object)gesture);
        }
        return false;
    }

    protected void setLocation(d node, bR targetLocation, boolean allowYAxisDragging) {
        assert (node != null) : "Parameter 'node' of method 'setLocation' must not be null";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'setLocation' must not be null";
        int xLocation = targetLocation.b - Math.round((float)node.I().b / 2.0f);
        int yLocation = allowYAxisDragging ? targetLocation.c - node.I().c / 2 : node.D().c;
        xLocation = Math.max(xLocation, 0);
        yLocation = Math.max(yLocation, 0);
        node.f(new bR(xLocation, yLocation));
    }

    @Override
    public void inElementsMoveInteraction(Gesture gesture, List<Element> selectedElements, bR sourceLocation, bR targetLocation) {
        assert (gesture != null) : "Parameter 'gesture' of method 'inElementsMoveInteraction' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'inElementsMoveInteraction' must not be null";
        assert (sourceLocation != null) : "Parameter 'sourceLocation' of method 'inElementsMoveInteraction' must not be null";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'inElementsMoveInteraction' must not be null";
        switch (gesture) {
            case MOVE_ELEMENT_COMPOSITE: {
                assert (false) : "Not supported";
                break;
            }
            case MOVE_ELEMENT_SIMPLE: {
                assert (selectedElements.size() == 1) : "Exactly on element expected";
                Element element = selectedElements.get(0);
                assert (element != null && element instanceof RepresentationNode) : "Unexpected class in method 'inElementsMoveInteraction': " + element;
                d node = (d)this.m_graphWidget.a(((RepresentationNode)element).getUnderlyingObject());
                this.setLocation(node, targetLocation, this.allowYAxisDragging());
                break;
            }
            default: {
                assert (false) : "Unhandled gesture: " + (Object)((Object)gesture);
                break;
            }
        }
    }

    @Override
    public void finishElementsMoveInteraction(Gesture gesture, List<Element> selectedElements, bR sourceLocation, bR targetLocation) {
        assert (gesture != null) : "Parameter 'gesture' of method 'finishElementsMoveInnteraction' must not be null";
        assert (sourceLocation != null) : "Parameter 'sourceLocation' of method 'finishElementsMoveInnteraction' must not be null";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'finishElementsMoveInnteraction' must not be null";
        switch (gesture) {
            case MOVE_ELEMENT_COMPOSITE: {
                assert (false) : "Not supported";
                break;
            }
            case MOVE_ELEMENT_SIMPLE: {
                this.m_graphWidget.f(true);
                break;
            }
            default: {
                assert (false) : "Unhandled gesture: " + (Object)((Object)gesture);
                break;
            }
        }
    }

    protected boolean allowYAxisDragging() {
        return false;
    }

    protected final e getGraphWidget() {
        return this.m_graphWidget;
    }

    @Override
    protected final ba getFigureForImageExport() {
        assert (this.m_graphWidget != null) : "'m_graphWidget' of method 'getFigureForImageExport' must not be null";
        return this.m_graphWidget.q().a();
    }

    public EndpointType getEndpointType() {
        return EndpointType.PARSER_DEPENDENCY;
    }

    protected void finishGraphCreation() {
        this.getDrawableWidget().E();
    }

    @Override
    public final void nodeSelected(RepresentationNode node) {
        assert (node != null) : "Parameter 'node' of method 'nodeSelected' must not be null";
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().a(this.getSelectedElements());
        }
    }

    @Override
    public final void nodeDeselected(RepresentationNode node) {
        assert (node != null) : "Parameter 'node' of method 'nodeDeselected' must not be null";
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().a(this.getSelectedElements());
        }
    }

    @Override
    public final void edgeSelected(RepresentationEdge<RepresentationNode> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'edgeSelected' must not be null";
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().a(this.getSelectedElements());
        }
    }

    @Override
    public final void edgeDeselected(RepresentationEdge<RepresentationNode> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'edgeDeselected' must not be null";
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().a(this.getSelectedElements());
        }
    }

    protected G<GraphRepresentation> getCommandForPresentationModification(NodeAndEdgeRepresentation representation, PresentationMode presentationMode) {
        assert (representation != null && representation instanceof GraphRepresentation) : "Unexpected class in method 'getCommandForPresentationModification': " + representation;
        return new u(this.getSoftwareSystemProvider(), (GraphRepresentation)representation, presentationMode);
    }

    @Override
    public void canvasClicked() {
        if (this.isReady()) {
            this.saveViewState(this.m_graphWidget, NavigationState.Type.CONTENT_SELECTED);
            this.getSelectionProviderAdapter().a(this.getSelectedElements());
        }
    }

    @Override
    public List<IStandardEnumeration> getAdditionalShowInViewOptions() {
        ArrayList<IStandardEnumeration> options = new ArrayList<IStandardEnumeration>(1);
        if (this.getDrawableWidget().M() == null) {
            options.add((IStandardEnumeration)PresentationMode.HIERARCHICAL);
        } else {
            PresentationMode presentationMode = this.getDrawableWidget().T();
            assert (presentationMode != null) : "'presentationMode' of method 'getAdditionalShowInViewOptions' must not be null";
            options.add((IStandardEnumeration)presentationMode);
        }
        return options;
    }

    @Override
    protected ac<? extends NodeAndEdgeRepresentation> getExtendFocusCommand(ISoftwareSystemProvider provider, NodeAndEdgeRepresentation currentRepresentation, List<Element> selection, boolean onlyVisible) {
        assert (provider != null) : "Parameter 'provider' of method 'getExtendFocusCommand' must not be null";
        assert (currentRepresentation != null) : "Parameter 'currentRepresentation' of method 'getExtendFocusCommand' must not be null";
        assert (selection != null) : "Parameter 'elementsToFocus' of method 'getExtendFocusCommand' must not be null";
        return new ad(provider, (GraphRepresentation)currentRepresentation, selection, onlyVisible);
    }

    @Override
    protected aw<? extends NodeAndEdgeRepresentation> getRemoveFromFocusCommand(ISoftwareSystemProvider provider, NodeAndEdgeRepresentation currentRepresentation, List<Element> selection) {
        assert (provider != null) : "Parameter 'provider' of method 'getRemoveFromFocusCommand' must not be null";
        assert (currentRepresentation != null) : "Parameter 'currentRepresentation' of method 'getRemoveFromFocusCommand' must not be null";
        assert (selection != null) : "Parameter 'elementsToRemoveFromFocus' of method 'getRemoveFromFocusCommand' must not be null";
        return new ax(provider, (GraphRepresentation)currentRepresentation, selection);
    }

    @Override
    protected String getHighlightOriginalSelectionHandledItemId() {
        return HIGHLIGHT_ORIGINAL_INPUT_TOOLITEM_ID;
    }

    @Override
    protected String getShowOnlyDependenciesOfSelectedNodesHandledItemId() {
        return SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES_MENU_ID;
    }

    @Override
    protected String getShowOnlyViolationsHandledItemId() {
        return SHOW_ONLY_VIOLATIONS;
    }

    @Override
    protected String getHideSelfArcsHandledItemId() {
        return HIDE_SELF_ARCS;
    }

    @Override
    protected String getOnlyVisibleHandledItemId() {
        return SHOW_ONLY_VISIBLE_TOOLITEM_ID;
    }

    public static enum UnbalancedElementGroup implements IElementGroup
    {
        UNBALANCED_ELEMENTS;

    }
}

