/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureIssueWithLineNumber;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.ui.swt.common.g;
import com.hello2morrow.sonargraph.ui.swt.common.h;
import com.hello2morrow.sonargraph.ui.swt.common.j;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArchitectureFileViewShowInViewSupport
extends j {
    private static volatile /* synthetic */ int[] b;

    public ArchitectureFileViewShowInViewSupport(String presentationName, String imageName) {
        super(presentationName, imageName);
    }

    private static FileTargetValue a(IArchitectureElement element) {
        assert (element != null) : "Parameter 'element' of method 'getFileTargetValue' must not be null";
        return FileTargetValue.ARTEFACT;
    }

    private static FileTargetValue a(Artifact artifact) {
        assert (artifact != null) : "Parameter 'artifact' of method 'getFileTargetValue' must not be null";
        if (artifact.isRequired()) {
            if (artifact.isUnrestricted()) {
                return FileTargetValue.ARTEFACT_UNRESTRICTED_REQUIRED;
            }
            if (artifact.isStrict()) {
                return FileTargetValue.ARTEFACT_STRICT_REQUIRED;
            }
            if (artifact.isRelaxed()) {
                return FileTargetValue.ARTEFACT_RELAXED_REQUIRED;
            }
            return FileTargetValue.ARTEFACT_REQUIRED;
        }
        if (artifact.isApplied()) {
            if (artifact.isUnrestricted()) {
                return FileTargetValue.ARTEFACT_UNRESTRICTED_APPLIED;
            }
            if (artifact.isStrict()) {
                return FileTargetValue.ARTEFACT_STRICT_APPLIED;
            }
            if (artifact.isRelaxed()) {
                return FileTargetValue.ARTEFACT_RELAXED_APPLIED;
            }
            return FileTargetValue.ARTEFACT_APPLIED;
        }
        return null;
    }

    public static List<a> a(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getArchitectureFileTargets' must not be null";
        if (elements.size() == 1) {
            Artifact artifact;
            FileTargetValue fileTargetValue;
            Element element = elements.get(0);
            Issue issue = null;
            if (element instanceof Issue) {
                issue = (Issue)element;
                element = ((Issue)element).getAffectedElement();
            }
            ArrayList<a> targets = new ArrayList<a>(2);
            if (element instanceof ArchitectureElement) {
                ArchitectureElement architectureElement = (ArchitectureElement)element;
                if (issue != null) {
                    int lineNumber = architectureElement.getContextLineNumber();
                    if (issue instanceof ArchitectureIssueWithLineNumber) {
                        lineNumber = issue.getLineNumber();
                    }
                    targets.add(new a(ArchitectureFileViewShowInViewSupport.a((IArchitectureElement)architectureElement), (ArchitectureFile)architectureElement.getParent(ArchitectureFile.class, new Class[0]), lineNumber));
                } else {
                    targets.add(new a(ArchitectureFileViewShowInViewSupport.a((IArchitectureElement)architectureElement), (ArchitectureFile)architectureElement.getDefiningFile(), element.getLineNumber()));
                }
            } else if (element instanceof ArchitectureFile) {
                int lineNumber = -1;
                if (issue != null) {
                    lineNumber = issue.getLineNumber();
                }
                targets.add(new a(FileTargetValue.ARCHITECTURE_FILE, (ArchitectureFile)element, lineNumber));
            }
            if (element instanceof Artifact && (fileTargetValue = ArchitectureFileViewShowInViewSupport.a(artifact = (Artifact)element)) != null) {
                targets.add(new a(fileTargetValue, (ArchitectureFile)artifact.getParent(ArchitectureFile.class, new Class[0]), artifact.getReferencedFromLineNumber()));
            }
            return targets;
        }
        return Collections.emptyList();
    }

    private boolean a(Element element) {
        assert (element != null) : "Parameter 'element' of method 'isArchitectureRelated' must not be null";
        return element instanceof IArchitectureElement || element instanceof ArchitectureFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Element> b(List<Element> elements) {
        Element element;
        assert (elements != null) : "Parameter 'elements' of method 'getElementsForShowInView' must not be null";
        if (elements.size() != 1) return null;
        Element candidate = elements.get(0);
        if (candidate instanceof IDiffElement) {
            Element current = ((IDiffElement)candidate).getCurrentElement();
            if (current == null) {
                return null;
            }
            element = current;
        } else if (candidate instanceof INamedElementAdapter) {
            List adaptedTo = ((INamedElementAdapter)candidate).getAdaptedTo();
            if (adaptedTo.size() != 1) return null;
            element = (Element)adaptedTo.get(0);
        } else {
            element = candidate;
        }
        if (!this.a(element) && (!(element instanceof Issue) || !this.a(((Issue)element).getAffectedElement()))) return null;
        return Collections.singletonList(element);
    }

    @Override
    public g a(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        List<a> architectureFileTargets;
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        assert (secondaryIdForReuse == null) : "Parameter 'secondaryIdForReuse' of method 'supportsShowInViewFor' must  be null";
        List<Element> elementsForShowInView = this.b(selectedElements);
        if (elementsForShowInView != null && !(architectureFileTargets = ArchitectureFileViewShowInViewSupport.a(elementsForShowInView)).isEmpty()) {
            if (architectureFileTargets.size() == 1) {
                a fileTarget = architectureFileTargets.get(0);
                h entry = new h(elementsForShowInView, this.d(), this.e(), true, fileTarget.b().getFileId());
                entry.a(fileTarget.a());
                return new g(entry);
            }
            h rootMenuNode = new h(elementsForShowInView, this.d(), this.e(), true);
            for (a nextFileTarget : architectureFileTargets) {
                h definitionEntry = new h(rootMenuNode.c(), nextFileTarget.a().getPresentationName(), nextFileTarget.a().getImageResourceName(), false, nextFileTarget.b().getFileId());
                definitionEntry.a(nextFileTarget.a());
                rootMenuNode.addChild(definitionEntry);
            }
            return new g(rootMenuNode);
        }
        return null;
    }

    public static a a(List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getArchitectureFileTarget' must not be empty";
        assert (options != null && options.size() == 1) : "Parameter 'options' of method 'getArchitectureFileTarget' must contain 1 element";
        IStandardEnumeration value = options.get(0);
        assert (value != null && value instanceof FileTargetValue) : "Unexpected class in method 'getArchitectureFileTarget': " + value;
        FileTargetValue fileTargetValue = (FileTargetValue)value;
        List<a> fileTargets = ArchitectureFileViewShowInViewSupport.a(elements);
        assert (fileTargets != null && !fileTargets.isEmpty()) : "'fileTargets' of method 'getArchitectureFileTarget' must not be empty";
        switch (ArchitectureFileViewShowInViewSupport.b()[fileTargetValue.ordinal()]) {
            case 1: 
            case 2: {
                return fileTargets.get(0);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                assert (fileTargets.size() == 2) : "Missing file target entry: " + fileTargets;
                return fileTargets.get(1);
            }
        }
        assert (false) : "Unhandled 'fileTargetValue': " + (Object)((Object)fileTargetValue);
        return null;
    }

    static /* synthetic */ int[] b() {
        if (b != null) {
            return b;
        }
        int[] nArray = new int[FileTargetValue.values().length];
        try {
            nArray[FileTargetValue.ARCHITECTURE_FILE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileTargetValue.ARTEFACT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileTargetValue.ARTEFACT_APPLIED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileTargetValue.ARTEFACT_RELAXED_APPLIED.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileTargetValue.ARTEFACT_RELAXED_REQUIRED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileTargetValue.ARTEFACT_REQUIRED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileTargetValue.ARTEFACT_STRICT_APPLIED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileTargetValue.ARTEFACT_STRICT_REQUIRED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileTargetValue.ARTEFACT_UNRESTRICTED_APPLIED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileTargetValue.ARTEFACT_UNRESTRICTED_REQUIRED.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        b = nArray;
        return nArray;
    }

    public static enum FileOption implements com.hello2morrow.sonargraph.ui.swt.common.a
    {
        FILE_TARGET;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    public static final class a {
        private final FileTargetValue b;
        private final ArchitectureFile c;
        private final int d;

        a(FileTargetValue fileTargetValue, ArchitectureFile filePath, int lineNumber) {
            assert (fileTargetValue != null) : "Parameter 'fileTargetValue' of method 'FileTarget' must not be null";
            assert (filePath != null) : "Parameter 'filePath' of method 'FileTarget' must not be null";
            this.b = fileTargetValue;
            this.c = filePath;
            this.d = lineNumber;
        }

        public FileTargetValue a() {
            return this.b;
        }

        public ArchitectureFile b() {
            return this.c;
        }

        public int c() {
            return this.d;
        }
    }

    public static final class FileTargetValue
    extends Enum<FileTargetValue>
    implements IStandardEnumeration {
        public static final /* enum */ FileTargetValue ARCHITECTURE_FILE = new FileTargetValue("Architecture File", "ArchitectureFile");
        public static final /* enum */ FileTargetValue ARTEFACT = new FileTargetValue("Definition", "Artifact");
        public static final /* enum */ FileTargetValue ARTEFACT_REQUIRED = new FileTargetValue("Reference", "ArtifactRequired");
        public static final /* enum */ FileTargetValue ARTEFACT_APPLIED = new FileTargetValue("Reference", "ArtifactApplied");
        public static final /* enum */ FileTargetValue ARTEFACT_STRICT_REQUIRED = new FileTargetValue("Reference", "ArtifactStrictRequired");
        public static final /* enum */ FileTargetValue ARTEFACT_STRICT_APPLIED = new FileTargetValue("Reference", "ArtifactStrictApplied");
        public static final /* enum */ FileTargetValue ARTEFACT_RELAXED_REQUIRED = new FileTargetValue("Reference", "ArtifactRelaxedRequired");
        public static final /* enum */ FileTargetValue ARTEFACT_RELAXED_APPLIED = new FileTargetValue("Reference", "ArtifactRelaxedApplied");
        public static final /* enum */ FileTargetValue ARTEFACT_UNRESTRICTED_REQUIRED = new FileTargetValue("Reference", "ArtifactUnrestrictedRequired");
        public static final /* enum */ FileTargetValue ARTEFACT_UNRESTRICTED_APPLIED = new FileTargetValue("Reference", "ArtifactUnrestrictedApplied");
        private final String m_presentationName;
        private final String m_imageResourceName;
        private static final /* synthetic */ FileTargetValue[] ENUM$VALUES;

        static {
            ENUM$VALUES = new FileTargetValue[]{ARCHITECTURE_FILE, ARTEFACT, ARTEFACT_REQUIRED, ARTEFACT_APPLIED, ARTEFACT_STRICT_REQUIRED, ARTEFACT_STRICT_APPLIED, ARTEFACT_RELAXED_REQUIRED, ARTEFACT_RELAXED_APPLIED, ARTEFACT_UNRESTRICTED_REQUIRED, ARTEFACT_UNRESTRICTED_APPLIED};
        }

        private FileTargetValue(String presentationName, String imageResourceName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'FileTargetValue' must not be empty";
            assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'FileTargetValue' must not be empty";
            this.m_presentationName = presentationName;
            this.m_imageResourceName = imageResourceName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        public String getImageResourceName() {
            return this.m_imageResourceName;
        }

        public static FileTargetValue[] values() {
            FileTargetValue[] fileTargetValueArray = ENUM$VALUES;
            int n2 = fileTargetValueArray.length;
            FileTargetValue[] fileTargetValueArray2 = new FileTargetValue[n2];
            System.arraycopy(ENUM$VALUES, 0, fileTargetValueArray2, 0, n2);
            return fileTargetValueArray2;
        }

        public static FileTargetValue valueOf(String string) {
            return Enum.valueOf(FileTargetValue.class, string);
        }
    }
}

