/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.view;

import com.hello2morrow.foundation.utilities.CollectionUtility;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.ui.swt.common.ElementGroup;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeBasedViewNavigationStateUtility {
    private static final Logger b = LoggerFactory.getLogger(TreeBasedViewNavigationStateUtility.class);

    private TreeBasedViewNavigationStateUtility() {
    }

    public static void a(NavigationState state, IElementResolver resolver, TreeViewer treeViewer, TreeExpansionEvent event, TreeOperation operation, Map<IStateData, Object> stateData) {
        IStructuredSelection currentSelection;
        int n2;
        assert (state != null) : "Parameter 'state' of method 'createViewState' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'createNewViewState' must not be null";
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'createNewViewState' must not be null";
        assert (stateData != null) : "Parameter 'viewData' of method 'createNewViewState' must not be null";
        ArrayList<NamedElement> expanded = new ArrayList<NamedElement>();
        ArrayList<NamedElement> selected = new ArrayList<NamedElement>();
        Object[] expandedElements = treeViewer.getExpandedElements();
        if (expandedElements != null) {
            Object[] objectArray = expandedElements;
            n2 = expandedElements.length;
            int n3 = 0;
            while (n3 < n2) {
                Object next = objectArray[n3];
                if (next instanceof NamedElement) {
                    if (((NamedElement)next).isValid()) {
                        expanded.add((NamedElement)next);
                    }
                } else {
                    b.warn("No a named element: " + next);
                }
                ++n3;
            }
        }
        if (event != null && operation != null) {
            Object object = event.getElement();
            if (object instanceof NamedElement) {
                if (operation == TreeOperation.EXPAND) {
                    if (((NamedElement)object).isValid()) {
                        expanded.add((NamedElement)object);
                    }
                } else {
                    expanded.remove(object);
                }
            } else {
                b.warn("No a named element: " + object);
            }
        }
        if ((currentSelection = (IStructuredSelection)treeViewer.getSelection()) != null) {
            Object[] objectArray = currentSelection.toArray();
            int n4 = objectArray.length;
            n2 = 0;
            while (n2 < n4) {
                Object next = objectArray[n2];
                if (next instanceof NamedElement) {
                    if (((NamedElement)next).isValid()) {
                        selected.add((NamedElement)next);
                    }
                } else {
                    b.warn("No a named element: " + next);
                }
                ++n2;
            }
        }
        state.a(ElementGroup.SELECTION, NavigationState.a(selected, resolver));
        state.a(ElementGroup.EXPANSION, NavigationState.a(expanded, resolver));
        state.a(stateData);
    }

    public static void a(NavigationState state, IElementResolver resolver, TreeViewer treeViewer, TreeExpansionEvent event, TreeOperation operation) {
        TreeBasedViewNavigationStateUtility.a(state, resolver, treeViewer, event, operation, Collections.emptyMap());
    }

    public static void a(NavigationState state, IElementResolver resolver, TreeViewer treeViewer) {
        TreeBasedViewNavigationStateUtility.a(state, resolver, treeViewer, null, null);
    }

    public static void a(TreeViewer treeViewer, NavigationState state, IElementResolver resolver) {
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'restoreViewState' must not be null";
        assert (state != null) : "Parameter 'state' of method 'restoreViewState' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'restoreViewState' must not be null";
        List<Object> currentlyExpandedElements = Arrays.asList(treeViewer.getExpandedElements());
        StructuredSelection currentlySelected = (StructuredSelection)treeViewer.getSelection();
        List<NamedElement> toBeExpanded = state.getElements(ElementGroup.EXPANSION, NamedElement.class, resolver);
        List<NamedElement> toBeSelected = state.getElements(ElementGroup.SELECTION, NamedElement.class, resolver);
        if (!CollectionUtility.collectionsContainSameElements(currentlyExpandedElements, toBeExpanded)) {
            treeViewer.collapseAll();
            treeViewer.setExpandedElements(toBeExpanded.toArray());
        }
        if (!CollectionUtility.collectionsContainSameElements((Collection)currentlySelected.toList(), toBeSelected)) {
            StructuredSelection structuredSelection = new StructuredSelection(toBeSelected.toArray());
            treeViewer.setSelection((ISelection)structuredSelection);
        }
    }

    public static enum TreeOperation {
        COLLAPSE,
        EXPAND;

    }
}

