/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices.persistence;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public final class YamlFileReader {
    public Map<String, Object> read(TFile yamlFile) throws FileNotFoundException, IOException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (TFileReader reader = new TFileReader(yamlFile);){
            Yaml yaml = new Yaml();
            for (Object object : yaml.loadAll((Reader)reader)) {
                if (object == null) continue;
                map.putAll(this.createFlattenedMap(this.convertToMap(object)));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return map;
    }

    private Map<String, Object> convertToMap(Object object) {
        assert (object != null) : "Parameter 'object' of method 'convertToMap' must not be null";
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (entry.getValue() instanceof Map) {
                value = this.convertToMap(value);
            }
            if (entry.getKey() instanceof CharSequence) {
                result.put(entry.getKey().toString(), value);
                continue;
            }
            result.put("[" + entry.getKey().toString() + "]", value);
        }
        return result;
    }

    private Map<String, Object> createFlattenedMap(Map<String, Object> source) {
        assert (source != null) : "Parameter 'source' of method 'createFlattenedMap' must not be null";
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(result, source, null);
        return result;
    }

    private void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        assert (result != null) : "Parameter 'result' of method 'buildFlattenedMap' must not be null";
        assert (source != null) : "Parameter 'source' of method 'buildFlattenedMap' must not be null";
        for (Map.Entry<String, Object> nextEntry : source.entrySet()) {
            String key = nextEntry.getKey();
            Object value = nextEntry.getValue();
            if (path != null && path.trim().length() > 0) {
                key = key.startsWith("[") ? String.valueOf(path) + key : String.valueOf(path) + '.' + key;
            }
            if (value instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    result.put(key, "");
                    continue;
                }
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value : "");
        }
    }
}

