/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices.persistence;

import com.hello2morrow.sonargraph.plugin.spring.microservices.persistence.YamlFileReader;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public final class SpringBootConfigurationReader {
    public static final String BOOTSTRAP_CONFIG_FILE_NAME = "bootstrap";
    public static final String SERVLET_CONTEXT_PATH = "server.servlet.context-path";

    public static String loadConfigurationFromDirectory(TFile resourcesDir, String fileName, Map<String, Object> config) throws FileNotFoundException, IOException {
        TFile yaml = new TFile((File)resourcesDir, String.valueOf(fileName) + ".yml");
        TFile properties = new TFile((File)resourcesDir, String.valueOf(fileName) + ".properties");
        String info = "";
        if (yaml.exists()) {
            info = yaml.getName();
            config.putAll(new YamlFileReader().read(yaml));
        } else if (properties.exists()) {
            Properties configProperties = new Properties();
            Throwable throwable = null;
            Object var8_9 = null;
            try (TFileInputStream in = new TFileInputStream((File)properties);){
                info = properties.getName();
                configProperties.load((InputStream)in);
                configProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    Object object = config.put(k.toString(), v);
                }));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return info;
    }
}

