/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.api.IAggregatedDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.IDirectoryAccess;
import com.hello2morrow.sonargraph.api.IExternalAccess;
import com.hello2morrow.sonargraph.api.IModuleAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.ModelVisitor;
import com.hello2morrow.sonargraph.api.java.IAnnotationAccess;
import com.hello2morrow.sonargraph.api.java.IJavaModuleAccess;
import com.hello2morrow.sonargraph.api.java.IJavaTypeAccess;
import com.hello2morrow.sonargraph.api.java.JavaDependencyKind;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import com.hello2morrow.sonargraph.plugin.spring.microservices.c;
import com.hello2morrow.sonargraph.plugin.spring.microservices.e;
import com.hello2morrow.sonargraph.plugin.spring.microservices.model.ConfigServerConfigurations;
import com.hello2morrow.sonargraph.plugin.spring.microservices.model.SpringBootConfigurationProperties;
import com.hello2morrow.sonargraph.plugin.spring.microservices.model.SpringBootModule;
import com.hello2morrow.sonargraph.plugin.spring.microservices.persistence.ConfigurationServerProcessor;
import com.hello2morrow.sonargraph.plugin.spring.microservices.persistence.SpringBootConfigurationReader;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class d
extends e
implements c {
    private static final Logger h = LoggerFactory.getLogger(d.class);
    private static final String i = "Workspace:External [Java]:[Unknown]:org:springframework:boot:autoconfigure:SpringBootApplication:SpringBootApplication";
    private static final String j = "Workspace:External [Java]:[Unknown]:org:springframework:cloud:config:server:EnableConfigServer:EnableConfigServer";
    private static final String k = "Workspace:External [Java]:[Unknown]:org:springframework:cloud:client:discovery:EnableDiscoveryClient:EnableDiscoveryClient";
    private final Map<IJavaModuleAccess, SpringBootModule> l = new HashMap<IJavaModuleAccess, SpringBootModule>();

    d() {
    }

    public void a(IPluginContext context, IPluginJavaAccess javaAccess) {
        assert (context != null) : "Parameter 'context' of method 'detect' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'detect' must not be null";
        List<IJavaModuleAccess> springBootModules = this.b(context, javaAccess);
        h.info("Detected {} Spring Boot Modules", (Object)springBootModules.size());
        if (springBootModules.isEmpty()) {
            return;
        }
        a resourcesDirectoryDetector = new a(springBootModules);
        javaAccess.visitParserModel((ModelVisitor)resourcesDirectoryDetector);
        Map<IJavaModuleAccess, TFile> moduleToResourcesDir = resourcesDirectoryDetector.a();
        h.info("Detected {} resources directories", (Object)moduleToResourcesDir.size());
        for (IJavaModuleAccess next : springBootModules) {
            SpringBootModule springBoot = new SpringBootModule(next, moduleToResourcesDir.get(next));
            this.l.put(next, springBoot);
        }
        List<IJavaModuleAccess> configurationServerModules = this.b(context, javaAccess, springBootModules);
        h.info("Detected {} Config Server Modules", (Object)configurationServerModules.size());
        SpringBootModule configServerModule = null;
        if (configurationServerModules.size() > 1) {
            h.error("Only a single configuration server module expected, but found " + configurationServerModules.stream().map(m -> m.getName()).collect(Collectors.joining(", ")));
        } else if (configurationServerModules.size() == 1) {
            configServerModule = this.l.get(configurationServerModules.get(0));
            configServerModule.enableConfigServer();
        }
        List<IJavaModuleAccess> discoveryClients = this.a(context, javaAccess, springBootModules);
        for (IJavaModuleAccess next : discoveryClients) {
            SpringBootModule springBoot = this.l.get(next);
            if (springBoot.isConfigServer()) {
                h.error("Module " + springBoot.getName() + " cannot be a discovery client, because it is already marked as a config server.");
                continue;
            }
            springBoot.enableDiscoveryClient();
        }
        this.a(configServerModule, this.l.values());
    }

    Map<String, Object> b(IJavaModuleAccess module) {
        assert (module != null) : "Parameter 'module' of method 'getConfigurationForModule' must not be null";
        SpringBootModule springBoot = this.l.get(module);
        if (springBoot == null) {
            return Collections.emptyMap();
        }
        return springBoot.getConfiguration();
    }

    @Override
    public String a(IJavaModuleAccess module) {
        assert (module != null) : "Parameter 'module' of method 'getContextPath' must not be null";
        Map<String, Object> config = this.b(module);
        Object contextPath = config.get("server.servlet.context-path");
        return contextPath != null ? contextPath.toString() : "";
    }

    @Override
    public String a(IJavaModuleAccess module, String value) {
        assert (module != null) : "Parameter 'module' of method 'resolveVariables' must not be null";
        assert (value != null) : "Parameter 'value' of method 'resolveVariables' must not be null";
        if (value.trim().isEmpty()) {
            return value;
        }
        Map<String, Object> config = this.b(module);
        return SpringBootConfigurationProperties.resolveProperties(value, config);
    }

    private ConfigServerConfigurations a(SpringBootModule configServerModule, Collection<SpringBootModule> allSpringBootModules) {
        assert (allSpringBootModules != null && !allSpringBootModules.isEmpty()) : "Parameter 'allSpringBootModules' of method 'processConfigurations' must not be empty";
        ConfigServerConfigurations serverConfigurations = configServerModule != null ? this.a(configServerModule) : null;
        for (SpringBootModule next : allSpringBootModules) {
            if (next == configServerModule) continue;
            if (next.isDiscoveryClient()) {
                this.a(next, "bootstrap");
                if (serverConfigurations == null) continue;
                Map<String, Object> configuration = serverConfigurations.getMergedModuleConfiguration(next.getApplicationName());
                next.addConfigurationMap(configuration, "config server");
                continue;
            }
            this.a(next, "application");
        }
        return serverConfigurations;
    }

    private ConfigServerConfigurations a(SpringBootModule configServerModule) {
        assert (configServerModule != null) : "Parameter 'configServerModule' of method 'processConfigServerConfigurations' must not be null";
        if (configServerModule.getResourcesDir() == null) {
            h.error("No resources directory found for config server module {}", (Object)configServerModule.getName());
            return null;
        }
        this.a(configServerModule, "application");
        TFile resourcesDir = configServerModule.getResourcesDir();
        if (resourcesDir == null) {
            return null;
        }
        return new ConfigurationServerProcessor().processConfigurationFiles(resourcesDir, configServerModule.getConfiguration());
    }

    private void a(SpringBootModule module, String fileName) {
        assert (module != null) : "Parameter 'module' of method 'loadConfigurationForModule' must not be null";
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'loadConfigurationForModule' must not be empty";
        try {
            HashMap<String, Object> config = new HashMap<String, Object>();
            String info = SpringBootConfigurationReader.loadConfigurationFromDirectory(module.getResourcesDir(), fileName, config);
            if (!config.isEmpty()) {
                module.addConfigurationMap(config, info);
            }
        }
        catch (IOException e2) {
            h.error("Failed to process configuration for module {}", (Object)module.getName());
        }
    }

    private List<IJavaModuleAccess> a(IPluginContext context, IPluginJavaAccess javaAccess, List<IJavaModuleAccess> springBootModules) {
        assert (context != null) : "Parameter 'context' of method 'detectEnableDiscoveryClientModules' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'detectEnableDiscoveryClientModules' must not be null";
        assert (springBootModules != null && !springBootModules.isEmpty()) : "Parameter 'springBootModules' of method 'detectEnableDiscoveryClientModules' must not be empty";
        LinkedHashSet discoveryClientModules = new LinkedHashSet();
        this.a(context, javaAccess, k, type -> {
            IJavaModuleAccess module = (IJavaModuleAccess)type.getParent(IJavaModuleAccess.class);
            if (module != null) {
                if (!springBootModules.contains(module)) {
                    h.error("Type annotated with @EnableDiscoveryClient found in module " + module.getName() + ", but this is " + "not a SpringBoot module");
                } else {
                    discoveryClientModules.add(module);
                }
            }
        });
        return new ArrayList<IJavaModuleAccess>(discoveryClientModules);
    }

    private List<IJavaModuleAccess> b(IPluginContext context, IPluginJavaAccess javaAccess, List<IJavaModuleAccess> springBootModules) {
        assert (context != null) : "Parameter 'context' of method 'detectConfigurationServerModules' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'detectConfigurationServerModules' must not be null";
        assert (springBootModules != null && !springBootModules.isEmpty()) : "Parameter 'springBootModules' of method 'detectConfigurationServerModules' must not be empty";
        LinkedHashSet configServerModules = new LinkedHashSet();
        this.a(context, javaAccess, j, type -> {
            IJavaModuleAccess module = (IJavaModuleAccess)type.getParent(IJavaModuleAccess.class);
            if (module != null) {
                if (configServerModules.contains(module)) {
                    h.error("More than one type found annotated with @EnableConfigServer in module " + module.getName() + ".\n" + "Please check your workspace configuration!");
                } else if (!springBootModules.contains(module)) {
                    h.error("Type annotated with @EnableConfigServer found in module " + module.getName() + ", but this is " + "not a SpringBoot module");
                } else {
                    configServerModules.add(module);
                }
            }
        });
        return new ArrayList<IJavaModuleAccess>(configServerModules);
    }

    private List<IJavaModuleAccess> b(IPluginContext context, IPluginJavaAccess javaAccess) {
        assert (context != null) : "Parameter 'context' of method 'detectSpringBootModules' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'detectSpringBootModules' must not be null";
        LinkedHashSet springBootModules = new LinkedHashSet();
        this.a(context, javaAccess, i, type -> {
            IJavaModuleAccess module = (IJavaModuleAccess)type.getParent(IJavaModuleAccess.class);
            if (module != null) {
                if (springBootModules.contains(module)) {
                    h.error("More than one type found annotated with @SpringBootApplication in module " + module.getName() + ".\n" + "Please check your workspace configuration!");
                } else {
                    springBootModules.add(module);
                }
            }
        });
        return new ArrayList<IJavaModuleAccess>(springBootModules);
    }

    private void a(IPluginContext context, IPluginJavaAccess javaAccess, String annotation, Consumer<IJavaTypeAccess> consumer) {
        assert (context != null) : "Parameter 'context' of method 'detectAnnotatedTypes' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'detectAnnotatedTypes' must not be null";
        IJavaTypeAccess annotationType = (IJavaTypeAccess)javaAccess.findElementByFqn(annotation);
        if (annotationType == null) {
            return;
        }
        List annotatedElements = annotationType.getIncomingDependencies(Aggregator.ELEMENT, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
        for (IAggregatedDependencyAccess nextAnnotatedElement : annotatedElements) {
            IJavaTypeAccess type;
            List typeAnnotations;
            IAnnotationAccess annotationAccess;
            assert (nextAnnotatedElement.getNumberOfDependencies() == 1);
            if (context.hasBeenCanceled()) break;
            IDependencyAccess dep = (IDependencyAccess)nextAnnotatedElement.getDependencies().get(0);
            IProgrammingElementAccess programmingElement = dep.getFrom();
            if (!(programmingElement instanceof IJavaTypeAccess) || (annotationAccess = com.hello2morrow.sonargraph.plugin.spring.microservices.a.a((List<IAnnotationAccess>)(typeAnnotations = (type = (IJavaTypeAccess)programmingElement).getAnnotations()), annotation)) == null) continue;
            consumer.accept(type);
        }
    }

    private static final class a
    extends ModelVisitor {
        private final Map<IJavaModuleAccess, TFile> b = new LinkedHashMap<IJavaModuleAccess, TFile>();
        private IJavaModuleAccess c;
        private TFile d;
        private final Set<IJavaModuleAccess> e;

        public a(List<IJavaModuleAccess> springBootModules) {
            assert (springBootModules != null && !springBootModules.isEmpty()) : "Parameter 'springBootModules' of method 'ModuleResourcesDirectoryDetector' must not be empty";
            this.e = new HashSet<IJavaModuleAccess>(springBootModules);
        }

        public void visitNamedElementAccess(INamedElementAccess element) {
            if (element instanceof IModuleAccess) {
                if (element instanceof IJavaModuleAccess && this.e.contains(element)) {
                    this.c = (IJavaModuleAccess)element;
                    this.d = null;
                    super.visitNamedElementAccess(element);
                    if (this.d != null) {
                        this.b.put(this.c, this.d);
                        this.d = null;
                    }
                }
                return;
            }
            if (element instanceof IDirectoryAccess && this.d == null) {
                IDirectoryAccess dir = (IDirectoryAccess)element;
                this.d = this.a(dir);
                return;
            }
            if (!(element instanceof IExternalAccess) && this.c == null) {
                super.visitNamedElementAccess(element);
            }
        }

        public Map<IJavaModuleAccess, TFile> a() {
            return this.b;
        }

        private TFile a(IDirectoryAccess directory) {
            TFile resourcesDir;
            assert (directory != null) : "Parameter 'directory' of method 'findResourcesDir' must not be null";
            TFile main = directory.getFile().getParentFile();
            if (main.getName().endsWith("main") && (resourcesDir = new TFile((File)main, "resources")).exists() && resourcesDir.isDirectory()) {
                h.debug("Detected resources directory " + resourcesDir.getAbsolutePath());
                return resourcesDir;
            }
            return null;
        }
    }
}

