/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.issues.csv;

import com.hello2morrow.sonargraph.api.IModuleAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.IPluginMetricId;
import com.hello2morrow.sonargraph.api.ISourceFileAccess;
import com.hello2morrow.sonargraph.api.PluginIssueSeverity;
import com.hello2morrow.sonargraph.api.PluginIssueType;
import com.hello2morrow.sonargraph.api.PluginMetricCharacteristic;
import com.hello2morrow.sonargraph.api.PluginMetricLevel;
import com.hello2morrow.sonargraph.api.PluginMetricRange;
import com.hello2morrow.sonargraph.api.ResultSet;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import com.hello2morrow.sonargraph.plugin.issues.csv.b;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class a
extends SonargraphPlugin
implements IPluginAnalyzerContributor {
    public static final String a = "com.hello2morrow.sonargraph.plugin.issues.csv";
    private static final String c = "timestamps.txt";
    private static final Logger d = LoggerFactory.getLogger(a.class);
    private static final String e = "IssuesCsvError";
    private static final String f = "IssuesCsvWarning";
    private static final String g = "IssuesCsvInfo";
    private static final String h = "Issues csv error";
    private static final String i = "Issues csv warning";
    private static final String j = "Issues csv info";
    private final SonargraphStringPluginAttribute k;
    private final SonargraphStringPluginAttribute l;
    private final SonargraphStringPluginAttribute m;
    private final SonargraphStringPluginAttribute n;
    private IPluginMetricId o;
    private IPluginMetricId p;
    private IPluginMetricId q;
    private Map<IModuleAccess, Integer> r;
    private Map<IModuleAccess, Integer> s;
    private Map<IModuleAccess, Integer> t;
    private Map<ISourceFileAccess, Integer> u;
    private Map<ISourceFileAccess, Integer> v;
    private Map<ISourceFileAccess, Integer> w;
    private IPluginIssueId x;
    private IPluginIssueId y;
    private IPluginIssueId z;
    private final Map<String, Long> A = new HashMap<String, Long>();
    private static volatile /* synthetic */ int[] B;

    public a() {
        this.k = new SonargraphStringPluginAttribute("files", "Files", "Comma separated list of files containing the csv content (must be relative to Sonargraph system directory).)", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.k);
        this.l = new SonargraphStringPluginAttribute("errorRanges", "Error Ranges", "Comma separated list of integer based error ranges.", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.l);
        this.m = new SonargraphStringPluginAttribute("warningRanges", "Warning Ranges", "Comma separated list of integer based warning ranges.", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m);
        this.n = new SonargraphStringPluginAttribute("infoRanges", "Info Ranges", "Comma separated list of integer based info ranges.", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.n);
        d.debug("[" + this.getId() + "] Instantiated: " + this.getHexReference());
        SonargraphPluginManager.getInstance().addPlugin((SonargraphPlugin)this);
    }

    public String getId() {
        return a;
    }

    public String getVendor() {
        return "hello2morrow GmbH";
    }

    public String getVersion() {
        return "n/a";
    }

    public String getDescription() {
        return "Creates issues read from a file with csv content.";
    }

    public String getPresentationName() {
        return "Sonargraph Issue Importer Plugin";
    }

    public IPluginAnalyzerContributor getAnalyzerContributor() {
        return this;
    }

    private void a(File directory) {
        assert (directory != null && directory.isDirectory()) : "Parameter 'directory' of method 'writeTimestamps' must not be null";
        File input = new File(directory, c);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(input));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int lastSpacePos = line.lastIndexOf(32);
                    if (lastSpacePos < 0) {
                        throw new IOException("Invalid file format");
                    }
                    String path = line.substring(0, lastSpacePos);
                    try {
                        long timestamp = Long.valueOf(line.substring(lastSpacePos + 1));
                        this.A.put(path, timestamp);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Invalid file format");
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            d.error("Cannot read from " + input.getAbsolutePath(), (Throwable)e);
        }
    }

    private void b(File directory) {
        assert (directory != null && directory.isDirectory()) : "Parameter 'directory' of method 'writeTimestamps' must not be null";
        File output = new File(directory, c);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(output));){
                for (Map.Entry<String, Long> entry : this.A.entrySet()) {
                    writer.write(entry.getKey());
                    writer.write(" ");
                    writer.write(entry.getValue().toString());
                    writer.write(10);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            d.error("Cannot write to " + output.getAbsolutePath(), (Throwable)e);
        }
    }

    public boolean analyzerNeedsToRun(IPluginCoreAccess access) {
        assert (access != null) : "Parameter 'access' of method 'analyzerNeedsToRun' must not be null";
        if (this.A.isEmpty()) {
            this.a(access.getHiddenDataDirectory(this.getId()));
        }
        String files = this.k.getValue().trim();
        String[] filePaths = files.split(",");
        if (this.A.size() != filePaths.length) {
            return true;
        }
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String relName = stringArray[n2];
            File file = new File(access.getBaseDirectory(), relName.trim());
            Long ts = this.A.get(file.getAbsolutePath());
            if (ts == null || ts.longValue() != file.lastModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Set<String> getSupportedLanguages() {
        return null;
    }

    public void initialize(ISonargraphPluginContributor contributor) {
        assert (contributor != null) : "Parameter 'contributor' of method 'initialize' must not be null";
        d.debug("[" + this.getId() + "] Initialize: " + this.getHexReference());
        this.x = contributor.createIssueId(e, h, PluginIssueSeverity.ERROR, PluginIssueType.ELEMENT);
        this.y = contributor.createIssueId(f, i, PluginIssueSeverity.WARNING, PluginIssueType.ELEMENT);
        this.z = contributor.createIssueId(g, j, PluginIssueSeverity.INFO, PluginIssueType.ELEMENT);
        this.o = contributor.createMetricId("Imported Errors", "Number of imported issues with severity 'error'", false, PluginMetricRange.NULL_OR_POSITIVE, PluginMetricCharacteristic.HIGHER_WORSE, EnumSet.of(PluginMetricLevel.SYSTEM, PluginMetricLevel.MODULE, PluginMetricLevel.SOURCE));
        this.p = contributor.createMetricId("Imported Warnings", "Number of imported issues with severity 'warning'", false, PluginMetricRange.NULL_OR_POSITIVE, PluginMetricCharacteristic.HIGHER_WORSE, EnumSet.of(PluginMetricLevel.SYSTEM, PluginMetricLevel.MODULE, PluginMetricLevel.SOURCE));
        this.q = contributor.createMetricId("Imported Info Notes", "Number of imported issues with severity 'info'", false, PluginMetricRange.NULL_OR_POSITIVE, PluginMetricCharacteristic.HIGHER_WORSE, EnumSet.of(PluginMetricLevel.SYSTEM, PluginMetricLevel.MODULE, PluginMetricLevel.SOURCE));
        d.debug("[" + this.getId() + "] Initialize - done");
    }

    public void cleared(IPluginContext context) {
        d.debug("[" + this.getId() + "] Cleared");
    }

    public void analyze(IPluginContext context, ResultSet result) {
        assert (context != null) : "Parameter 'context' of method 'analyze' must not be null";
        assert (result != null) : "Parameter 'result' of method 'analyze' must not be null";
        d.info("[" + this.getId() + "] Analyze");
        long startTime = System.currentTimeMillis();
        IPluginCoreAccess coreAccess = context.getAccess(IPluginCoreAccess.class);
        assert (coreAccess != null) : "'coreAccess' of method 'analyze' must not be null";
        d.debug(String.valueOf(this.k.getName()) + ": " + this.k.getValue());
        d.debug(String.valueOf(this.l.getName()) + ": " + this.l.getValue());
        d.debug(String.valueOf(this.m.getName()) + ": " + this.m.getValue());
        d.debug(String.valueOf(this.n.getName()) + ": " + this.n.getValue());
        d.debug("Data directory: " + coreAccess.getHiddenDataDirectory(this.getId()));
        this.r = new HashMap<IModuleAccess, Integer>();
        this.s = new HashMap<IModuleAccess, Integer>();
        this.t = new HashMap<IModuleAccess, Integer>();
        this.u = new HashMap<ISourceFileAccess, Integer>();
        this.v = new HashMap<ISourceFileAccess, Integer>();
        this.w = new HashMap<ISourceFileAccess, Integer>();
        for (IModuleAccess module : coreAccess.getModules()) {
            this.r.put(module, 0);
            this.s.put(module, 0);
            this.t.put(module, 0);
        }
        HashMap<String, ISourceFileAccess> sourceMap = new HashMap<String, ISourceFileAccess>();
        String files = this.k.getValue().trim();
        String[] filePaths = files.split(",");
        if (filePaths.length == 0) {
            throw new IllegalArgumentException("At least 1 file must be specified");
        }
        b errorRanges = com.hello2morrow.sonargraph.plugin.issues.csv.b.a(this.l.getValue());
        b warningRanges = com.hello2morrow.sonargraph.plugin.issues.csv.b.a(this.m.getValue());
        b infoRanges = com.hello2morrow.sonargraph.plugin.issues.csv.b.a(this.n.getValue());
        if (errorRanges.a(warningRanges)) {
            throw new IllegalArgumentException(String.format("%s overlaps with %s: (%s)(%s)", this.l.getName(), this.m.getName(), errorRanges.toString(), warningRanges.toString()));
        }
        if (errorRanges.a(infoRanges)) {
            throw new IllegalArgumentException(String.format("%s overlaps with %s: (%s)(%s)", this.l.getName(), this.n.getName(), errorRanges.toString(), infoRanges.toString()));
        }
        if (warningRanges.a(infoRanges)) {
            throw new IllegalArgumentException(String.format("%s overlaps with %s: (%s)(%s)", this.m.getName(), this.n.getName(), warningRanges.toString(), infoRanges.toString()));
        }
        coreAccess.getComponents(false).stream().forEach(c -> c.getSources().forEach(src -> {
            ISourceFileAccess iSourceFileAccess = sourceMap.put(src.getFile().getNormalizedAbsolutePath(), (ISourceFileAccess)src);
        }));
        sourceMap.values().forEach(src -> {
            this.u.put((ISourceFileAccess)src, 0);
            this.v.put((ISourceFileAccess)src, 0);
            this.w.put((ISourceFileAccess)src, 0);
        });
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            String name = filePath.trim();
            if (name.isEmpty()) {
                throw new IllegalArgumentException("File name cannot be empty");
            }
            File file = new File(name);
            if (file.isAbsolute()) {
                throw new IllegalArgumentException("File names must be relative to the Sonargraph system base directory");
            }
            file = new File(coreAccess.getBaseDirectory(), name);
            if (!file.canRead()) {
                throw new IllegalArgumentException(String.format("Cannot read file '%s'", file.getPath()));
            }
            this.a(result, coreAccess, sourceMap, file, errorRanges, warningRanges, infoRanges);
            ++n2;
        }
        for (ISourceFileAccess src2 : sourceMap.values()) {
            result.addMetricValue((INamedElementAccess)src2, this.o, this.u.get(src2).intValue());
            result.addMetricValue((INamedElementAccess)src2, this.p, this.v.get(src2).intValue());
            result.addMetricValue((INamedElementAccess)src2, this.q, this.w.get(src2).intValue());
        }
        for (IModuleAccess module : coreAccess.getModules()) {
            result.addMetricValue((INamedElementAccess)module, this.o, this.r.get(module).intValue());
            result.addMetricValue((INamedElementAccess)module, this.p, this.s.get(module).intValue());
            result.addMetricValue((INamedElementAccess)module, this.q, this.t.get(module).intValue());
        }
        int totalErrors = this.r.values().stream().collect(Collectors.summingInt(Integer::intValue));
        int totalWarnings = this.s.values().stream().collect(Collectors.summingInt(Integer::intValue));
        int totalInfos = this.t.values().stream().collect(Collectors.summingInt(Integer::intValue));
        result.addMetricValue((INamedElementAccess)coreAccess, this.o, totalErrors);
        result.addMetricValue((INamedElementAccess)coreAccess, this.p, totalWarnings);
        result.addMetricValue((INamedElementAccess)coreAccess, this.q, totalInfos);
        this.b(coreAccess.getHiddenDataDirectory(this.getId()));
        long millis = System.currentTimeMillis() - startTime;
        d.info("[" + this.getId() + "] Analyze - done [" + (context.hasBeenCanceled() ? "canceled" : "finished") + " after " + millis / 1000L + " seconds]");
        this.r = null;
        this.s = null;
        this.t = null;
        this.u = null;
        this.v = null;
        this.w = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ResultSet result, IPluginCoreAccess coreAccess, Map<String, ISourceFileAccess> sourceMap, File file, b errorRanges, b warningRanges, b infoRanges) {
        this.A.put(file.getAbsolutePath(), file.lastModified());
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        return;
                    }
                    String[] values = line.split(";");
                    if (values.length != 5) continue;
                    try {
                        int lineNo = Integer.valueOf(values[0].trim());
                        int colNo = Integer.valueOf(values[1].trim());
                        File affectedFile = new File(values[2].trim());
                        int errorCode = Integer.valueOf(values[3].trim());
                        String msg = values[4].trim();
                        PluginIssueSeverity severity = null;
                        if (errorRanges.a(errorCode)) {
                            severity = PluginIssueSeverity.ERROR;
                        } else if (warningRanges.a(errorCode)) {
                            severity = PluginIssueSeverity.WARNING;
                        } else if (infoRanges.a(errorCode)) {
                            severity = PluginIssueSeverity.INFO;
                        }
                        if (!file.exists() || !file.isFile()) {
                            d.warn("File " + file.getPath() + " does not exist or is not a file");
                            continue;
                        }
                        if (severity == null) continue;
                        msg = String.format("[%d] %s", errorCode, msg);
                        this.a(result, coreAccess, sourceMap, affectedFile, lineNo, colNo, severity, msg);
                    }
                    catch (NumberFormatException e) {
                        d.warn("Cannot process input line (NumberFormatException): " + line);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            d.error("IOException whil reading " + file.getPath(), (Throwable)e);
        }
    }

    private void a(ResultSet result, IPluginCoreAccess coreAccess, Map<String, ISourceFileAccess> sourceMap, File affectedFile, int lineNo, int colNo, PluginIssueSeverity severity, String msg) {
        assert (coreAccess != null) : "Parameter 'coreAccess' of method 'createIssue' must not be null";
        assert (affectedFile != null) : "Parameter 'affectedFile' of method 'createIssue' must not be null";
        assert (severity != null) : "Parameter 'severity' of method 'createIssue' must not be null";
        assert (msg != null && msg.length() > 0) : "Parameter 'msg' of method 'createIssue' must not be empty";
        ISourceFileAccess src = sourceMap.get(affectedFile.getPath());
        if (src != null) {
            IPluginIssueId issueId = null;
            IModuleAccess module = (IModuleAccess)src.getParent(IModuleAccess.class);
            assert (module != null);
            switch (com.hello2morrow.sonargraph.plugin.issues.csv.a.a()[severity.ordinal()]) {
                case 3: {
                    issueId = this.x;
                    this.r.put(module, 1 + this.r.get(module));
                    this.u.put(src, 1 + this.u.get(src));
                    break;
                }
                case 2: {
                    issueId = this.y;
                    this.s.put(module, 1 + this.s.get(module));
                    this.v.put(src, 1 + this.v.get(src));
                    break;
                }
                case 1: {
                    issueId = this.z;
                    this.t.put(module, 1 + this.t.get(module));
                    this.w.put(src, 1 + this.w.get(src));
                }
            }
            if (colNo > 1) {
                msg = String.format("%s (column %d)", msg, colNo);
            }
            result.addElementIssue((INamedElementAccess)src, issueId, msg, lineNo, lineNo);
            assert (module != null);
        }
    }

    static /* synthetic */ int[] a() {
        if (B != null) {
            return B;
        }
        int[] nArray = new int[PluginIssueSeverity.values().length];
        try {
            nArray[PluginIssueSeverity.ERROR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PluginIssueSeverity.INFO.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PluginIssueSeverity.WARNING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        B = nArray;
        return nArray;
    }
}

