/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin;

import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SonargraphStringPluginAttribute
extends SonargraphPluginAttribute {
    private final Map<String, String> m_optionLabelToValue;
    private final String m_defaultValue;

    public SonargraphStringPluginAttribute(String name, String presentationName, String description, String group, String defaultValue) {
        super(name, presentationName, description, group);
        assert (defaultValue != null) : "Parameter 'defaultValue' of method 'SonargraphStringAttribute' must not be null";
        this.m_defaultValue = defaultValue;
        this.m_optionLabelToValue = Collections.emptyMap();
    }

    public SonargraphStringPluginAttribute(String name, String presentationName, String description, String group, String defaultValue, List<String> optionLabels, List<String> optionValues) {
        super(name, presentationName, description, group);
        assert (defaultValue != null) : "Parameter 'defaultValue' of method 'SonargraphStringPluginAttribute' must not be null";
        assert (optionLabels != null && !optionLabels.isEmpty()) : "Parameter 'optionLabels' of method 'SonargraphStringPluginAttribute' must not be empty";
        assert (optionValues != null && !optionValues.isEmpty()) : "Parameter 'optionValues' of method 'SonargraphStringPluginAttribute' must not be empty";
        assert (optionLabels.size() == optionValues.size()) : "Different sizes";
        assert (optionValues.contains(defaultValue)) : "Default value not found";
        assert (new HashSet<String>(optionLabels).size() == optionLabels.size()) : "Duplicate option label";
        assert (new HashSet<String>(optionValues).size() == optionValues.size()) : "Duplicate option value";
        this.m_defaultValue = defaultValue;
        this.m_optionLabelToValue = new LinkedHashMap<String, String>(optionLabels.size());
        int i = 0;
        while (i < optionLabels.size()) {
            this.m_optionLabelToValue.put(optionLabels.get(i), optionValues.get(i));
            ++i;
        }
    }

    @Override
    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    @Override
    public String getValue() {
        Object value = this.getConfiguration().getValue(this);
        assert (value != null && value instanceof String) : "Unexpected class in method 'getValue': " + value;
        return (String)value;
    }

    @Override
    public Map<String, Object> getOptionLabelToValue() {
        return Collections.unmodifiableMap(this.m_optionLabelToValue);
    }
}

