/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin;

import com.hello2morrow.sonargraph.api.AnyFactory;
import com.hello2morrow.sonargraph.api.CallToResourceMatcher;
import com.hello2morrow.sonargraph.api.ExternalWebResource;
import com.hello2morrow.sonargraph.api.IExternalAccess;
import com.hello2morrow.sonargraph.api.IGenericProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.IPluginLanguageBasedAccess;
import com.hello2morrow.sonargraph.api.WebProperty;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphPluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphPluginManager.class);
    private static SonargraphPluginManager s_instance;
    private final List<SonargraphPlugin> m_plugins = new ArrayList<SonargraphPlugin>();

    private SonargraphPluginManager() {
        s_instance = this;
        LOGGER.debug("[" + this + "] Instantiated");
    }

    public static SonargraphPluginManager getInstance() {
        if (s_instance == null) {
            s_instance = new SonargraphPluginManager();
        }
        return s_instance;
    }

    private SonargraphPlugin getPluginById(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'getPluginById' must not be empty";
        return this.m_plugins.stream().filter(plugin -> plugin.getId().equals(id)).findFirst().orElse(null);
    }

    public boolean isAvailable(String pluginId) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'isAvailable' must not be empty";
        return this.getPluginById(pluginId) != null;
    }

    public void addPlugin(SonargraphPlugin plugin) {
        assert (plugin != null) : "Parameter 'plugin' of method 'addPlugin' must not be null";
        LOGGER.debug("Add Sonargraph Plugin '" + plugin.getId() + "'");
        if (this.getPluginById(plugin.getId()) == null) {
            this.m_plugins.add(plugin);
        } else {
            LOGGER.error("Plugin '" + plugin.getId() + "' already added");
        }
    }

    public List<SonargraphPlugin> getPlugins() {
        return Collections.unmodifiableList(this.m_plugins);
    }

    public IGenericProgrammingElementAccess getOrCreateExternalResource(IPluginLanguageBasedAccess coreAccess, String pluginId, ExternalWebResource externalWebResourceMetaClass, String path, List<String> httpMethods) {
        assert (coreAccess != null) : "Parameter 'javaAccess' of method 'getOrCreateExternalResource' must not be null";
        assert (pluginId != null) : "Parameter 'pluginId' of method 'getOrCreateExternalResource' must not be null";
        assert (externalWebResourceMetaClass != null) : "Parameter 'externalWebResourceMetaClass' of method 'getOrCreateExternalResource' must not be null";
        assert (path != null) : "Parameter 'path' of method 'getOrCreateExternalResource' must not be null";
        assert (httpMethods != null && !httpMethods.isEmpty()) : "Parameter 'httpMethods' of method 'getOrCreateExternalResource' must not be empty";
        IExternalAccess externalRoot = coreAccess.getExternalRoot(coreAccess.getLanguageIdentifier(), pluginId);
        assert (externalRoot != null) : "ExternalRoot for plugin " + pluginId + ", language " + coreAccess.getLanguageIdentifier() + " must not be null";
        IGenericProgrammingElementAccess genericProgrammingElement = (IGenericProgrammingElementAccess)coreAccess.findFirstMatchingElement(externalRoot, e -> e.getShortName().equals(path));
        if (genericProgrammingElement == null) {
            genericProgrammingElement = coreAccess.createProgrammingElementComponent(externalRoot, externalWebResourceMetaClass, path, -1);
            genericProgrammingElement.setProperty(WebProperty.HTTP_METHOD.getStandardName(), AnyFactory.createFrom(httpMethods));
            genericProgrammingElement.setProperty(WebProperty.PATH_TO_MATCH.getStandardName(), AnyFactory.createFrom(CallToResourceMatcher.removeVariablesFromPath(path)));
        }
        return genericProgrammingElement;
    }
}

