/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin;

import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SonargraphIntPluginAttribute
extends SonargraphPluginAttribute {
    private final Map<String, Integer> m_optionLabelToValue;
    private final int m_defaultValue;

    public SonargraphIntPluginAttribute(String name, String presentationName, String description, String group, int defaultValue) {
        super(name, presentationName, description, group);
        this.m_defaultValue = defaultValue;
        this.m_optionLabelToValue = Collections.emptyMap();
    }

    public SonargraphIntPluginAttribute(String name, String presentationName, String description, String group, int defaultValue, List<String> optionLabels, List<Integer> optionValues) {
        super(name, presentationName, description, group);
        assert (optionLabels != null && !optionLabels.isEmpty()) : "Parameter 'optionLabels' of method 'SonargraphIntPluginAttribute' must not be empty";
        assert (optionValues != null && !optionValues.isEmpty()) : "Parameter 'optionValues' of method 'SonargraphIntPluginAttribute' must not be empty";
        assert (optionLabels.size() == optionValues.size()) : "Different sizes";
        assert (optionValues.contains(defaultValue)) : "Default value not found";
        assert (new HashSet<String>(optionLabels).size() == optionLabels.size()) : "Duplicate option label";
        assert (new HashSet<Integer>(optionValues).size() == optionValues.size()) : "Duplicate option value";
        this.m_defaultValue = defaultValue;
        this.m_optionLabelToValue = new LinkedHashMap<String, Integer>(optionLabels.size());
        int i = 0;
        while (i < optionLabels.size()) {
            this.m_optionLabelToValue.put(optionLabels.get(i), optionValues.get(i));
            ++i;
        }
    }

    @Override
    public Integer getDefaultValue() {
        return this.m_defaultValue;
    }

    @Override
    public Integer getValue() {
        Object value = this.getConfiguration().getValue(this);
        assert (value != null && value instanceof Integer) : "Unexpected class in method 'getValue': " + value;
        return (Integer)value;
    }

    @Override
    public Map<String, Object> getOptionLabelToValue() {
        return Collections.unmodifiableMap(this.m_optionLabelToValue);
    }
}

