/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings;

import com.hello2morrow.foundation.utilities.CustomPattern;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaResourceProviderAdapter;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.b;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.IgnoreFieldAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.IgnoreJavaElementAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.IgnoreMethodAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.IgnoreTypeAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaUserDefinedIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings.ObjectFactory;
import com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings.XsdIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings.XsdIgnoreAccessConfiguration;
import com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings.XsdIgnoreFieldAccess;
import com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings.XsdIgnoreMethodAccess;
import com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings.XsdIgnoreTypeAccess;
import com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings.XsdSoftwareSystemSettings;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;

public final class JavaSoftwareSystemSettingsPersistence {
    private static final String XSD_PACKAGE_NAME = "com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings";
    private static final String SCHEMA_URL = "com/hello2morrow/sonargraph/languageprovider/java/persistence/system/settings/javaSoftwareSystemSettings";
    private final Version m_version;
    private final XmlPersistenceContext m_persistenceContext;

    public JavaSoftwareSystemSettingsPersistence(Version version) {
        assert (version != null) : "Parameter 'version' of method 'JavaSoftwareSystemSettingsPersistence' must not be null";
        this.m_version = version;
        this.m_persistenceContext = new XmlPersistenceContext(XSD_PACKAGE_NAME, JavaResourceProviderAdapter.a().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
    }

    private JaxbAdapter<JAXBElement<XsdSoftwareSystemSettings>> createJaxbAdapter() {
        ClassLoader classLoader = ObjectFactory.class.getClassLoader();
        return JaxbAccess.createJaxbAdapter((ClassLoader)classLoader, (XmlPersistenceContext)this.m_persistenceContext);
    }

    public OperationResult load(TFile file, NamedElement parent) {
        assert (file != null) : "Parameter 'file' of method 'load' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'load' must not be null";
        OperationResult result = new OperationResult("Load Java system settings file '" + file.getName() + "'");
        if (!file.exists() || !file.canRead()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, String.format("Cannot read Java system settings file '%s'", file.getNormalizedAbsolutePath()), new Object[0]);
            return result;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileInputStream in = new TFileInputStream((File)file);){
                OperationResult loadResult = this.load((InputStream)in, parent);
                result.addMessagesFrom(loadResult);
                if (result.isFailure()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, String.format("Failed to process Java system settings file '%s'", file.getNormalizedAbsolutePath()), new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, String.format("Cannot read Java system settings file '%s'", file.getNormalizedAbsolutePath()), new Object[]{e2});
        }
        return result;
    }

    private boolean isCustomPatternValid(String kind, String pattern, OperationResult result) {
        assert (kind != null && kind.length() > 0) : "Parameter 'kind' of method 'isCustomPatternValid' must not be empty";
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'isCustomPatternValid' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'isCustomPatternValid' must not be null";
        try {
            CustomPattern.compileWildcardPattern((String)pattern, (boolean)false);
            return true;
        }
        catch (IllegalArgumentException e2) {
            result.addWarning((OperationResult.IMessageCause)MessageCause.INVALID_IGNORE_ACCESS_PATTERN, "Ignore " + kind + " access not valid '" + pattern + "'.", new Object[0]);
            return false;
        }
    }

    private boolean isFullyQualifiedNameValid(String kind, String pattern, OperationResult result) {
        assert (kind != null && kind.length() > 0) : "Parameter 'kind' of method 'isFullyQualifiedNameValid' must not be empty";
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'isFullyQualifiedNameValid' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'isFullyQualifiedNameValid' must not be null";
        if (!b.a(pattern, Collections.emptySet())) {
            result.addWarning((OperationResult.IMessageCause)MessageCause.INVALID_IGNORE_ACCESS_PATTERN, "Ignore " + kind + " access not valid '" + pattern + "'.", new Object[0]);
            return false;
        }
        return true;
    }

    private final boolean isPatternValid(String kind, String pattern, Set<String> patternsProvided, OperationResult result) {
        assert (kind != null && kind.length() > 0) : "Parameter 'kind' of method 'isPatternValid' must not be empty";
        assert (patternsProvided != null) : "Parameter 'patternsProvided' of method 'isPatternValid' must not be null";
        assert (result != null) : "Parameter 'result' of method 'isPatternValid' must not be null";
        if (pattern == null || pattern.isEmpty()) {
            result.addWarning((OperationResult.IMessageCause)MessageCause.INVALID_IGNORE_ACCESS_PATTERN, "Ignored empty ignore " + kind + " access.", new Object[0]);
            return false;
        }
        if (!patternsProvided.add(pattern)) {
            result.addWarning((OperationResult.IMessageCause)MessageCause.DUPLICATE_IGNORE_ACCESS_PATTERN, "Ignored duplicate ignore " + kind + " access '" + pattern + "'.", new Object[0]);
            return false;
        }
        return true;
    }

    private OperationResult load(InputStream in, NamedElement parent) {
        assert (in != null) : "Parameter 'in' of method 'load' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'load' must not be null";
        OperationResultWithOutcome<XsdSoftwareSystemSettings> result = this.loadFromStream(in);
        if (result.isSuccess()) {
            XsdSoftwareSystemSettings xsdSoftwareSystemSettings = (XsdSoftwareSystemSettings)result.getOutcome();
            assert (xsdSoftwareSystemSettings != null) : "'xsdSoftwareSystemSettings' of method 'load' must not be null";
            XsdIgnoreAccessConfiguration xsdIgnoreAccessConfiguration = xsdSoftwareSystemSettings.getIgnoreAccess();
            if (xsdIgnoreAccessConfiguration != null) {
                String nextPattern;
                JavaUserDefinedIgnoreAccess ignoreAccess = new JavaUserDefinedIgnoreAccess(parent);
                parent.addChild((NamedElement)ignoreAccess);
                THashSet patternsProvided = new THashSet();
                for (XsdIgnoreTypeAccess xsdIgnoreTypeAccess : xsdIgnoreAccessConfiguration.getType()) {
                    nextPattern = xsdIgnoreTypeAccess.getName();
                    if (!this.isPatternValid("type", nextPattern, (Set<String>)patternsProvided, (OperationResult)result) || (CustomPattern.containsWildcardPatternCharacter((String)nextPattern) ? !this.isCustomPatternValid("type", nextPattern, (OperationResult)result) : !this.isFullyQualifiedNameValid("type", nextPattern, (OperationResult)result))) continue;
                    ignoreAccess.addChild(new IgnoreTypeAccess((NamedElement)ignoreAccess, null, null, nextPattern));
                }
                patternsProvided.clear();
                for (XsdIgnoreMethodAccess xsdIgnoreMethodAccess : xsdIgnoreAccessConfiguration.getMethod()) {
                    nextPattern = xsdIgnoreMethodAccess.getName();
                    if (!this.isPatternValid("method", nextPattern, (Set<String>)patternsProvided, (OperationResult)result) || (CustomPattern.containsWildcardPatternCharacter((String)nextPattern) ? !this.isCustomPatternValid("type", nextPattern, (OperationResult)result) : !this.isFullyQualifiedNameValid("method", nextPattern, (OperationResult)result))) continue;
                    ignoreAccess.addChild(new IgnoreMethodAccess((NamedElement)ignoreAccess, null, null, null, nextPattern));
                }
                patternsProvided.clear();
                for (XsdIgnoreFieldAccess xsdIgnoreFieldAccess : xsdIgnoreAccessConfiguration.getField()) {
                    nextPattern = xsdIgnoreFieldAccess.getName();
                    if (!this.isPatternValid("field", nextPattern, (Set<String>)patternsProvided, (OperationResult)result) || (CustomPattern.containsWildcardPatternCharacter((String)nextPattern) ? !this.isCustomPatternValid("type", nextPattern, (OperationResult)result) : !this.isFullyQualifiedNameValid("field", nextPattern, (OperationResult)result))) continue;
                    ignoreAccess.addChild(new IgnoreFieldAccess((NamedElement)ignoreAccess, null, null, null, nextPattern));
                }
            }
        }
        return result;
    }

    private OperationResultWithOutcome<XsdSoftwareSystemSettings> loadFromStream(InputStream inputStream) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'internLoadFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading Java system settings from stream");
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl((OperationResult)result);
        JAXBElement element = (JAXBElement)this.createJaxbAdapter().load(inputStream, (ValidationEventHandler)eventHandler);
        if (result.isFailure()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Java system settings loaded from stream is corrupt", new Object[0]);
            return result;
        }
        result.setOutcome((Object)((XsdSoftwareSystemSettings)element.getValue()));
        return result;
    }

    public OperationResult save(NamedElement parent, TFile file) {
        assert (parent != null) : "Parameter 'parent' of method 'save' must not be null";
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        OperationResult result = new OperationResult("Save Java system settings to file '" + file.getNormalizedAbsolutePath() + "'");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileOutputStream out = new TFileOutputStream((File)file);){
                OperationResult save = this.save(parent, (OutputStream)out);
                result.addMessagesFrom(save);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, String.format("Failed to save Java system settings to file '%s'", file.getNormalizedAbsolutePath()), new Object[]{e2});
            return result;
        }
    }

    private JAXBElement<XsdSoftwareSystemSettings> convertPojoToXml(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'convertPojoToXml' must not be null";
        ObjectFactory xsdObjectFactory = new ObjectFactory();
        XsdSoftwareSystemSettings xsdSoftwareSystemSettings = xsdObjectFactory.createXsdSoftwareSystemSettings();
        xsdSoftwareSystemSettings.setVersion(this.m_version.toString());
        XsdIgnoreAccessConfiguration xsdIgnoreAccessConfiguration = xsdObjectFactory.createXsdIgnoreAccessConfiguration();
        xsdSoftwareSystemSettings.setIgnoreAccess(xsdIgnoreAccessConfiguration);
        JavaIgnoreAccess ignoreAccess = (JavaIgnoreAccess)((Object)parent.getUniqueChild(JavaIgnoreAccess.class));
        if (ignoreAccess != null) {
            XsdIgnoreAccess nextXsd;
            for (IgnoreJavaElementAccess next : ignoreAccess.getChildren(IgnoreTypeAccess.class)) {
                nextXsd = xsdObjectFactory.createXsdIgnoreTypeAccess();
                nextXsd.setName(next.getShortName());
                xsdIgnoreAccessConfiguration.getType().add((XsdIgnoreTypeAccess)nextXsd);
            }
            for (IgnoreJavaElementAccess next : ignoreAccess.getChildren(IgnoreMethodAccess.class)) {
                nextXsd = xsdObjectFactory.createXsdIgnoreMethodAccess();
                nextXsd.setName(next.getShortName());
                xsdIgnoreAccessConfiguration.getMethod().add((XsdIgnoreMethodAccess)nextXsd);
            }
            for (IgnoreJavaElementAccess next : ignoreAccess.getChildren(IgnoreFieldAccess.class)) {
                nextXsd = xsdObjectFactory.createXsdIgnoreFieldAccess();
                nextXsd.setName(next.getShortName());
                xsdIgnoreAccessConfiguration.getField().add((XsdIgnoreFieldAccess)nextXsd);
            }
        }
        return xsdObjectFactory.createSystemSettings(xsdSoftwareSystemSettings);
    }

    private final OperationResult save(NamedElement parent, OutputStream out) {
        assert (parent != null) : "Parameter 'parent' of method 'save' must not be null";
        assert (out != null) : "Parameter 'out' of method 'save' must not be null";
        OperationResult result = new OperationResult("Saving Java system settings to stream");
        JAXBElement<XsdSoftwareSystemSettings> element = this.convertPojoToXml(parent);
        if (element == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Failed to convert Java system settings to XML.", new Object[0]);
            return result;
        }
        try {
            this.createJaxbAdapter().save(element, out);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
        return result;
    }

    private static enum MessageCause implements OperationResult.IMessageCause
    {
        INVALID_IGNORE_ACCESS_PATTERN,
        DUPLICATE_IGNORE_ACCESS_PATTERN;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

