/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming;

import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.b;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaSignatureWriter;
import org.objectweb.asm.signature.SignatureVisitor;

final class JavaMethodSignatureWriter
extends JavaSignatureWriter {
    private final StringBuilder m_formalTypeParameters = new StringBuilder();
    private final StringBuilder m_parameterList = new StringBuilder();
    private final StringBuilder m_returnType;
    private final StringBuilder m_exceptions;
    private final boolean m_includeReturnType;
    private final boolean m_includeExceptions;
    private Section m_section = Section.NONE;
    private boolean m_signatureOfClassInterfaceVisitEnded;
    private int m_openedAngleBracketsSection;

    JavaMethodSignatureWriter(boolean includeReturnType, boolean includeExceptions) {
        this.m_includeReturnType = includeReturnType;
        this.m_includeExceptions = includeExceptions;
        this.m_returnType = this.m_includeReturnType ? new StringBuilder() : null;
        this.m_exceptions = this.m_includeExceptions ? new StringBuilder() : null;
    }

    private SignatureVisitor handleTypeBound() {
        switch (this.m_section) {
            case NONE: {
                assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
                break;
            }
            case FORMAL_TYPE_PARAMETERS: {
                this.m_formalTypeParameters.append(" extends ");
                break;
            }
            case PARAMETER_LIST: {
                this.m_parameterList.append(" extends ");
                break;
            }
            case RETURN_TYPE: {
                if (!this.m_includeReturnType) break;
                this.m_returnType.append(" extends ");
                break;
            }
            case EXCEPTIONS: {
                if (!this.m_includeExceptions) break;
                this.m_exceptions.append(" extends ");
                break;
            }
            default: {
                assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                break;
            }
        }
        return this;
    }

    public SignatureVisitor visitClassBound() {
        return this.handleTypeBound();
    }

    public SignatureVisitor visitInterfaceBound() {
        return this.handleTypeBound();
    }

    public SignatureVisitor visitSuperclass() {
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public void visitFormalTypeParameter(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'visitFormalTypeParameter' must not be empty";
        switch (this.m_section) {
            case NONE: {
                this.m_formalTypeParameters.append("<").append(name);
                this.m_section = Section.FORMAL_TYPE_PARAMETERS;
                ++this.m_openedAngleBracketsSection;
                break;
            }
            case FORMAL_TYPE_PARAMETERS: {
                this.m_formalTypeParameters.append(", ").append(name);
                break;
            }
            case PARAMETER_LIST: 
            case RETURN_TYPE: 
            case EXCEPTIONS: {
                assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
            }
            default: {
                assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                break;
            }
        }
        this.m_signatureOfClassInterfaceVisitEnded = false;
    }

    private void closeAngleBrackets(StringBuilder builder, boolean all) {
        assert (builder != null) : "Parameter 'builder' of method 'closeAngleBrackets' must not be null";
        if (all) {
            int i2 = 0;
            while (i2 < this.m_openedAngleBracketsSection) {
                builder.append(">");
                ++i2;
            }
            this.m_openedAngleBracketsSection = 0;
        } else if (this.m_openedAngleBracketsSection > 0) {
            builder.append(">");
            --this.m_openedAngleBracketsSection;
        }
    }

    public SignatureVisitor visitParameterType() {
        switch (this.m_section) {
            case NONE: {
                this.m_section = Section.PARAMETER_LIST;
                this.m_parameterList.append('(');
                break;
            }
            case FORMAL_TYPE_PARAMETERS: {
                this.closeAngleBrackets(this.m_formalTypeParameters, true);
                this.m_section = Section.PARAMETER_LIST;
                this.m_parameterList.append('(');
                break;
            }
            case PARAMETER_LIST: {
                this.closeAngleBrackets(this.m_parameterList, false);
                this.m_parameterList.append(", ");
                break;
            }
            case RETURN_TYPE: 
            case EXCEPTIONS: {
                assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
            }
            default: {
                assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                break;
            }
        }
        this.m_signatureOfClassInterfaceVisitEnded = false;
        return this;
    }

    public SignatureVisitor visitReturnType() {
        switch (this.m_section) {
            case NONE: {
                this.m_section = Section.RETURN_TYPE;
                break;
            }
            case FORMAL_TYPE_PARAMETERS: {
                this.closeAngleBrackets(this.m_formalTypeParameters, true);
                this.m_section = Section.RETURN_TYPE;
                break;
            }
            case PARAMETER_LIST: {
                this.closeAngleBrackets(this.m_parameterList, true);
                this.m_parameterList.append(')');
                this.m_section = Section.RETURN_TYPE;
                break;
            }
            case RETURN_TYPE: 
            case EXCEPTIONS: {
                assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
                break;
            }
            default: {
                assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                break;
            }
        }
        this.m_signatureOfClassInterfaceVisitEnded = false;
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        switch (this.m_section) {
            case NONE: {
                assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
                break;
            }
            case FORMAL_TYPE_PARAMETERS: {
                this.closeAngleBrackets(this.m_formalTypeParameters, true);
                this.m_section = Section.EXCEPTIONS;
                break;
            }
            case PARAMETER_LIST: {
                this.closeAngleBrackets(this.m_parameterList, true);
                this.m_parameterList.append(')');
                this.m_section = Section.EXCEPTIONS;
                break;
            }
            case RETURN_TYPE: {
                if (this.m_includeReturnType) {
                    this.closeAngleBrackets(this.m_returnType, true);
                }
                this.m_section = Section.EXCEPTIONS;
                break;
            }
            case EXCEPTIONS: {
                if (!this.m_includeExceptions) break;
                this.closeAngleBrackets(this.m_exceptions, false);
                this.m_exceptions.append(", ");
                break;
            }
            default: {
                assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                break;
            }
        }
        return this;
    }

    public void visitBaseType(char descriptor) {
        switch (this.m_section) {
            case NONE: {
                assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
                break;
            }
            case FORMAL_TYPE_PARAMETERS: {
                super.handleBaseType(descriptor, this.m_formalTypeParameters);
                break;
            }
            case PARAMETER_LIST: {
                super.handleBaseType(descriptor, this.m_parameterList);
                break;
            }
            case RETURN_TYPE: {
                if (!this.m_includeReturnType) break;
                super.handleBaseType(descriptor, this.m_returnType);
                break;
            }
            case EXCEPTIONS: {
                if (!this.m_includeExceptions) break;
                super.handleBaseType(descriptor, this.m_exceptions);
                break;
            }
            default: {
                assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                break;
            }
        }
    }

    public void visitTypeVariable(String name) {
        switch (this.m_section) {
            case NONE: {
                assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
                break;
            }
            case FORMAL_TYPE_PARAMETERS: {
                this.m_formalTypeParameters.append(name);
                break;
            }
            case PARAMETER_LIST: {
                this.m_parameterList.append(name);
                break;
            }
            case RETURN_TYPE: {
                if (!this.m_includeReturnType) break;
                this.m_returnType.append(name);
                break;
            }
            case EXCEPTIONS: {
                if (!this.m_includeExceptions) break;
                this.m_exceptions.append(name);
                break;
            }
            default: {
                assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                break;
            }
        }
    }

    public SignatureVisitor visitArrayType() {
        return this;
    }

    private void handleClassType(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'handleClassType' must not be empty";
        String add = b.d(name.replace('/', '.'));
        switch (this.m_section) {
            case NONE: {
                assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
                break;
            }
            case FORMAL_TYPE_PARAMETERS: {
                this.m_formalTypeParameters.append(add);
                break;
            }
            case PARAMETER_LIST: {
                this.m_parameterList.append(add);
                break;
            }
            case RETURN_TYPE: {
                if (!this.m_includeReturnType) break;
                this.m_returnType.append(add);
                break;
            }
            case EXCEPTIONS: {
                if (!this.m_includeExceptions) break;
                this.m_exceptions.append(add);
                break;
            }
            default: {
                assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                break;
            }
        }
    }

    public void visitClassType(String name) {
        this.handleClassType(name);
    }

    public void visitInnerClassType(String name) {
        this.handleClassType(name);
    }

    public void visitTypeArgument() {
    }

    public SignatureVisitor visitTypeArgument(char tag) {
        String add;
        if (this.m_signatureOfClassInterfaceVisitEnded) {
            switch (tag) {
                case '=': {
                    add = ", ";
                    break;
                }
                case '+': {
                    add = ", ? extends ";
                    break;
                }
                case '-': {
                    add = ", ? super ";
                    break;
                }
                default: {
                    assert (false) : "Unhandled tag: " + tag;
                    add = "";
                    break;
                }
            }
        } else {
            switch (tag) {
                case '=': {
                    add = "<";
                    break;
                }
                case '+': {
                    add = "<? extends ";
                    break;
                }
                case '-': {
                    add = "<? super ";
                    break;
                }
                default: {
                    assert (false) : "Unhandled tag: " + tag;
                    add = "";
                }
            }
            ++this.m_openedAngleBracketsSection;
        }
        switch (this.m_section) {
            case NONE: {
                assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
                break;
            }
            case FORMAL_TYPE_PARAMETERS: {
                this.m_formalTypeParameters.append(add);
                break;
            }
            case PARAMETER_LIST: {
                this.m_parameterList.append(add);
                break;
            }
            case RETURN_TYPE: {
                if (!this.m_includeReturnType) break;
                this.m_returnType.append(add);
                break;
            }
            case EXCEPTIONS: {
                if (!this.m_includeExceptions) break;
                this.m_exceptions.append(add);
                break;
            }
            default: {
                assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                break;
            }
        }
        this.m_signatureOfClassInterfaceVisitEnded = false;
        return this;
    }

    public void visitEnd() {
        if (this.m_signatureOfClassInterfaceVisitEnded) {
            if (this.m_openedAngleBracketsSection > 0) {
                switch (this.m_section) {
                    case NONE: {
                        assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
                        break;
                    }
                    case FORMAL_TYPE_PARAMETERS: {
                        this.closeAngleBrackets(this.m_formalTypeParameters, false);
                        break;
                    }
                    case PARAMETER_LIST: {
                        this.closeAngleBrackets(this.m_parameterList, false);
                        break;
                    }
                    case RETURN_TYPE: {
                        if (!this.m_includeReturnType) break;
                        this.closeAngleBrackets(this.m_returnType, false);
                        break;
                    }
                    case EXCEPTIONS: {
                        if (!this.m_includeExceptions) break;
                        this.closeAngleBrackets(this.m_exceptions, false);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                        break;
                    }
                }
            }
            this.m_signatureOfClassInterfaceVisitEnded = false;
        } else {
            this.m_signatureOfClassInterfaceVisitEnded = true;
        }
    }

    public String getResult() {
        if (this.m_section != Section.NONE) {
            switch (this.m_section) {
                case NONE: {
                    assert (false) : "Unexpected section: " + (Object)((Object)this.m_section);
                    break;
                }
                case FORMAL_TYPE_PARAMETERS: {
                    this.closeAngleBrackets(this.m_formalTypeParameters, true);
                    break;
                }
                case PARAMETER_LIST: {
                    this.closeAngleBrackets(this.m_parameterList, true);
                    break;
                }
                case RETURN_TYPE: {
                    if (!this.m_includeReturnType) break;
                    this.closeAngleBrackets(this.m_returnType, true);
                    break;
                }
                case EXCEPTIONS: {
                    if (!this.m_includeExceptions) break;
                    this.closeAngleBrackets(this.m_exceptions, true);
                    break;
                }
                default: {
                    assert (false) : "Unhandled section: " + (Object)((Object)this.m_section);
                    break;
                }
            }
            this.m_section = Section.NONE;
        }
        return String.valueOf(this.m_parameterList.length() == 0 ? "()" : this.m_parameterList.toString()) + (this.m_formalTypeParameters.length() == 0 ? "" : " " + this.m_formalTypeParameters.toString()) + (this.m_returnType == null || this.m_returnType.length() == 0 ? "" : " : " + this.m_returnType.toString()) + (this.m_exceptions == null || this.m_exceptions.length() == 0 ? "" : " throws " + this.m_returnType.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Parameter list: '").append((CharSequence)this.m_parameterList).append("'").append("\n");
        builder.append("Formal type parameters: '").append((CharSequence)this.m_formalTypeParameters).append("'");
        if (this.m_returnType != null) {
            builder.append("\n");
            builder.append("Return type: '").append((CharSequence)this.m_returnType).append("'");
        }
        if (this.m_exceptions != null) {
            builder.append("\n");
            builder.append("Exceptions: '").append((CharSequence)this.m_exceptions).append("'");
        }
        return builder.toString();
    }

    static enum Section {
        NONE,
        FORMAL_TYPE_PARAMETERS,
        PARAMETER_LIST,
        RETURN_TYPE,
        EXCEPTIONS;

    }
}

