/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming;

import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.a;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaStructureItem;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;

public abstract class JavaCompilationUnit
extends SourceFile
implements IComponent {
    private IModelServiceProvider m_msp;
    private boolean m_isExcluded;
    private boolean m_ignoreIssues;

    public JavaCompilationUnit(NamedElement parent) {
        super(parent);
    }

    public JavaCompilationUnit(IModelServiceProvider msp, NamedElement parent, String path) {
        super(parent, path);
        assert (msp != null) : "Parameter 'msp' of method 'JavaCompilationUnit' must not be null";
        this.m_msp = msp;
    }

    public final Language getLanguage() {
        return a.a;
    }

    protected final IModelServiceProvider getModelServiceProvider() {
        return this.m_msp;
    }

    public final void setModelServiceProvider(IModelServiceProvider msp) {
        assert (msp != null) : "Parameter 'msp' of method 'setModelServiceProvider' must not be null";
        this.m_msp = msp;
    }

    public final Element.IPropertiesManager getPropertiesManager() {
        return this.m_msp.getPropertiesManager();
    }

    public final ElementWithIssues.IIssueManager getIssueManager() {
        return this.m_msp.getIssueManager();
    }

    public final IVirtualModel getCurrentModel() {
        return this.m_msp.getCurrentModel();
    }

    public final IFileType getFileType() {
        TFile file = this.getFile();
        if (file != null) {
            JavaFileType fileType = JavaFileType.determine(file.getName());
            assert (fileType != null) : "'fileType' of method 'getFileType' must not be null";
            assert (fileType != JavaFileType.CLASS_FILE) : "Not a source file type: " + file.getAbsolutePath();
            return fileType;
        }
        return JavaFileType.JAVA_FILE;
    }

    public final String getImageResourceName() {
        TFile file = this.getFile();
        if (file != null) {
            JavaFileType fileType = JavaFileType.determine(file.getName());
            assert (fileType != null) : "'fileType' of method 'getImageResourceName' must not be null";
            switch (fileType) {
                case JAVA_FILE: {
                    return "JavaCompilationUnit";
                }
                case GROOVY_FILE: {
                    return "GroovyCompilationUnit";
                }
                case KOTLIN_FILE: {
                    return "KotlinCompilationUnit";
                }
                case ASPECTJ_FILE: {
                    return "AspectJCompilationUnit";
                }
                case SCALA_FILE: {
                    return "ScalaCompilationUnit";
                }
                case CLASS_FILE: {
                    assert (false) : "Not a source file type: " + file.getAbsolutePath();
                    break;
                }
                default: {
                    assert (false) : "Unhandled file type: " + (Object)((Object)fileType);
                    break;
                }
            }
        }
        return "JavaCompilationUnit";
    }

    public void setIsExcluded(boolean excluded) {
        this.m_isExcluded = excluded;
    }

    @Property
    public final boolean isExcluded() {
        return this.m_isExcluded;
    }

    public final void setIgnoreIssues(boolean ignore) {
        this.m_ignoreIssues = ignore;
    }

    @Property
    public final boolean ignoreIssues() {
        return this.m_ignoreIssues;
    }

    public final boolean isArtificial() {
        return true;
    }

    public final void rebase() {
    }

    public String getAbsolutePath() {
        TFile file = this.getFile();
        return file != null ? file.getAbsolutePath() : null;
    }

    public final boolean exists() {
        TFile file = this.getFile();
        return file != null ? file.exists() : false;
    }

    public final NamedElement getNamedElement() {
        return this;
    }

    public final JavaType getMainType() {
        ArrayList children = this.getModifiableChildrenList();
        if (children != null && !children.isEmpty()) {
            String shortName = this.getShortName();
            int index = shortName.lastIndexOf(46);
            assert (index != -1) : "Has no extension: " + shortName;
            shortName = shortName.substring(0, index);
            for (NamedElement nextChild : children) {
                if (!(nextChild instanceof JavaType) || ((JavaType)nextChild).hasFlag(JavaElementFlag.NESTED) || !((JavaType)nextChild).getShortName().equals(shortName)) continue;
                return (JavaType)nextChild;
            }
        }
        return null;
    }

    public final IStructureItem getStructureItem() {
        return JavaStructureItem.JAVA_COMPILATION_UNIT;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitJavaCompilationUnit(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitJavaCompilationUnit(JavaCompilationUnit var1);
    }
}

