/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.path;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.utilities.StringUtility;

public final class JavaSupportingFileType
extends Enum<JavaSupportingFileType>
implements IFileType {
    public static final /* enum */ JavaSupportingFileType INTELLIJ_PROJECT_FILE = new JavaSupportingFileType("IntelliJ Project File", ".ipr");
    public static final /* enum */ JavaSupportingFileType JAR_FILE = new JavaSupportingFileType("Jar File", ".jar");
    private final String m_presentationName;
    private final String[] m_extensions;
    private static final /* synthetic */ JavaSupportingFileType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new JavaSupportingFileType[]{INTELLIJ_PROJECT_FILE, JAR_FILE};
    }

    private JavaSupportingFileType(String presentationName, String ... extensions) {
        assert (presentationName != null) : "Parameter 'presentationName' of method 'JavaFileType' must not be null";
        assert (extensions != null && extensions.length > 0) : "Parameter 'extensions' of method 'JavaFileType' must not be empty";
        this.m_presentationName = presentationName;
        this.m_extensions = extensions;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String[] getExtensions() {
        return this.m_extensions;
    }

    public String getDefaultExtension() {
        return this.m_extensions[0];
    }

    public boolean hasExtension(String extension) {
        return FileUtility.hasExtension((IFileType)this, (String)extension);
    }

    public boolean endsWith(String name) {
        assert (name != null) : "'name' must not be null";
        String[] stringArray = this.m_extensions;
        int n2 = this.m_extensions.length;
        int n3 = 0;
        while (n3 < n2) {
            String nextExtension = stringArray[n3];
            if (name.endsWith(nextExtension)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static JavaSupportingFileType[] values() {
        JavaSupportingFileType[] javaSupportingFileTypeArray = ENUM$VALUES;
        int n2 = javaSupportingFileTypeArray.length;
        JavaSupportingFileType[] javaSupportingFileTypeArray2 = new JavaSupportingFileType[n2];
        System.arraycopy(ENUM$VALUES, 0, javaSupportingFileTypeArray2, 0, n2);
        return javaSupportingFileTypeArray2;
    }

    public static JavaSupportingFileType valueOf(String string) {
        return Enum.valueOf(JavaSupportingFileType.class, string);
    }
}

