/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.path;

import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public final class JavaFileType
extends Enum<JavaFileType>
implements IFileType {
    public static final /* enum */ JavaFileType CLASS_FILE = new JavaFileType("Class File", ".class");
    public static final /* enum */ JavaFileType JAVA_FILE = new JavaFileType("Java File", ".java");
    public static final /* enum */ JavaFileType GROOVY_FILE = new JavaFileType("Groovy File", ".groovy", ".gvy");
    public static final /* enum */ JavaFileType KOTLIN_FILE = new JavaFileType("Kotlin File", ".kt");
    public static final /* enum */ JavaFileType ASPECTJ_FILE = new JavaFileType("AspectJ File", ".aj");
    public static final /* enum */ JavaFileType SCALA_FILE = new JavaFileType("Scala File", ".scala", ".sbt");
    private final String m_presentationName;
    private final String[] m_extensions;
    private static final String[] IGNORE;
    private static final /* synthetic */ JavaFileType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new JavaFileType[]{CLASS_FILE, JAVA_FILE, GROOVY_FILE, KOTLIN_FILE, ASPECTJ_FILE, SCALA_FILE};
        IGNORE = new String[]{"module-info.java", "module-info.class", "package-info.java", "package-info.class"};
    }

    private static boolean ignore(String fileName) {
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'ignore' must not be empty";
        String[] stringArray = IGNORE;
        int n2 = IGNORE.length;
        int n3 = 0;
        while (n3 < n2) {
            String next = stringArray[n3];
            if (next.equalsIgnoreCase(fileName)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static JavaFileType determine(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'determine' must not be empty";
        JavaFileType[] javaFileTypeArray = JavaFileType.values();
        int n2 = javaFileTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            JavaFileType nextFileType = javaFileTypeArray[n3];
            String[] stringArray = nextFileType.m_extensions;
            int n4 = nextFileType.m_extensions.length;
            int n5 = 0;
            while (n5 < n4) {
                String nextExtension = stringArray[n5];
                if (name.endsWith(nextExtension)) {
                    if (JavaFileType.ignore(name)) {
                        return null;
                    }
                    return nextFileType;
                }
                ++n5;
            }
            ++n3;
        }
        return null;
    }

    private JavaFileType(String presentationName, String ... extensions) {
        assert (presentationName != null) : "Parameter 'presentationName' of method 'JavaFileType' must not be null";
        assert (extensions != null && extensions.length > 0) : "Parameter 'extensions' of method 'JavaFileType' must not be empty";
        this.m_presentationName = presentationName;
        this.m_extensions = extensions;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String[] getExtensions() {
        return this.m_extensions;
    }

    public String getDefaultExtension() {
        return this.m_extensions[0];
    }

    public boolean hasExtension(String extension) {
        assert (extension != null) : "Parameter 'extension' of method 'hasExtension' must not be null";
        String[] stringArray = this.m_extensions;
        int n2 = this.m_extensions.length;
        int n3 = 0;
        while (n3 < n2) {
            String ext = stringArray[n3];
            if (extension.equals(ext)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean endsWith(String name) {
        assert (name != null) : "'name' must not be null";
        String[] stringArray = this.m_extensions;
        int n2 = this.m_extensions.length;
        int n3 = 0;
        while (n3 < n2) {
            String nextExtension = stringArray[n3];
            if (name.endsWith(nextExtension)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static Collection<String> getSourceFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.addAll(Arrays.asList(JAVA_FILE.getExtensions()));
        extensions.addAll(Arrays.asList(GROOVY_FILE.getExtensions()));
        extensions.addAll(Arrays.asList(KOTLIN_FILE.getExtensions()));
        extensions.addAll(Arrays.asList(ASPECTJ_FILE.getExtensions()));
        extensions.addAll(Arrays.asList(SCALA_FILE.getExtensions()));
        return extensions;
    }

    public static JavaFileType[] values() {
        JavaFileType[] javaFileTypeArray = ENUM$VALUES;
        int n2 = javaFileTypeArray.length;
        JavaFileType[] javaFileTypeArray2 = new JavaFileType[n2];
        System.arraycopy(ENUM$VALUES, 0, javaFileTypeArray2, 0, n2);
        return javaFileTypeArray2;
    }

    public static JavaFileType valueOf(String string) {
        return Enum.valueOf(JavaFileType.class, string);
    }
}

