/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.path;

import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;

public final class JavaClassFile
extends JavaFile {
    private String m_jdkVersion = "n/a";
    private int m_size = 0;

    public JavaClassFile(NamedElement parent) {
        super(parent);
    }

    public JavaClassFile(NamedElement parent, TFile file, RootDirectoryPath baseDirectory) {
        super(parent, file, baseDirectory);
    }

    public void setJdkVersion(String version) {
        assert (version != null && version.length() > 0) : "Parameter 'version' of method 'setJdkVersion' must not be empty";
        this.m_jdkVersion = version.intern();
    }

    @Property
    public String getJdkVersion() {
        return this.m_jdkVersion;
    }

    public IFileType getFileType() {
        return JavaFileType.CLASS_FILE;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    public int getSize() {
        return this.m_size;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_jdkVersion);
        writer.writeInt(this.m_size);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        if (reader.getVersion() > 8) {
            this.m_jdkVersion = reader.readString();
            this.m_size = reader.readInt();
        } else {
            this.m_size = reader.readInt();
            byte b2 = reader.readByte();
            this.m_jdkVersion = b2 < 9 ? "1." + Byte.toString(b2) : Byte.toString(b2);
        }
        if (this.m_jdkVersion != null) {
            this.m_jdkVersion = this.m_jdkVersion.intern();
        }
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitJavaClassFile(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitJavaClassFile(JavaClassFile var1);
    }
}

