/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.DirectoryScanner;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryDoesNotExist;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootPathNoReadPermission;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.RootPathNeitherAnArchiveNorDirectory;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ScanJob
extends NamedElementVisitor
implements DirectoryScanner.IFileConsumer,
JavaFile.IVisitor {
    private static final a b;
    private static a c;
    private final Map<TFile, JavaClassRootDirectoryPath> d = new LinkedHashMap<TFile, JavaClassRootDirectoryPath>();
    private final Map<TFile, JavaSourceRootDirectoryPath> e = new LinkedHashMap<TFile, JavaSourceRootDirectoryPath>();
    private final Map<String, FilePath> f = new THashMap();
    private final IWorkerContext g;
    private final ModuleDelta h;
    private final List<String> i;
    private final boolean j;
    private JavaClassRootDirectoryPath k;
    private JavaSourceRootDirectoryPath l;
    private Phase m;

    static {
        c = b = new a();
    }

    public static void a(a provider) {
        c = provider != null ? provider : b;
    }

    ScanJob(IWorkerContext workerContext, ModuleDelta delta, List<String> ignoreDirectories) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'RefreshJob' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'ScanJob' must not be null";
        assert (ignoreDirectories != null) : "Parameter 'ignoreDirectories' of method 'ScanJob' must not be null";
        this.h = delta;
        this.g = workerContext;
        this.i = ignoreDirectories;
        this.j = Platform.isCaseSensitive();
    }

    public boolean continueScanning(TFile rootPathBeingScanned, TFile path) {
        assert (path != null) : "Parameter 'path' of method 'continueScanning' must not be null";
        this.g.working("Scan directory", false);
        return !this.g.hasBeenCanceled();
    }

    public IFileType accepts(TFile file) {
        JavaFileType fileType;
        assert (file != null) : "'file' must not be null";
        assert (this.m != null) : "'m_phase' of method 'accepts' must not be null";
        if (c.a(file) && (fileType = JavaFileType.determine(file.getName())) != null) {
            return this.m.accepts(fileType) ? fileType : null;
        }
        return null;
    }

    private RootDirectoryPath a(JavaFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'getRootDirectoryPath' must not be null";
        switch (fileType) {
            case CLASS_FILE: {
                assert (this.k != null) : "'currentRootDirectory' of method 'processAddedFile' must not be null";
                return this.k;
            }
            case JAVA_FILE: 
            case GROOVY_FILE: 
            case KOTLIN_FILE: 
            case ASPECTJ_FILE: 
            case SCALA_FILE: {
                assert (this.l != null) : "'m_currentSourceRootDirectory' of method 'processAddedFile' must not be null";
                return this.l;
            }
        }
        assert (false) : "Unhandled file type: " + (Object)((Object)fileType);
        return null;
    }

    public void consume(TFile rootPathBeingScanned, TFile file, IFileType fileType) {
        assert (rootPathBeingScanned != null) : "'rootPathBeingScanned' must not be null";
        assert (file != null) : "'file' must not be null";
        assert (fileType != null) : "'fileType' must not be null";
        if (!this.g.hasBeenCanceled()) {
            this.g.working("Consume file", false);
            Long timeStamp = null;
            FilePath existingFile = this.f.get(this.j ? FileUtility.getIdentifyingPath((TFile)file) : FileUtility.getIdentifyingPath((TFile)file).toLowerCase());
            if (existingFile != null) {
                timeStamp = existingFile.getTimestamp();
                if (timeStamp.longValue() != file.lastModified()) {
                    existingFile.setTimestamp(Long.valueOf(file.lastModified()).longValue());
                    this.h.modified(existingFile);
                }
            } else {
                this.h.added(this.a((JavaFileType)fileType), fileType, file);
            }
        }
    }

    private void a(TFile rootDirectoryToScan, RootDirectoryPath rootDirectoryPath) {
        assert (rootDirectoryToScan != null) : "Parameter 'rootDirectoryToScan' of method 'checkIssues' must not be null";
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'checkIssues' must not be null";
        rootDirectoryPath.removeIssues();
        if (rootDirectoryToScan.exists()) {
            if (!FileUtility.isArchive((TFile)rootDirectoryToScan) && !rootDirectoryToScan.isDirectory()) {
                rootDirectoryPath.addIssue((Issue)new RootPathNeitherAnArchiveNorDirectory((NamedElement)rootDirectoryPath, "Path: " + rootDirectoryToScan.getAbsolutePath()));
            } else if (!rootDirectoryToScan.canRead()) {
                rootDirectoryPath.addIssue((Issue)new RootPathNoReadPermission((NamedElement)rootDirectoryPath));
            }
        } else {
            rootDirectoryPath.addIssue((Issue)new RootDirectoryDoesNotExist((NamedElement)rootDirectoryPath));
        }
    }

    private void c() {
        if (!this.d.isEmpty() || !this.e.isEmpty()) {
            this.g.working("Check issues", false);
            for (Map.Entry<TFile, JavaClassRootDirectoryPath> entry : this.d.entrySet()) {
                this.a(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<TFile, RootDirectoryPath> entry : this.e.entrySet()) {
                this.a(entry.getKey(), entry.getValue());
            }
        }
    }

    private void d() {
        if (!this.d.isEmpty() || !this.e.isEmpty()) {
            TFile nextRootDirectoryToScan;
            this.g.working("Detect modified or created files", false);
            this.g.beginBlockOfWork(this.d.size() + this.e.size());
            DirectoryScanner scanner = new DirectoryScanner(this.i, false);
            this.m = Phase.CLASS_FILES;
            for (Map.Entry<TFile, JavaClassRootDirectoryPath> entry : this.d.entrySet()) {
                if (this.g.hasBeenCanceled()) break;
                nextRootDirectoryToScan = entry.getKey();
                this.k = entry.getValue();
                if (nextRootDirectoryToScan.exists() && (FileUtility.isArchive((TFile)nextRootDirectoryToScan) || nextRootDirectoryToScan.isDirectory())) {
                    scanner.scan(nextRootDirectoryToScan, (DirectoryScanner.IFileConsumer)this);
                }
                this.k = null;
                this.g.workItemCompleted();
            }
            this.m = Phase.SOURCE_FILES;
            for (Map.Entry<TFile, RootDirectoryPath> entry : this.e.entrySet()) {
                if (this.g.hasBeenCanceled()) break;
                nextRootDirectoryToScan = entry.getKey();
                this.l = (JavaSourceRootDirectoryPath)entry.getValue();
                if (nextRootDirectoryToScan.exists() && (FileUtility.isArchive((TFile)nextRootDirectoryToScan) || nextRootDirectoryToScan.isDirectory())) {
                    scanner.scan(nextRootDirectoryToScan, (DirectoryScanner.IFileConsumer)this);
                }
                this.l = null;
                this.g.workItemCompleted();
            }
            this.m = null;
        }
    }

    private boolean a(FilePath filePath) {
        assert (filePath != null) : "Parameter 'filePath' of method 'filePathStillExists' must not be null";
        if (c.a(filePath)) {
            this.h.deleted(filePath);
            return false;
        }
        return true;
    }

    public void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        if (!this.g.hasBeenCanceled()) {
            for (NamedElement next : element.getChildrenList()) {
                next.accept((NamedElement.INamedElementVisitor)this);
            }
        }
    }

    @Override
    public void visitJavaFile(JavaFile element) {
        assert (element != null) : "Parameter 'element' of method 'visitJavaFile' must not be null";
        if (!this.g.hasBeenCanceled() && this.a(element)) {
            String nexIdentifyingPath = this.j ? FileUtility.getIdentifyingPath((TFile)element.getFile()) : FileUtility.getIdentifyingPath((TFile)element.getFile()).toLowerCase();
            this.f.put(nexIdentifyingPath, element);
        }
    }

    private void e() {
        if (!this.d.isEmpty() || !this.e.isEmpty()) {
            this.g.working("Detect deleted files", false);
            for (Map.Entry<TFile, JavaClassRootDirectoryPath> entry : this.d.entrySet()) {
                if (this.g.hasBeenCanceled()) break;
                JavaClassRootDirectoryPath nextClassRootDirectoryPath = entry.getValue();
                nextClassRootDirectoryPath.accept(this);
            }
            for (Map.Entry<TFile, RootDirectoryPath> entry : this.e.entrySet()) {
                if (this.g.hasBeenCanceled()) break;
                JavaSourceRootDirectoryPath nextSourceRootDirectoryPath = (JavaSourceRootDirectoryPath)entry.getValue();
                nextSourceRootDirectoryPath.accept(this);
            }
        }
    }

    private void f() {
        List rootDirectoryPaths = this.h.getModule().getOriginalChildren(RootDirectoryPath.class);
        if (!rootDirectoryPaths.isEmpty()) {
            this.g.working("Collect root directories", false);
            for (RootDirectoryPath nextRootDirectoryPath : rootDirectoryPaths) {
                if (this.g.hasBeenCanceled()) break;
                RootDirectoryPath nextOriginalRootDirectoryPath = nextRootDirectoryPath;
                if (!nextOriginalRootDirectoryPath.isEnabled()) continue;
                if (nextOriginalRootDirectoryPath instanceof JavaClassRootDirectoryPath) {
                    this.d.put(nextOriginalRootDirectoryPath.getFile(), (JavaClassRootDirectoryPath)nextOriginalRootDirectoryPath);
                    continue;
                }
                assert (nextOriginalRootDirectoryPath instanceof JavaSourceRootDirectoryPath) : "Unexpected class in method 'collectRootDirectories': " + nextOriginalRootDirectoryPath;
                this.e.put(nextOriginalRootDirectoryPath.getFile(), (JavaSourceRootDirectoryPath)nextOriginalRootDirectoryPath);
            }
        }
    }

    public void a() {
        this.g.setNumberOfSteps(4);
        this.f();
        this.g.endStep();
        this.c();
        this.g.endStep();
        this.e();
        this.g.endStep();
        this.d();
        this.g.endStep();
        c.a();
    }

    public static class a {
        public boolean a(TFile file) {
            assert (file != null) : "Parameter 'file' of method 'acceptInScan' must not be null";
            return true;
        }

        public boolean a(FilePath filePath) {
            assert (filePath != null) : "Parameter 'filePath' of method 'deleted' must not be null";
            return !filePath.getFile().exists();
        }

        public void a() {
        }
    }

    static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase CLASS_FILES = new Phase(new JavaFileType[]{JavaFileType.CLASS_FILE});
        public static final /* enum */ Phase SOURCE_FILES = new Phase(new JavaFileType[]{JavaFileType.JAVA_FILE, JavaFileType.GROOVY_FILE, JavaFileType.KOTLIN_FILE, JavaFileType.SCALA_FILE, JavaFileType.ASPECTJ_FILE});
        private final JavaFileType[] m_fileTypes;
        private static final /* synthetic */ Phase[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Phase[]{CLASS_FILES, SOURCE_FILES};
        }

        private Phase(JavaFileType[] fileTypes) {
            assert (fileTypes != null && fileTypes.length > 0) : "Parameter 'fileTypes' of method 'Phase' must not be empty";
            this.m_fileTypes = fileTypes;
        }

        boolean accepts(JavaFileType fileType) {
            assert (fileType != null) : "Parameter 'fileType' of method 'accepts' must not be null";
            JavaFileType[] javaFileTypeArray = this.m_fileTypes;
            int n2 = this.m_fileTypes.length;
            int n3 = 0;
            while (n3 < n2) {
                JavaFileType next = javaFileTypeArray[n3];
                if (next.equals((Object)fileType)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        public static Phase[] values() {
            Phase[] phaseArray = ENUM$VALUES;
            int n2 = phaseArray.length;
            Phase[] phaseArray2 = new Phase[n2];
            System.arraycopy(ENUM$VALUES, 0, phaseArray2, 0, n2);
            return phaseArray2;
        }

        public static Phase valueOf(String string) {
            return Enum.valueOf(Phase.class, string);
        }
    }
}

