/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.api.model;

import com.hello2morrow.sonargraph.api.java.IAnnotationValueAccess;
import com.hello2morrow.sonargraph.api.java.IJavaFieldAccess;
import com.hello2morrow.sonargraph.api.java.IJavaTypeAccess;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import java.util.List;
import java.util.stream.Collectors;

public class AnnotationValueAccess
implements IAnnotationValueAccess {
    private final AnnotationValue m_value;
    protected final IAnnotationValueAccessFactory m_annoFactory;

    protected AnnotationValueAccess(IAnnotationValueAccessFactory annoFactory, AnnotationValue value) {
        assert (annoFactory != null) : "Parameter 'annoFactory' of method 'AnnotationValueAccess' must not be null";
        assert (value != null) : "Parameter 'value' of method 'AnnotationValueAccess' must not be null";
        this.m_annoFactory = annoFactory;
        this.m_value = value;
    }

    public String getStringValue() {
        return this.m_value.asString();
    }

    public Number getNumericValue() {
        return this.m_value.asNumber();
    }

    public Boolean getBooleanValue() {
        return this.m_value.asBoolean();
    }

    public String getEnumContantName() {
        AnnotationValue.IEnumAnnotation enumAnno = this.m_value.asEnumConstant();
        if (enumAnno == null) {
            return null;
        }
        return enumAnno.getEnumFieldName();
    }

    public IJavaFieldAccess getEnumConstant() {
        AnnotationValue.IEnumAnnotation enumAnno = this.m_value.asEnumConstant();
        if (enumAnno == null) {
            return null;
        }
        return (IJavaFieldAccess)this.m_annoFactory.getFactory().createAccessObject(enumAnno.getEnumConstant());
    }

    @Deprecated
    public IJavaFieldAccess getEumConstant() {
        AnnotationValue.IEnumAnnotation enumAnno = this.m_value.asEnumConstant();
        if (enumAnno == null) {
            return null;
        }
        return (IJavaFieldAccess)this.m_annoFactory.getFactory().createAccessObject(enumAnno.getEnumConstant());
    }

    public String getClassName() {
        AnnotationValue.IClassAnnotation cls = this.m_value.asClass();
        if (cls == null) {
            return null;
        }
        return cls.getClassName();
    }

    public IJavaTypeAccess getReferencedClass() {
        AnnotationValue.IClassAnnotation cls = this.m_value.asClass();
        if (cls == null) {
            return null;
        }
        return (IJavaTypeAccess)this.m_annoFactory.getFactory().createAccessObject(cls.getType());
    }

    public List<IAnnotationValueAccess> getValueList() {
        List list = this.m_value.asList();
        if (list == null) {
            return null;
        }
        return list.stream().map(v2 -> this.m_annoFactory.create((AnnotationValue)v2)).collect(Collectors.toList());
    }

    public String toString() {
        return this.m_value.toString();
    }

    protected static interface IAnnotationValueAccessFactory {
        public AnnotationValueAccess create(AnnotationValue var1);

        public ElementAccess.IAccessFactory getFactory();
    }
}

