/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import com.hello2morrow.sonargraph.integration.access.foundation.f;
import com.hello2morrow.sonargraph.integration.access.model.ICycleGroupIssue;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyIssue;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyPattern;
import com.hello2morrow.sonargraph.integration.access.model.IDuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.integration.access.model.IElementPattern;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IMoveRefactoring;
import com.hello2morrow.sonargraph.integration.access.model.IMoveRenameRefactoring;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.INamedElementIssue;
import com.hello2morrow.sonargraph.integration.access.model.IRenameRefactoring;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.IThresholdViolationIssue;
import com.hello2morrow.sonargraph.integration.access.model.internal.AbstractResolutionImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.DependencyPatternImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementPatternImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.ProgrammingElementImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.ResolutionImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResolutionMigration {
    static final String FIELD_DESCRIPTOR = "|f";

    static boolean isPatternMigrationNeeded(f version) {
        return version.a(f.a("11.2.0")) < 0;
    }

    public static IResolution migrate(IResolution resolution, Set<INamedElement> elementsToMigrateCollector) {
        Set<ProgrammingElementImpl> fieldsOfDependencyIssues;
        assert (resolution != null) : "Parameter 'resolution' of method 'migrate' must not be null";
        assert (elementsToMigrateCollector != null) : "Parameter 'elementsToMigrateCollector' of method 'migrate' must not be null";
        if (resolution instanceof ResolutionImpl) {
            return resolution;
        }
        if (resolution instanceof IRenameRefactoring || resolution instanceof IMoveRefactoring || resolution instanceof IMoveRenameRefactoring) {
            return resolution;
        }
        if (resolution.getIssues().size() == 0) {
            return resolution;
        }
        IIssue issueProbe = resolution.getIssues().get(0);
        if (issueProbe instanceof ICycleGroupIssue || issueProbe instanceof IDuplicateCodeBlockIssue || issueProbe instanceof IThresholdViolationIssue) {
            return resolution;
        }
        Set<ProgrammingElementImpl> fieldsOfElementIssues = ResolutionMigration.getAffectedFields(resolution.getIssues(), true);
        if (!fieldsOfElementIssues.isEmpty()) {
            ArrayList<IElementPattern> migratedPatterns = new ArrayList<IElementPattern>();
            boolean elementPatternMigrationNeeded = ResolutionMigration.migrateElementPatterns(fieldsOfElementIssues, resolution.getElementPatterns(), migratedPatterns);
            if (elementPatternMigrationNeeded) {
                ((AbstractResolutionImpl)resolution).updateElementPatterns(migratedPatterns);
            }
            elementsToMigrateCollector.addAll(fieldsOfElementIssues);
        }
        if (!(fieldsOfDependencyIssues = ResolutionMigration.getAffectedFields(resolution.getIssues(), false)).isEmpty()) {
            ArrayList<IDependencyPattern> migratedDependencyPatterns = new ArrayList<IDependencyPattern>();
            boolean dependencyPatternMigrationNeeded = ResolutionMigration.migrateDependencyPatterns(fieldsOfDependencyIssues, resolution.getDependencyPatterns(), migratedDependencyPatterns);
            if (dependencyPatternMigrationNeeded) {
                ((AbstractResolutionImpl)resolution).updateDependencyPatterns(migratedDependencyPatterns);
            }
            elementsToMigrateCollector.addAll(fieldsOfDependencyIssues);
        }
        return resolution;
    }

    private static boolean migrateDependencyPatterns(Set<ProgrammingElementImpl> fields, List<IDependencyPattern> dependencyPatterns, List<IDependencyPattern> migratedDependencyPatterns) {
        boolean migrated = false;
        for (IDependencyPattern nextPattern : dependencyPatterns) {
            String fromPattern = ResolutionMigration.updatePattern(nextPattern.getFromPattern(), fields);
            String toPattern = ResolutionMigration.updatePattern(nextPattern.getToPattern(), fields);
            migratedDependencyPatterns.add(new DependencyPatternImpl(nextPattern.getType(), fromPattern, toPattern));
            boolean bl = migrated = migrated || !fromPattern.equals(nextPattern.getFromPattern()) || !toPattern.equals(nextPattern.getToPattern());
        }
        return migrated;
    }

    private static String updatePattern(String pattern, Set<ProgrammingElementImpl> fields) {
        for (ProgrammingElementImpl next : fields) {
            if (!next.getFqName().equals(pattern)) continue;
            return String.valueOf(pattern) + FIELD_DESCRIPTOR;
        }
        return pattern;
    }

    private static boolean migrateElementPatterns(Set<ProgrammingElementImpl> fields, List<IElementPattern> elementPatterns, List<IElementPattern> migratedPatterns) {
        boolean migrated = false;
        for (IElementPattern nextPattern : elementPatterns) {
            if (nextPattern.getHash() != null) {
                migratedPatterns.add(nextPattern);
            }
            ElementPatternImpl pattern = null;
            for (INamedElement iNamedElement : fields) {
                if (!iNamedElement.getFqName().equals(nextPattern.getPattern())) continue;
                pattern = new ElementPatternImpl(nextPattern.getType(), String.valueOf(nextPattern.getPattern()) + FIELD_DESCRIPTOR);
                break;
            }
            if (pattern != null) {
                migratedPatterns.add(pattern);
                migrated = true;
                continue;
            }
            migratedPatterns.add(nextPattern);
        }
        return migrated;
    }

    private static Set<ProgrammingElementImpl> getAffectedFields(List<IIssue> issues, boolean elementIssue) {
        HashSet<ProgrammingElementImpl> fields = new HashSet<ProgrammingElementImpl>();
        for (IIssue nextIssue : issues) {
            if (elementIssue && nextIssue instanceof INamedElementIssue) {
                for (INamedElement nextElement : ((INamedElementIssue)nextIssue).getAffectedNamedElements()) {
                    ResolutionMigration.collectField(fields, nextElement);
                }
                continue;
            }
            if (elementIssue || !(nextIssue instanceof IDependencyIssue)) continue;
            IDependencyIssue depIssue = (IDependencyIssue)nextIssue;
            ResolutionMigration.collectField(fields, depIssue.getFrom());
            ResolutionMigration.collectField(fields, depIssue.getTo());
        }
        return fields;
    }

    private static void collectField(Set<ProgrammingElementImpl> fields, INamedElement element) {
        String kind;
        switch (kind = element.getKind()) {
            case "PythonField": 
            case "CSharpEvent": 
            case "CSharpField": 
            case "JavaField": 
            case "CSharpProperty": {
                assert (element instanceof ProgrammingElementImpl) : "Not a programming element: " + element;
                fields.add((ProgrammingElementImpl)element);
                break;
            }
        }
    }
}

