/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import com.hello2morrow.sonargraph.integration.access.foundation.a;
import com.hello2morrow.sonargraph.integration.access.foundation.e;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlCDataStreamWriter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPrettyPrintWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaxbAdapter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaxbAdapter.class);
    private static final String INITIALIZATION_FAILED = "Initialization failed";
    private static final String UTF8_ENCODING = "UTF-8";
    private static final AtomicBoolean JAXB_IMPLEMENTATION_VERIFIED = new AtomicBoolean(false);
    private final Unmarshaller m_reader;
    private final Marshaller m_writer;

    private static String getInfo(String info, String namespaceList, a classLoader, Exception exception) {
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'getInfo' must not be empty";
        assert (namespaceList != null && namespaceList.length() > 0) : "Parameter 'namespaceList' of method 'getInfo' must not be empty";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'getInfo' must not be null";
        assert (exception != null) : "Parameter 'exception' of method 'getInfo' must not be null";
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(info).append("] ");
        builder.append("Namepaces: ").append(namespaceList);
        builder.append(", Classloaders:");
        for (ClassLoader nextClassLoader : classLoader.a()) {
            builder.append(" <").append(nextClassLoader.getClass().getSimpleName());
            String nextName = nextClassLoader.getName();
            if (nextName != null && !nextName.isEmpty()) {
                builder.append(" (").append(nextName).append(")");
            }
            builder.append(">");
        }
        builder.append("\n").append(e.a(exception));
        return builder.toString();
    }

    private void verifyJaxbImplementation(JAXBContext jaxbContext) {
        assert (jaxbContext != null) : "Parameter 'jaxbContext' of method 'verifyJaxbImplementation' must not be null";
        if (!JAXB_IMPLEMENTATION_VERIFIED.getAndSet(true)) {
            LOGGER.debug("Using JAXBContext implementation: {}", (Object)jaxbContext.getClass().getName());
            if (!jaxbContext.getClass().getName().equals("com.sun.xml.bind.v2.runtime.JAXBContextImpl")) {
                throw new RuntimeException("Current JAXBContext implementation '" + jaxbContext.getClass().getName() + " does not match the expected implementation " + "com.sun.xml.bind.v2.runtime.JAXBContextImpl\n" + "\tCheck if the file META-INF/services/javax.xml.bind.JAXBContext exists and contains the correct entry.\n" + "\tIf used in an OSGi environment, check that the correct classloader is used.\n" + "\tCheck if a jaxb.properties file is located in the packages that contain the JAXB classes.\n" + "\tAlternatively set the System property 'javax.xml.bind.context.factory=com.sun.xml.bind.v2.ContextFactory'");
            }
        }
    }

    public JaxbAdapter(String namespace, ClassLoader classLoader, String defaultNamespaceRemap) {
        Unmarshaller createdReader;
        Marshaller createdWriter;
        assert (namespace != null && namespace.length() > 0) : "Parameter 'namespace' of method 'JaxbAdapter' must not be empty";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'JaxbAdapter' must not be null";
        a aggregatingClassLoader = classLoader instanceof a ? (a)classLoader : new a(classLoader);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (defaultNamespaceRemap != null) {
                properties.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNamespaceRemap);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((String)namespace, (ClassLoader)aggregatingClassLoader, properties);
            this.verifyJaxbImplementation(jaxbContext);
            createdWriter = jaxbContext.createMarshaller();
            createdWriter.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            createdWriter.setProperty("jaxb.encoding", (Object)UTF8_ENCODING);
            createdReader = jaxbContext.createUnmarshaller();
        }
        catch (Exception ex) {
            Object createdWriter2 = null;
            Object createdReader2 = null;
            String info = JaxbAdapter.getInfo(INITIALIZATION_FAILED, namespace, aggregatingClassLoader, ex);
            LOGGER.error(info);
            assert (false) : info;
            throw new RuntimeException(INITIALIZATION_FAILED, ex);
        }
        this.m_writer = createdWriter;
        this.m_reader = createdReader;
    }

    public JaxbAdapter(XmlPersistenceContext persistenceContext, ClassLoader classLoader) {
        Unmarshaller createdReader;
        Marshaller createdWriter;
        assert (persistenceContext != null) : "Parameter 'persistenceContext' of method 'JaxbAdapter' must not be null";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'JaxbAdapter' must not be null";
        a aggregatingClassLoader = classLoader instanceof a ? (a)classLoader : new a(classLoader);
        String namespaces = persistenceContext.getNamespaceList();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)namespaces, (ClassLoader)aggregatingClassLoader);
            this.verifyJaxbImplementation(jaxbContext);
            createdWriter = jaxbContext.createMarshaller();
            createdWriter.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            createdWriter.setProperty("jaxb.encoding", (Object)UTF8_ENCODING);
            createdReader = jaxbContext.createUnmarshaller();
            Set<URL> schemaUrls = persistenceContext.getSchemaUrls();
            Source[] sources = new Source[schemaUrls.size()];
            int i2 = 0;
            for (URL nextSchemaUrl : schemaUrls) {
                assert (nextSchemaUrl != null) : " 'nextSchemaUrl' of method 'getSchema' must not be null";
                sources[i2] = new StreamSource(nextSchemaUrl.openStream());
                ++i2;
            }
            createdReader.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(sources));
        }
        catch (Exception e2) {
            Object createdReader2 = null;
            Object createdWriter2 = null;
            String info = JaxbAdapter.getInfo(INITIALIZATION_FAILED, namespaces, aggregatingClassLoader, e2);
            LOGGER.error(info);
            assert (false) : info;
            throw new RuntimeException(INITIALIZATION_FAILED, e2);
        }
        this.m_reader = createdReader;
        this.m_writer = createdWriter;
    }

    public void setMarshalListener(Marshaller.Listener listener) {
        this.m_writer.setListener(listener);
    }

    public T load(InputStream from, ValidationEventHandler validationHandler) {
        assert (from != null) : "'from' must not be null";
        assert (validationHandler != null) : "'validationHandler' must not be null";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream bufferedIn = new BufferedInputStream(from);){
                this.m_reader.setEventHandler(validationHandler);
                return (T)this.m_reader.unmarshal((InputStream)bufferedIn);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JAXBException e2) {
            LOGGER.error("Failed to load xml file", e2);
            return null;
        }
    }

    public void save(T jaxbRoot, OutputStream out) throws IOException {
        assert (jaxbRoot != null) : "Parameter 'jaxbRoot' of method 'save' must not be null";
        assert (out != null) : "Parameter 'out' of method 'save' must not be null";
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedOutputStream bufferedOut = new BufferedOutputStream(out);){
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                XMLStreamWriter streamWriter = xmlOutputFactory.createXMLStreamWriter(bufferedOut, UTF8_ENCODING);
                XmlCDataStreamWriter cdataStreamWriter = new XmlCDataStreamWriter(streamWriter);
                XmlPrettyPrintWriter xmlPrettyWriter = new XmlPrettyPrintWriter(cdataStreamWriter);
                this.m_writer.marshal(jaxbRoot, (XMLStreamWriter)xmlPrettyWriter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JAXBException e2) {
            LOGGER.error("Saving failed", (Throwable)e2);
            throw new IOException(e2);
        }
        catch (XMLStreamException ex) {
            LOGGER.error("Saving failed", (Throwable)ex);
            throw new IOException(ex);
        }
    }
}

