/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.foundation.e;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyPattern;
import com.hello2morrow.sonargraph.integration.access.model.IElementPattern;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IMatching;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.Priority;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementImpl;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public final class ResolutionImpl
extends ElementImpl
implements IResolution {
    private static final long serialVersionUID = 6480407569513366548L;
    private final List<IIssue> issues;
    private final Priority priority;
    private final ResolutionType type;
    private final boolean isApplicable;
    private final int numberOfAffectedParserDependencies;
    private final Date dateTime;
    private final String assignee;
    private final String description;
    private final String information;
    private final int matchingElementsCount;
    private final List<IElementPattern> elementPatterns;
    private final List<IDependencyPattern> dependencyPatterns;
    private final IMatching matching;
    private final String descriptor;

    public ResolutionImpl(String fqName, ResolutionType type, Priority priority, List<IIssue> issues, int matchingElementsCount, boolean isApplicable, int numberOfAffectedParserDependencies, String description, String information, String assignee, Date dateTime, List<IElementPattern> elementPatterns, List<IDependencyPattern> dependencyPatterns, IMatching matching, String descriptor) {
        super(fqName, type != null ? type.name() : "");
        assert (type != null) : "Parameter 'type' of method 'ResolutionImpl' must not be null";
        assert (priority != null) : "Parameter 'priority' of method 'ResolutionImpl' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'ResolutionImpl' must not be null";
        assert (dateTime != null) : "Parameter 'dateTime' of method 'ResolutionImpl' must not be null";
        this.type = type;
        this.priority = priority;
        this.issues = issues;
        this.isApplicable = isApplicable;
        this.numberOfAffectedParserDependencies = numberOfAffectedParserDependencies;
        this.matchingElementsCount = matchingElementsCount;
        this.description = description != null ? description : "";
        this.information = information != null ? information : "";
        this.assignee = assignee != null ? assignee : "";
        this.dateTime = dateTime;
        this.elementPatterns = elementPatterns != null ? elementPatterns : Collections.emptyList();
        this.dependencyPatterns = dependencyPatterns != null ? dependencyPatterns : Collections.emptyList();
        this.matching = matching;
        this.descriptor = descriptor != null ? descriptor : "";
    }

    @Override
    public List<IIssue> getIssues() {
        return Collections.unmodifiableList(this.issues);
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public ResolutionType getType() {
        return this.type;
    }

    @Override
    public String getImageResourceName() {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.type.name());
        builder.append(", priority=").append(this.priority);
        builder.append(", description=").append(this.description);
        builder.append(", assignee=").append(this.assignee);
        builder.append(", date=").append(this.dateTime);
        builder.append(", applicable=").append(this.isApplicable ? "yes" : "no");
        builder.append(", number of issues=").append(this.issues.size());
        builder.append(", number of affected parser dependencies=").append(this.numberOfAffectedParserDependencies);
        builder.append(", name=").append(this.getName());
        return builder.toString();
    }

    @Override
    public boolean isApplicable() {
        return this.isApplicable;
    }

    @Override
    public boolean isTask() {
        return this.type != ResolutionType.IGNORE;
    }

    @Override
    public int getNumberOfAffectedParserDependencies() {
        return this.numberOfAffectedParserDependencies;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getInformation() {
        return this.information;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public String getDate() {
        return e.b(this.dateTime);
    }

    @Override
    public Date getCreationDate() {
        return this.dateTime;
    }

    @Override
    public int getMatchingElementsCount() {
        return this.matchingElementsCount;
    }

    @Override
    public List<IElementPattern> getElementPatterns() {
        return Collections.unmodifiableList(this.elementPatterns);
    }

    @Override
    public List<IDependencyPattern> getDependencyPatterns() {
        return Collections.unmodifiableList(this.dependencyPatterns);
    }

    @Override
    public IMatching getMatching() {
        return this.matching;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getKind() {
        return this.type.getStandardName();
    }

    @Override
    public String getPresentationKind() {
        return this.type.getPresentationName();
    }

    @Override
    public String getFqName() {
        return this.getName();
    }

    @Override
    public boolean isLocationOnly() {
        return false;
    }

    @Override
    public Optional<? extends INamedElement> getOriginalLocation() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getOriginalFqName() {
        return Optional.empty();
    }
}

