/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IIssueCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricProvider;
import com.hello2morrow.sonargraph.integration.access.model.internal.BasicSoftwareSystemInfoImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.SingleExportMetaDataImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class MetaDataAccessImpl
implements Serializable {
    private static final long serialVersionUID = 5722967552130841881L;
    private final Map<String, IMetricLevel> metricLevels = new HashMap<String, IMetricLevel>();
    private final SingleExportMetaDataImpl metaData;

    public MetaDataAccessImpl(String path, String systemId, String version, long timestamp) {
        assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'MetaDataAccessImpl' must not be empty";
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'MetaDataAccessImpl' must not be empty";
        assert (version != null && version.length() > 0) : "Parameter 'version' of method 'MetaDataAccessImpl' must not be empty";
        assert (timestamp > 0L) : "Parameter 'timestamp' of method 'MetaDataAccessImpl' must be > 0";
        this.metaData = new SingleExportMetaDataImpl(new BasicSoftwareSystemInfoImpl(path, systemId, version, timestamp), path);
    }

    void addMetricId(IMetricId metricId) {
        this.metaData.addMetricId(metricId);
    }

    Map<String, IMetricId> getMetricIds() {
        return this.metaData.getMetricIds();
    }

    void addMetricLevel(IMetricLevel level) {
        assert (level != null) : "Parameter 'level' of method 'addMetricLevel' must not be null";
        assert (!this.metricLevels.containsKey(level.getName())) : "level '" + level + "' has already been added";
        this.metricLevels.put(level.getName(), level);
    }

    IMetricLevel getMetricLevel(String level) {
        assert (level != null && level.length() > 0) : "Parameter 'level' of method 'getMetricLevel' must not be empty";
        return this.metricLevels.get(level);
    }

    Map<String, IMetricLevel> getMetricLevels() {
        LinkedHashMap result = new LinkedHashMap();
        this.metricLevels.values().stream().sorted(new IMetricLevel.MetricLevelComparator()).forEach(c2 -> {
            IMetricLevel iMetricLevel = result.put(c2.getName(), c2);
        });
        return Collections.unmodifiableMap(result);
    }

    void addMetricCategory(IMetricCategory metricCategory) {
        assert (metricCategory != null) : "Parameter 'metricCategory' of method 'addMetricCategory' must not be null";
        this.metaData.addMetricCategory(metricCategory);
    }

    Map<String, IMetricCategory> getMetricCategories() {
        return this.metaData.getMetricCategories();
    }

    void addMetricProvider(IMetricProvider provider) {
        this.metaData.addMetricProvider(provider);
    }

    public Map<String, IMetricProvider> getMetricProviders() {
        return this.metaData.getMetricProviders();
    }

    public void addIssueCategory(IIssueCategory category) {
        assert (category != null) : "Parameter 'category' of method 'addIssueCategory' must not be null";
        this.metaData.addIssueCategory(category);
    }

    public Map<String, IIssueCategory> getIssueCategories() {
        return this.metaData.getIssueCategories();
    }
}

