/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.b.a;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.f;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.RefreshInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class i
implements IResourceChangeListener {
    private static final Logger b = LoggerFactory.getLogger(i.class);
    private final ISonargraphEclipsePlugin c;
    private final IEventBroker d;

    public i(ISonargraphEclipsePlugin plugin, IEventBroker eventBroker) {
        assert (plugin != null) : "Parameter 'plugin' of method 'SonargraphEclipseWorkspaceBuildEventListener' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'SonargraphEclipseWorkspaceBuildEventListener' must not be null";
        this.c = plugin;
        this.d = eventBroker;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.c.isInitialized() || !this.c.getSoftwareSystemProvider().hasSoftwareSystem() || this.c.isStopping()) {
            b.error("No system is opened, but resource change listener is still active and will be deactivated now.");
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            return;
        }
        RefreshInfo refreshInfo = this.c.getRefreshInfo();
        long start = System.currentTimeMillis();
        assert (event.getType() == 8 || event.getType() == 16) : "Only pre or post build events allowed!";
        String eventType = this.a(event);
        if (b.isDebugEnabled()) {
            b.debug("\n------------------- event type [" + eventType + "]--------------------");
        }
        if (event.getSource() instanceof IProject) {
            if (b.isTraceEnabled()) {
                b.trace("Change scope: Eclipse project");
            }
        } else if (event.getSource() instanceof IWorkspace) {
            if (b.isTraceEnabled()) {
                b.trace("Change scope: Eclipse Workspace");
            }
        } else assert (false) : "Unexpected change scope: " + event.getSource().getClass().getName();
        if (event.getType() == 8) {
            refreshInfo.clear();
        } else if (event.getType() == 16) {
            if (refreshInfo.getDeltas().isEmpty()) {
                if (b.isDebugEnabled()) {
                    b.debug("{} ms needed to check that no deltas exist and no refresh of Sonargraph system is needed", (Object)(System.currentTimeMillis() - start));
                }
            } else {
                List<ModuleDelta> deltas = refreshInfo.getDeltas().stream().filter(delta -> !delta.isEmpty()).collect(Collectors.toList());
                refreshInfo.clear();
                if (!deltas.isEmpty()) {
                    f.a(a.class);
                    f deltaRefresh = new f(this.d, this.c.getSoftwareSystemProvider(), this.c.getFileRegistry(), deltas);
                    deltaRefresh.schedule();
                    if (b.isDebugEnabled()) {
                        b.debug("{} ms needed to trigger Sonargraph refresh", (Object)(System.currentTimeMillis() - start));
                    }
                } else if (b.isDebugEnabled()) {
                    b.debug("{} ms needed to check that all deltas are empty and no refresh of Sonargraph system is needed.", (Object)(System.currentTimeMillis() - start));
                }
            }
        }
        long duration = System.currentTimeMillis() - start;
        if (b.isDebugEnabled()) {
            b.debug("\n-------------------- {} ms needed to process {} event ", (Object)duration, (Object)eventType);
        }
    }

    private String a(IResourceChangeEvent event) {
        String eventType = event.getType() == 8 ? "PRE_BUILD" : (event.getType() == 16 ? "POST_BUILD" : "UNSUPPORTED");
        return eventType;
    }
}

