/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IssueDelta;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.b.b;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.b.c;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.b.d;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.b.e;
import com.hello2morrow.sonargraph.ide.eclipse.model.IIssueToMarkerMap;
import com.hello2morrow.sonargraph.ide.eclipse.model.IMarkerProvider;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public final class MarkerController
implements IMarkerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkerController.class);
    private final IIssueToMarkerMap m_issueToMarkerMap = new a();

    void clear(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'clear' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'clear' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delete all markers.");
        }
        this.internalClearAll(systemProvider, eventBroker, null);
    }

    @Override
    public void clear(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker, Job jobToStart) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'clear' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'clear' must not be null";
        assert (jobToStart != null) : "Parameter 'jobToStart' of method 'clear' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delete all markers and start job {} afterwards.", (Object)jobToStart);
        }
        this.internalClearAll(systemProvider, eventBroker, jobToStart);
    }

    private void internalClearAll(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker, final Job jobToStart) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'clear' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'clear' must not be null";
        Job.getJobManager().cancel((Object)"com.hello2morrow.sonargraph.ide.eclipse.jobs.createMarkers");
        this.m_issueToMarkerMap.clear();
        d deleteMarkersJob = new d(eventBroker, systemProvider);
        JobChangeAdapter jobChangeListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK() && jobToStart != null) {
                    jobToStart.schedule();
                }
            }
        };
        deleteMarkersJob.addJobChangeListener((IJobChangeListener)jobChangeListener);
        deleteMarkersJob.schedule();
    }

    @Override
    public void clear(ISoftwareSystemProvider provider, IEventBroker eventBroker, IProject project) {
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'clear' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'clear' must not be null";
        assert (project != null) : "Parameter 'project' of method 'clear' must not be null";
        try {
            project.deleteMarkers("com.hello2morrow.sonargraph.ide.eclipse.marker", true, 2);
        }
        catch (CoreException e2) {
            LOGGER.error("Failed to clear markers for project '" + project + "'", (Throwable)e2);
        }
    }

    @Override
    public void refresh(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'refresh' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'refresh' must not be null";
        List allIssues = systemProvider.getSoftwareSystem().getCurrentModel().getIssueList((IIssueFilter)new IssueFilter(new IStandardEnumeration[0])).getIssues();
        b createAllMarkersJob = new b(eventBroker, systemProvider, this.m_issueToMarkerMap, new HashSet<Issue>(allIssues));
        this.internalClearAll(systemProvider, eventBroker, (Job)createAllMarkersJob);
    }

    void initForCurrentIssues(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'initForCurrentIssues' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'initForCurrentIssues' must not be null";
        List allIssues = systemProvider.getSoftwareSystem().getCurrentModel().getIssueList((IIssueFilter)new IssueFilter(new IStandardEnumeration[0])).getIssues();
        c createMarkersJob = new c(eventBroker, systemProvider, this.m_issueToMarkerMap, new HashSet<Issue>(allIssues), Collections.emptySet());
        this.internalClearAll(systemProvider, eventBroker, (Job)createMarkersJob);
    }

    void update(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker, IssueDelta virtualModelInfo) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'update' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'update' must not be null";
        assert (virtualModelInfo != null) : "Parameter 'virtualModelInfo' of method 'update' must not be null";
        c markerJob = new c(eventBroker, systemProvider, this.m_issueToMarkerMap, (Set<Issue>)new THashSet((Collection)virtualModelInfo.getIssuesAdded()), (Set<Issue>)new THashSet((Collection)virtualModelInfo.getIssuesRemoved()));
        markerJob.schedule();
    }

    @Override
    public void refreshForSystemDiff(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'createAllMarkersForSystemDiff' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'createAllMarkersForSystemDiff' must not be null";
        com.hello2morrow.sonargraph.ide.eclipse.jobs.a.a.a(com.hello2morrow.sonargraph.ide.eclipse.jobs.b.a.class);
        d deleteMarkers = new d(eventBroker, systemProvider);
        final com.hello2morrow.sonargraph.ide.eclipse.jobs.a.a createAllMarkersJob = new com.hello2morrow.sonargraph.ide.eclipse.jobs.a.a(eventBroker, systemProvider, this.m_issueToMarkerMap);
        deleteMarkers.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    MarkerController.this.m_issueToMarkerMap.clear();
                    createAllMarkersJob.schedule();
                }
            }
        });
        createAllMarkersJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    MarkerController.this.m_issueToMarkerMap.clear();
                }
            }
        });
        deleteMarkers.schedule();
    }

    void analysisFinished(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker) {
        e job = new e(eventBroker, systemProvider, this.m_issueToMarkerMap);
        job.schedule();
    }

    private static final class a
    implements IIssueToMarkerMap {
        private final Map<Issue, List<IMarker>> b = new THashMap();

        private a() {
        }

        @Override
        public synchronized List<IMarker> added(Issue issue, List<IMarker> markers) {
            assert (issue != null) : "Parameter 'issue' of method 'added' must not be null";
            List<IMarker> previous = this.b.put(issue, markers);
            return previous;
        }

        @Override
        public synchronized void clear() {
            this.b.clear();
        }

        @Override
        public synchronized List<IMarker> removed(Issue issue) {
            assert (issue != null) : "Parameter 'issue' of method 'removed' must not be null";
            List<IMarker> removed = this.b.remove(issue);
            return removed != null ? removed : Collections.emptyList();
        }

        @Override
        public synchronized int getNumberOfErrors() {
            return this.a(Severity.ERROR);
        }

        @Override
        public synchronized int getNumberOfWarnings() {
            return this.a(Severity.WARNING);
        }

        private int a(Severity severity) {
            return (int)this.b.keySet().stream().filter(i2 -> i2.getResolution() == null).filter(i2 -> i2.getSeverity() == severity).count();
        }
    }
}

