/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model.wrapper;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.ide.eclipse.model.ResourceInfo;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.AbstractIssueDto;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractIssueDiffDto
extends AbstractIssueDto {
    private final Map<TFile, Pair<IDiffElement.Change, String>> m_fileToChangeMap;
    private final IDiffElement.Change m_change;
    private final String m_changeDescription;

    public AbstractIssueDiffDto(Issue issue, ResourceInfo resouceInfo, String issueDescription, Collection<TFile> affectedPhysicalSourceFiles, IDiffElement.Change change, String changeDescription) {
        super(issue, resouceInfo, issueDescription, affectedPhysicalSourceFiles);
        this.m_fileToChangeMap = null;
        this.m_change = change;
        this.m_changeDescription = changeDescription;
    }

    public AbstractIssueDiffDto(Issue issue, ResourceInfo scope, String issueDescription, Map<TFile, Pair<IDiffElement.Change, String>> resourceFilesToChanges, IDiffElement.Change change, String changeDescription) {
        super(issue, scope, issueDescription, resourceFilesToChanges.keySet());
        assert (resourceFilesToChanges != null) : "Parameter 'resourceFilesToChanges' of method 'CycleGroupIssueDiffDto' must not be null";
        assert (change != null) : "Parameter 'change' of method 'CycleGroupIssueDiffDto' must not be null";
        assert (changeDescription != null) : "Parameter 'changeDescription' of method 'CycleGroupIssueDiffDto' must not be null";
        this.m_fileToChangeMap = resourceFilesToChanges;
        this.m_change = change;
        this.m_changeDescription = changeDescription;
    }

    public final IDiffElement.Change getChange() {
        return this.m_change;
    }

    public final IDiffElement.Change getChange(TFile sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getChange' must not be null";
        Pair<IDiffElement.Change, String> changeAndDescription = this.m_fileToChangeMap.get(sourceFile);
        assert (changeAndDescription != null) : "'changeAndDescription' must not be null for " + sourceFile;
        return (IDiffElement.Change)changeAndDescription.getFirst();
    }

    @Override
    public Severity getSeverity() {
        if (this.m_change == IDiffElement.Change.UNMODIFIED || this.m_change == IDiffElement.Change.IMPROVED) {
            return Severity.INFO;
        }
        return super.getSeverity();
    }

    protected String getChangeDescription() {
        return this.m_changeDescription;
    }

    protected String getPlainIssueDescription() {
        return super.getIssueDescription();
    }

    @Override
    public String getIssueDescription() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.m_change.getPresentationName()).append("] ");
        if (this.m_changeDescription != null && !this.m_changeDescription.trim().isEmpty()) {
            result.append(this.getId().getPresentationName()).append(": ");
            result.append(this.m_changeDescription);
        } else {
            result.append(this.getPlainIssueDescription());
        }
        return result.toString();
    }

    @Override
    public String getIssueDescription(TFile sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getIssueDescription' must not be null";
        if (this.m_fileToChangeMap != null) {
            StringBuilder result = new StringBuilder();
            result.append(this.getIssueDescription());
            Pair<IDiffElement.Change, String> changeAndDescription = this.m_fileToChangeMap.get(sourceFile);
            assert (changeAndDescription != null) : "'changeAndDescription' must not be null for " + sourceFile;
            result.append(" [").append(((IDiffElement.Change)changeAndDescription.getFirst()).getPresentationName()).append("] ");
            String description = (String)changeAndDescription.getSecond();
            if (!description.isEmpty()) {
                result.append((String)changeAndDescription.getSecond());
            }
            return result.toString();
        }
        return this.getIssueDescription();
    }
}

