/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class E4ModelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(E4ModelUtil.class);
    protected static final String BUNDLE_PREFIX = "com.hello2morrow.sonargraph.ide.eclipse";

    private E4ModelUtil() {
    }

    public static MItem findSonargraphItem(MApplication application, EModelService modelService, String itemId) {
        assert (application != null) : "Parameter 'application' of method 'findSonargraphItem' must not be null";
        assert (modelService != null) : "Parameter 'modelService' of method 'findSonargraphItem' must not be null";
        assert (itemId != null) : "Parameter 'itemId' of method 'findSonargraphItem' must not be null";
        List menuContributions = application.getMenuContributions();
        for (MMenuContribution menuContribution : menuContributions) {
            for (MMenuElement menu : menuContribution.getChildren()) {
                if (!(menu instanceof MMenu)) continue;
                for (MMenuElement menuItem : ((MMenu)menu).getChildren()) {
                    if (!itemId.equals(menuItem.getElementId()) || !(menuItem instanceof MItem)) continue;
                    return (MItem)menuItem;
                }
            }
        }
        return null;
    }

    public static Map<String, MMenuItem> findSonargraphMenuItems(EModelService modelService, MApplication application) {
        HashMap<String, MMenuItem> commandIdToMenuItem = new HashMap<String, MMenuItem>();
        for (MHandledMenuItem nextMenuItem : modelService.findElements((MUIElement)application, null, MHandledMenuItem.class, null, 125)) {
            String nextCommandId;
            MCommand nextModelCommand = nextMenuItem.getCommand();
            if (nextModelCommand == null || (nextCommandId = nextModelCommand.getElementId()) == null || !nextCommandId.startsWith(BUNDLE_PREFIX)) continue;
            LOGGER.debug("Found Command/MenuItem in MApplication: {} {}", (Object)nextCommandId, (Object)nextMenuItem.getElementId());
            commandIdToMenuItem.put(nextCommandId, (MMenuItem)nextMenuItem);
        }
        for (MPartDescriptor partDescriptor : application.getDescriptors()) {
            if (!partDescriptor.getElementId().startsWith("com.hello2morrow")) continue;
            LOGGER.debug("Found Sonargraph PartDescriptor {}", (Object)partDescriptor.getElementId());
            for (MMenu menu : partDescriptor.getMenus()) {
                for (MMenuElement menuElement : menu.getChildren()) {
                    if (!menuElement.getElementId().startsWith(BUNDLE_PREFIX) || !(menuElement instanceof MHandledMenuItem)) continue;
                    MHandledMenuItem handledItem = (MHandledMenuItem)menuElement;
                    MCommand nextModelCommand = handledItem.getCommand();
                    assert (nextModelCommand != null) : "'nextModelCommand' of method 'startupComplete' must not be null: " + handledItem.getElementId();
                    String nextCommandId = nextModelCommand.getElementId();
                    assert (nextCommandId != null && nextCommandId.length() > 0) : "Parameter 'nextCommandId' of method 'startupComplete' must not be empty";
                    if (!nextCommandId.startsWith(BUNDLE_PREFIX)) continue;
                    LOGGER.debug("Found Command/MenuItem in MPartDescriptor: {} {}", (Object)nextCommandId, (Object)handledItem.getElementId());
                    commandIdToMenuItem.put(nextCommandId, (MMenuItem)handledItem);
                }
            }
        }
        for (MMenuContribution menuContribution : application.getMenuContributions()) {
            for (MMenuElement menuElement : menuContribution.getChildren()) {
                if (!menuElement.getElementId().startsWith(BUNDLE_PREFIX) || !(menuElement instanceof MHandledMenuItem)) continue;
                MHandledMenuItem handledItem = (MHandledMenuItem)menuElement;
                MCommand nextModelCommand = handledItem.getCommand();
                assert (nextModelCommand != null) : "'nextModelCommand' of method 'startupComplete' must not be null: " + handledItem.getElementId();
                String nextCommandId = nextModelCommand.getElementId();
                assert (nextCommandId != null && nextCommandId.length() > 0) : "Parameter 'nextCommandId' of method 'startupComplete' must not be empty";
                if (!nextCommandId.startsWith(BUNDLE_PREFIX)) continue;
                LOGGER.debug("Found Command/MenuItem in MMenuContribution: {} {}", (Object)nextCommandId, (Object)handledItem.getElementId());
                commandIdToMenuItem.put(nextCommandId, (MMenuItem)handledItem);
            }
        }
        return commandIdToMenuItem;
    }
}

